/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.render;

import com.hidoni.customizableelytra.Constants;
import com.hidoni.customizableelytra.mixin.HttpTextureAccessor;
import com.hidoni.customizableelytra.mixin.HttpTextureInvoker;
import com.hidoni.customizableelytra.render.ImageTextureProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1046;
import net.minecraft.class_1049;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class TextureUtils {
    private static final Map<class_2960, class_2960> TEXTURE_CACHE = new HashMap<class_2960, class_2960>();

    private static void convertTextureToGrayscale(class_1011 nativeImage) {
        for (int x = 0; x < nativeImage.method_4307(); ++x) {
            for (int y = 0; y < nativeImage.method_4323(); ++y) {
                int pixelRGBA = nativeImage.method_4315(x, y);
                int originalRGB = pixelRGBA & 0xFFFFFF;
                int grayscale = (((originalRGB & 0xFF0000) >> 16) + ((originalRGB & 0xFF00) >> 8) + (originalRGB & 0xFF)) / 3;
                int newRGB = 65793 * grayscale;
                nativeImage.method_4305(x, y, pixelRGBA & 0xFF000000 | newRGB);
            }
        }
    }

    private static class_1011 getNativeImageFromTexture(class_2960 locationIn) {
        class_1044 texture = class_310.method_1551().method_1531().method_4619(locationIn);
        if (texture instanceof class_1043) {
            class_1043 dynamicTexture = (class_1043)texture;
            class_1011 dynamicTextureData = dynamicTexture.method_4525();
            if (dynamicTextureData != null) {
                class_1011 returnTexture = new class_1011(dynamicTextureData.method_4307(), dynamicTextureData.method_4323(), false);
                returnTexture.method_4317(dynamicTextureData);
                return returnTexture;
            }
        } else {
            if (texture instanceof class_1046) {
                File cacheFile = ((HttpTextureAccessor)texture).getCacheFile();
                if (cacheFile != null) {
                    try {
                        return ((HttpTextureInvoker)texture).callLoadTexture(new FileInputStream(cacheFile));
                    }
                    catch (FileNotFoundException e) {
                        return null;
                    }
                }
                return null;
            }
            if (texture instanceof class_1049) {
                try {
                    return ((ImageTextureProvider)texture).getImageTexture(class_310.method_1551().method_1478()).invokeGetImage();
                }
                catch (IOException e) {
                    return null;
                }
            }
        }
        return null;
    }

    private static class_2960 createGrayscaleTexture(class_2960 locationIn) {
        Constants.LOG.debug("Creating grayscale texture for: " + locationIn);
        class_1011 texture = TextureUtils.getNativeImageFromTexture(locationIn);
        if (texture == null) {
            return locationIn;
        }
        TextureUtils.convertTextureToGrayscale(texture);
        class_2960 locationOut = new class_2960("customizableelytra", "grayscale_" + locationIn.method_12832());
        class_310.method_1551().method_1531().method_4616(locationOut, (class_1044)new class_1043(texture));
        return locationOut;
    }

    public static class_2960 getGrayscale(class_2960 locationIn) {
        return TEXTURE_CACHE.computeIfAbsent(locationIn, TextureUtils::createGrayscaleTexture);
    }
}

