/*
 * Decompiled with CFR 0.152.
 */
package net.xanthian.variantchests.datagen;

import java.util.Map;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.xanthian.variantchests.block.Vanilla;
import net.xanthian.variantchests.block.compatability.AdAstra;
import net.xanthian.variantchests.block.compatability.BeachParty;
import net.xanthian.variantchests.block.compatability.BetterArcheology;
import net.xanthian.variantchests.block.compatability.BiomeMakeover;
import net.xanthian.variantchests.block.compatability.Cinderscapes;
import net.xanthian.variantchests.block.compatability.DeeperAndDarker;
import net.xanthian.variantchests.block.compatability.Desolation;
import net.xanthian.variantchests.block.compatability.Ecologics;
import net.xanthian.variantchests.block.compatability.MineCells;
import net.xanthian.variantchests.block.compatability.NaturesSpirit;
import net.xanthian.variantchests.block.compatability.Promenade;
import net.xanthian.variantchests.block.compatability.RegionsUnexplored;
import net.xanthian.variantchests.block.compatability.SnifferPlus;
import net.xanthian.variantchests.block.compatability.TechReborn;
import net.xanthian.variantchests.block.compatability.Vinery;

public class LangFileGenerator
extends FabricLanguageProvider {
    public LangFileGenerator(FabricDataOutput dataOutput) {
        super(dataOutput);
    }

    public static String generateBlockDisplayName(class_2248 block) {
        class_2960 name = class_7923.field_41175.method_10221((Object)block);
        String blockName = name.method_12832();
        int underscoreIndex = blockName.indexOf(95);
        if (underscoreIndex != -1 && underscoreIndex < blockName.length() - 1) {
            blockName = blockName.substring(underscoreIndex + 1);
        }
        String[] parts = blockName.split("_");
        StringBuilder displayName = new StringBuilder();
        for (String part : parts) {
            displayName.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1)).append(" ");
        }
        return displayName.toString().trim();
    }

    public static String generateContainerDisplayName(class_2248 block) {
        class_2960 name = class_7923.field_41175.method_10221((Object)block);
        String blockName = name.method_12832();
        int underscoreIndex = blockName.indexOf(95);
        if (underscoreIndex != -1 && underscoreIndex < blockName.length() - 1) {
            blockName = blockName.substring(underscoreIndex + 1);
        }
        String[] parts = blockName.split("_");
        StringBuilder displayName = new StringBuilder();
        for (String part : parts) {
            displayName.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1)).append(" ");
        }
        return displayName.toString().trim();
    }

    private static void registerTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder, Map<class_2960, class_2248> blockMap) {
        for (class_2248 block : blockMap.values()) {
            translationBuilder.add(block, LangFileGenerator.generateBlockDisplayName(block));
        }
    }

    private static void registerContainerTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder, Map<class_2960, class_2248> blockMap) {
        for (class_2248 block : blockMap.values()) {
            translationBuilder.add(block.method_9539().replace("block", "container"), LangFileGenerator.generateBlockDisplayName(block));
        }
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        LangFileGenerator.registerTranslations(translationBuilder, Vanilla.VANILLA_CHESTS);
        translationBuilder.add(class_2246.field_10034, "Oak Chest");
        translationBuilder.add("container.variantchests.acacia_chest", "Acacia Chest");
        translationBuilder.add("container.variantchests.bamboo_chest", "Bamboo Chest");
        translationBuilder.add("container.variantchests.birch_chest", "Birch Chest");
        translationBuilder.add("container.variantchests.cherry_chest", "Cherry Chest");
        translationBuilder.add("container.variantchests.crimson_chest", "Crimson Chest");
        translationBuilder.add("container.variantchests.dark_oak_chest", "Dark Oak Chest");
        translationBuilder.add("container.variantchests.jungle_chest", "Jungle Chest");
        translationBuilder.add("container.variantchests.mangrove_chest", "Mangrove Chest");
        translationBuilder.add("container.chest", "Oak Chest");
        translationBuilder.add("container.variantchests.spruce_chest", "Spruce Chest");
        translationBuilder.add("container.variantchests.warped_chest", "Warped Chest");
        translationBuilder.add(AdAstra.AA_GLACIAN_CHEST, "Glacian Chest");
        translationBuilder.add(BeachParty.LDBP_PALM_CHEST, "Palm Chest");
        translationBuilder.add(BetterArcheology.BA_ROTTEN_CHEST, "Rotten Chest");
        LangFileGenerator.registerTranslations(translationBuilder, BiomeMakeover.BM_CHESTS);
        LangFileGenerator.registerTranslations(translationBuilder, Cinderscapes.CS_CHESTS);
        translationBuilder.add(DeeperAndDarker.DAD_ECHO_CHEST, "Echo Chest");
        translationBuilder.add(Desolation.DS_CHARRED_CHEST, "Charred Chest");
        LangFileGenerator.registerTranslations(translationBuilder, Ecologics.ECO_CHESTS);
        translationBuilder.add(MineCells.MC_PUTRID_CHEST, "Putrid Chest");
        LangFileGenerator.registerTranslations(translationBuilder, NaturesSpirit.NS_CHESTS);
        LangFileGenerator.registerTranslations(translationBuilder, Promenade.PROM_CHESTS);
        translationBuilder.add(SnifferPlus.SP_STONE_PINE_CHEST, "Stone Pine Chest");
        translationBuilder.add(TechReborn.TR_RUBBER_CHEST, "Rubber Chest");
        translationBuilder.add(Vinery.LDV_CHERRY_CHEST, "Cherry Chest");
        LangFileGenerator.registerTranslations(translationBuilder, RegionsUnexplored.RU_CHESTS);
        translationBuilder.add("container.variantchests.aa_glacian_chest", "Glacian Chest");
        translationBuilder.add("container.variantchests.ldbp_palm_chest", "Palm Chest");
        translationBuilder.add("container.variantchests.ba_rotten_chest", "Rotten Chest");
        LangFileGenerator.registerContainerTranslations(translationBuilder, BiomeMakeover.BM_CHESTS);
        LangFileGenerator.registerContainerTranslations(translationBuilder, Cinderscapes.CS_CHESTS);
        translationBuilder.add("container.variantchests.dad_echo_chest", "Echo Chest");
        translationBuilder.add("container.variantchests.ds_charred_chest", "Charred Chest");
        LangFileGenerator.registerContainerTranslations(translationBuilder, Ecologics.ECO_CHESTS);
        translationBuilder.add("container.variantchests.mc_putrid_chest", "Putrid Chest");
        LangFileGenerator.registerContainerTranslations(translationBuilder, NaturesSpirit.NS_CHESTS);
        LangFileGenerator.registerContainerTranslations(translationBuilder, Promenade.PROM_CHESTS);
        translationBuilder.add("container.variantchests.sp_stone_pine_chest", "Stone Pine Chest");
        translationBuilder.add("container.variantchests.tr_rubber_chest", "Rubber Chest");
        translationBuilder.add("container.variantchests.ldv_cherry_chest", "Cherry Chest");
        LangFileGenerator.registerContainerTranslations(translationBuilder, RegionsUnexplored.RU_CHESTS);
    }
}

