/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutter.entity.custom;

import java.util.List;
import java.util.Random;
import net.emilsg.clutter.entity.ModEntityTypes;
import net.emilsg.clutter.entity.custom.goal.EmberTortoiseFollowParentGoal;
import net.emilsg.clutter.entity.custom.goal.EmberTortoiseLookAroundGoal;
import net.emilsg.clutter.entity.custom.goal.EmberTortoiseLookAtEntityGoal;
import net.emilsg.clutter.entity.custom.goal.EmberTortoiseMateGoal;
import net.emilsg.clutter.entity.custom.goal.EmberTortoiseMeleeGoal;
import net.emilsg.clutter.entity.custom.goal.EmberTortoiseTemptGoal;
import net.emilsg.clutter.entity.custom.goal.EmberTortoiseWanderAroundFarGoal;
import net.emilsg.clutter.entity.custom.parent.ClutterAnimalEntity;
import net.emilsg.clutter.util.ModBlockTags;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1810;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_4760;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_7134;
import org.jetbrains.annotations.Nullable;

public class EmberTortoiseEntity
extends ClutterAnimalEntity {
    private static final class_2940<Boolean> MOVING = class_2945.method_12791(EmberTortoiseEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> ATTACKING = class_2945.method_12791(EmberTortoiseEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHIELDING = class_2945.method_12791(EmberTortoiseEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> SHIELDING_DURATION = class_2945.method_12791(EmberTortoiseEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> SHIELDING_COOLDOWN = class_2945.method_12791(EmberTortoiseEntity.class, (class_2941)class_2943.field_13327);
    private static final class_1856 BREEDING_INGREDIENT = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8814});
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 shieldingAnimationState = new class_7094();
    public final class_7094 attackAnimationState = new class_7094();
    public int idleAnimationTimeout = 0;
    public int shieldingAnimationTimeout = 0;
    public int attackAnimationTimeout = 0;

    public EmberTortoiseEntity(class_1299<? extends ClutterAnimalEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
    }

    public static class_5132.class_5133 setAttributes() {
        return ClutterAnimalEntity.method_26828().method_26868(class_5134.field_23716, 80.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23721, 8.0);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.isShielding()) {
            class_1309 livingEntity = (class_1309)source.method_5529();
            class_1297 class_12972 = source.method_5526();
            if (class_12972 instanceof class_1676) {
                class_1676 projectile = (class_1676)class_12972;
                projectile.method_18799(projectile.method_18798().method_1021(-1.0));
                return false;
            }
            if (livingEntity != null && livingEntity.method_6047().method_7909() instanceof class_1810) {
                return super.method_5643(source, amount * 2.0f);
            }
            return super.method_5643(source, amount / 16.0f);
        }
        return super.method_5643(source, amount);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new EmberTortoiseMeleeGoal((class_1314)this, 1.0, true));
        this.field_6201.method_6277(3, (class_1352)new EmberTortoiseMateGoal(this, 1.2f));
        this.field_6201.method_6277(4, (class_1352)new EmberTortoiseTemptGoal(this, 1.2f, BREEDING_INGREDIENT, false));
        this.field_6201.method_6277(5, (class_1352)new EmberTortoiseFollowParentGoal(this, 1.2f));
        this.field_6201.method_6277(6, (class_1352)new EmberTortoiseWanderAroundFarGoal(this, 1.0, 0.3f));
        this.field_6201.method_6277(7, (class_1352)new EmberTortoiseLookAtEntityGoal(this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new EmberTortoiseLookAroundGoal(this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_4760.class, true));
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(MOVING, (Object)false);
        this.field_6011.method_12784(ATTACKING, (Object)false);
        this.field_6011.method_12784(SHIELDING, (Object)false);
        this.field_6011.method_12784(SHIELDING_COOLDOWN, (Object)0);
        this.field_6011.method_12784(SHIELDING_DURATION, (Object)400);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0 && !this.isMoving() && !this.isShielding()) {
            this.idleAnimationTimeout = 80;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.method_6510() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 20;
            this.attackAnimationState.method_41322(this.field_6012);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.method_6510()) {
            this.attackAnimationState.method_41325();
        }
        if (this.isShielding() && this.shieldingAnimationTimeout <= 0) {
            this.shieldingAnimationState.method_41322(this.field_6012);
            this.shieldingAnimationTimeout = 1;
        } else if (!this.isShielding()) {
            this.shieldingAnimationTimeout = 0;
        }
    }

    public void method_6005(double strength, double x, double z) {
        super.method_6005(0.0, x, z);
    }

    public boolean method_5810() {
        return !this.isShielding();
    }

    protected void method_48565(float v) {
        float f = this.method_18376() == class_4050.field_18076 ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.field_42108.method_48568(f, 0.2f);
    }

    public boolean method_5957(class_4538 world) {
        return world.method_8606((class_1297)this);
    }

    public boolean method_5979(class_1936 world, class_3730 spawnReason) {
        return true;
    }

    public static boolean isValidNaturalSpawn(class_1299<? extends class_1429> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(ModBlockTags.EMBER_TORTOISES_SPAWN_ON);
    }

    public boolean method_6510() {
        return (Boolean)this.field_6011.method_12789(ATTACKING);
    }

    public void method_19540(boolean attacking) {
        this.field_6011.method_12778(ATTACKING, (Object)attacking);
    }

    @Override
    public boolean isMoving() {
        return (Boolean)this.field_6011.method_12789(MOVING);
    }

    @Override
    public void setMoving(boolean moving) {
        this.field_6011.method_12778(MOVING, (Object)moving);
    }

    public boolean isShielding() {
        return (Boolean)this.field_6011.method_12789(SHIELDING);
    }

    public void setShielding(boolean shielding) {
        this.field_6011.method_12778(SHIELDING, (Object)shielding);
    }

    public int getShieldingCooldown() {
        return (Integer)this.field_6011.method_12789(SHIELDING_COOLDOWN);
    }

    public void setShieldingCooldown(int shieldingCooldown) {
        this.field_6011.method_12778(SHIELDING_COOLDOWN, (Object)shieldingCooldown);
    }

    public int getShieldingDuration() {
        return (Integer)this.field_6011.method_12789(SHIELDING_DURATION);
    }

    public void setShieldingDuration(int shieldingDuration) {
        this.field_6011.method_12778(SHIELDING_DURATION, (Object)shieldingDuration);
    }

    @Override
    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)ModEntityTypes.EMBER_TORTOISE.method_5883((class_1937)world);
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * 0.4f;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Shielding", this.isShielding());
        nbt.method_10569("ShieldingDuration", this.getShieldingDuration());
        nbt.method_10569("ShieldingCooldown", this.getShieldingCooldown());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setShielding(nbt.method_10577("Shielding"));
        this.setShieldingDuration(nbt.method_10550("ShieldingDuration"));
        this.setShieldingCooldown(nbt.method_10550("ShieldingCooldown"));
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            class_2338 newPos;
            class_2338 oldPos = this.method_24515();
            this.setMoving(oldPos != (newPos = this.method_24515()));
        }
    }

    public boolean method_5753() {
        return true;
    }

    public void method_5773() {
        super.method_5773();
        class_1937 world = this.method_37908();
        if (this.method_5805() && this.method_6032() <= this.method_6063() / 4.0f && this.getShieldingCooldown() <= 0 && !world.method_8608()) {
            this.setShielding(true);
            this.setShieldingDuration((this.field_5974.method_39332(4, 8) + 1) * 100);
            this.setShieldingCooldown(2400);
        } else if (this.method_5805() && this.getShieldingDuration() <= 0 && !world.method_8608()) {
            this.setShielding(false);
        }
        if (this.isShielding() && world.field_9236) {
            class_243 entityPos = this.method_19538();
            Random random = new Random();
            int numberOfParticles = 10;
            for (int i = 0; i < numberOfParticles; ++i) {
                double velocityX = (random.nextDouble() - 0.5) * 0.4;
                double velocityY = (random.nextDouble() - 0.5) * 0.4;
                double velocityZ = (random.nextDouble() - 0.5) * 0.4;
                world.method_8406((class_2394)(random.nextBoolean() ? class_2398.field_11240 : class_2398.field_27783), entityPos.field_1352, entityPos.field_1351 + 1.0, entityPos.field_1350, velocityX, velocityY, velocityZ);
            }
        }
        if (this.isShielding() && !world.method_8608()) {
            this.setShieldingDuration(this.getShieldingDuration() - 1);
            List nearbyEntities = world.method_8390(class_1309.class, new class_238(this.method_24515()).method_1014(3.0), e -> true);
            if (nearbyEntities != null) {
                for (class_1309 entity : nearbyEntities) {
                    entity.method_33572(true);
                    entity.method_20803(100);
                }
            }
        }
        if (!world.method_8608() && this.method_6032() < this.method_6063() && this.field_5974.method_43048(200) == 0 && this.method_37908().method_44013() == class_7134.field_37667 && this.method_5805()) {
            this.method_6033((int)(this.method_6032() + 1.0f));
        }
        if (world.field_9236) {
            this.setupAnimationStates();
        }
    }

    public boolean method_5655() {
        return this.isShielding();
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(class_1802.field_8814);
    }
}

