/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.ISerializable;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

class ReaderKey<ObjectType, ValueType>
implements ISerializable<ObjectType> {
    final String id;
    final IReader<ValueType> reader;
    final Function<ObjectType, ValueType> getter;
    final BiConsumer<ObjectType, ValueType> setter;

    public ReaderKey(String id, IReader<ValueType> reader, Function<ObjectType, ValueType> getter, BiConsumer<ObjectType, ValueType> setter) {
        this.id = id;
        this.reader = reader;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public <JsonType extends JsonElement> JsonType writeJson(ObjectType object, JsonType json) {
        JsonObject jsonObject = json.getAsJsonObject();
        JsonElement subjson = this.reader.writeJson(this.getter.apply(object));
        if (subjson != null) {
            jsonObject.add(this.id, subjson);
        }
        return json;
    }

    @Override
    public class_2540 writeBuffer(ObjectType object, class_2540 buffer) {
        this.reader.writeBuffer(buffer, this.getter.apply(object));
        return buffer;
    }

    @Override
    public <TagType extends class_2520> TagType writeTag(ObjectType object, TagType tag) {
        class_2487 compoundTag = (class_2487)tag;
        class_2520 subtag = this.reader.writeTag(this.getter.apply(object));
        if (subtag != null) {
            compoundTag.method_10566(this.id, subtag);
        }
        return tag;
    }

    @Override
    public ObjectType readJson(ObjectType object, JsonElement json) {
        JsonObject jsonObject = json.getAsJsonObject();
        if (jsonObject.has(this.id)) {
            this.setter.accept(object, this.reader.readJson(jsonObject.get(this.id)));
        }
        return object;
    }

    @Override
    public ObjectType readBuffer(ObjectType object, class_2540 buffer) {
        this.setter.accept(object, this.reader.readBuffer(buffer));
        return object;
    }

    @Override
    public ObjectType readTag(ObjectType object, class_2520 tag) {
        class_2487 compoundTag = (class_2487)tag;
        if (compoundTag.method_10545(this.id)) {
            this.setter.accept(object, this.reader.readTag(compoundTag.method_10580(this.id)));
        }
        return object;
    }
}

