/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.emitter;

import com.majruszlibrary.math.Random;
import com.majruszlibrary.registry.Registries;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class SoundEmitter {
    static final Properties DEFAULT_PROPERTIES = new Properties(class_3419.field_15256);
    static final Map<Object, Properties> PROPERTIES = new HashMap<Object, Properties>();
    private final class_3414 event;
    private class_3419 source;
    private Supplier<class_243> position = () -> class_243.field_1353;
    private Supplier<Float> volume;
    private Supplier<Float> pitch;

    public static void setDefault(class_3414 event, Properties properties) {
        PROPERTIES.put(event, properties);
    }

    public static SoundEmitter of(Supplier<? extends class_3414> event) {
        return new SoundEmitter(event.get(), PROPERTIES.getOrDefault(event.get(), DEFAULT_PROPERTIES));
    }

    public static SoundEmitter of(class_3414 event) {
        return SoundEmitter.of(() -> event);
    }

    public static Supplier<Float> randomized(float min, float max) {
        return () -> Float.valueOf(Random.nextFloat(min, max));
    }

    public static Supplier<Float> randomized(float value) {
        return SoundEmitter.randomized(value * 0.8f, value * 1.2f);
    }

    public void emit(class_1937 level) {
        class_243 position = this.position.get();
        level.method_43128(null, position.field_1352, position.field_1351, position.field_1350, this.event, this.source, this.volume.get().floatValue(), this.pitch.get().floatValue());
    }

    public void send(class_3222 player) {
        class_243 position = this.position.get();
        player.field_13987.method_14364((class_2596)new class_2767(Registries.SOUND_EVENTS.getHolder(this.event), this.source, position.field_1352, position.field_1351, position.field_1350, this.volume.get().floatValue(), this.pitch.get().floatValue(), (long)Random.nextInt()));
    }

    public SoundEmitter source(class_3419 source) {
        this.source = source;
        return this;
    }

    public SoundEmitter position(Supplier<class_243> position) {
        this.position = position;
        return this;
    }

    public SoundEmitter position(class_243 position) {
        return this.position(() -> position);
    }

    public SoundEmitter volume(Supplier<Float> volume) {
        this.volume = volume;
        return this;
    }

    public SoundEmitter volume(float volume) {
        return this.volume(() -> Float.valueOf(volume));
    }

    public SoundEmitter pitch(Supplier<Float> pitch) {
        this.pitch = pitch;
        return this;
    }

    public SoundEmitter pitch(float pitch) {
        return this.pitch(() -> Float.valueOf(pitch));
    }

    private SoundEmitter(class_3414 event, Properties properties) {
        this.event = event;
        this.source = properties.source;
        this.volume = properties.volume;
        this.pitch = properties.pitch;
    }

    static {
        SoundEmitter.setDefault(class_3417.field_33433, new Properties(class_3419.field_15248));
        SoundEmitter.setDefault(class_3417.field_20613, new Properties(class_3419.field_15248));
        SoundEmitter.setDefault(class_3417.field_15119, new Properties(class_3419.field_15248));
        SoundEmitter.setDefault(class_3417.field_14879, new Properties(class_3419.field_15248));
        SoundEmitter.setDefault(class_3417.field_38068, new Properties(class_3419.field_15248));
        SoundEmitter.setDefault(class_3417.field_15075, new Properties(class_3419.field_15248));
        SoundEmitter.setDefault(class_3417.field_15197, new Properties(class_3419.field_15248));
    }

    public record Properties(class_3419 source, Supplier<Float> volume, Supplier<Float> pitch) {
        public Properties(class_3419 source) {
            this(source, SoundEmitter.randomized(0.7f), SoundEmitter.randomized(1.0f));
        }
    }
}

