/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.math;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_3532;

public class Range<Type extends Number>
implements Predicate<Type> {
    public static Range<Float> CHANCE = Range.of(Float.valueOf(0.0f), Float.valueOf(1.0f));
    public Type from;
    public Type to;

    public static <Type extends Number> Range<Type> of(Type from, Type to) {
        return new Range<Type>(from, to);
    }

    public static <Type extends Number> Range<Type> validated(Type from, Type to) {
        return new Range<Type>(((Comparable)((Object)to)).compareTo(from) < 0 ? to : from, to);
    }

    public String toString() {
        return String.format("%s ~ %s", this.from, this.to);
    }

    @Override
    public boolean test(Type value) {
        return this.within(value);
    }

    public boolean within(Type value) {
        return ((Comparable)this.from).compareTo(value) <= 0 && ((Comparable)this.to).compareTo(value) >= 0;
    }

    public Type clamp(Type value) {
        return ((Comparable)this.from).compareTo(value) > 0 ? this.from : (((Comparable)this.to).compareTo(value) < 0 ? this.to : value);
    }

    public Range<Type> clamp(Range<Type> value) {
        return Range.of(this.clamp(value.from), this.clamp(value.to));
    }

    public List<Type> clamp(List<Type> values) {
        for (int idx = 0; idx < values.size(); ++idx) {
            values.set(idx, this.clamp((Number)values.get(idx)));
        }
        return values;
    }

    public <KeyType> Map<KeyType, Type> clamp(Map<KeyType, Type> values) {
        values.keySet().forEach(key -> values.replace(key, this.clamp((Number)values.get(key))));
        return values;
    }

    public float lerp(float ratio) {
        return class_3532.method_16439((float)ratio, (float)((Number)this.from).floatValue(), (float)((Number)this.to).floatValue());
    }

    public double lerp(double ratio) {
        return class_3532.method_16436((double)ratio, (double)((Number)this.from).doubleValue(), (double)((Number)this.to).doubleValue());
    }

    private Range(Type from, Type to) {
        this.from = from;
        this.to = to;
    }
}

