/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.network;

import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.modhelper.ModHelper;
import com.majruszlibrary.network.INetworkPlatform;
import com.majruszlibrary.network.NetworkObject;
import com.majruszlibrary.platform.Side;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class NetworkFabric
implements INetworkPlatform {
    @Override
    public void register(ModHelper helper, List<NetworkObject<?>> objects) {
        objects.forEach(this::registerOnServer);
        Side.runOnClient(() -> () -> objects.forEach(this::registerOnClient));
    }

    @Override
    public <Type> void sendToServer(NetworkObject<Type> object, Type message) {
        ClientPlayNetworking.send((class_2960)object.id, (class_2540)Serializables.write(message, PacketByteBufs.create()));
    }

    @Override
    public <Type> void sendToClients(NetworkObject<Type> object, Type message, List<class_3222> players) {
        players.forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)object.id, (class_2540)Serializables.write(message, PacketByteBufs.create())));
    }

    private <Type> void registerOnServer(NetworkObject<Type> object) {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)object.id, (server, player, handler, buffer, responseSender) -> object.broadcastOnServer(Serializables.read(object.instance.get(), buffer), player));
    }

    @Environment(value=EnvType.CLIENT)
    private <Type> void registerOnClient(NetworkObject<Type> object) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)object.id, (client, handler, buffer, responseSender) -> object.broadcastOnClient(Serializables.read(object.instance.get(), buffer)));
    }
}

