/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.network.IPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import com.tiviacz.travelersbackpack.util.Supporters;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;

public class SupporterBadgePacket {

    public static class Clientbound
    implements IPacket<Clientbound> {
        private final boolean isEnabledForPlayer;
        private final String playerName;

        public Clientbound(boolean isEnabledForPlayer, String playerName) {
            this.isEnabledForPlayer = isEnabledForPlayer;
            this.playerName = playerName;
        }

        public static Clientbound decode(class_2540 buffer) {
            boolean isEnabledForPlayer = buffer.readBoolean();
            String playerName = buffer.method_19772();
            return new Clientbound(isEnabledForPlayer, playerName);
        }

        @Override
        public void encode(Clientbound message, class_2540 buffer) {
            buffer.writeBoolean(message.isEnabledForPlayer);
            buffer.method_10814(message.playerName);
        }

        @Override
        public class_2960 getPacketId() {
            return ModNetwork.SUPPORTER_BADGE_CLIENTBOUND_ID;
        }

        public static void handle(class_310 client, class_634 listener, class_2540 buf, PacketSender sender) {
            Clientbound message = Clientbound.decode(buf);
            client.execute(() -> {
                if (message.isEnabledForPlayer && !Supporters.SUPPORTERS.contains(message.playerName)) {
                    if (Supporters.SUPPORTERS_REFERENCE.contains(message.playerName)) {
                        Supporters.SUPPORTERS.add(message.playerName);
                    }
                } else if (!message.isEnabledForPlayer) {
                    Supporters.SUPPORTERS.remove(message.playerName);
                }
            });
        }
    }

    public static class Serverbound
    implements IPacket<Serverbound> {
        private final boolean isEnabledForPlayer;

        public Serverbound(boolean isEnabledForPlayer) {
            this.isEnabledForPlayer = isEnabledForPlayer;
        }

        public static Serverbound decode(class_2540 buffer) {
            boolean isEnabledForPlayer = buffer.readBoolean();
            return new Serverbound(isEnabledForPlayer);
        }

        @Override
        public void encode(Serverbound message, class_2540 buffer) {
            buffer.writeBoolean(message.isEnabledForPlayer);
        }

        @Override
        public class_2960 getPacketId() {
            return ModNetwork.SUPPORTER_BADGE_SERVERBOUND_ID;
        }

        public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
            Serverbound message = Serverbound.decode(buf);
            server.execute(() -> {
                if (message.isEnabledForPlayer && !Supporters.SUPPORTERS.contains(player.method_7334().getName())) {
                    if (Supporters.SUPPORTERS_REFERENCE.contains(player.method_7334().getName())) {
                        Supporters.SUPPORTERS.add(player.method_7334().getName());
                        PacketDistributorHelper.sendToAllPlayers(new Clientbound(true, player.method_7334().getName()), server);
                    }
                } else if (!message.isEnabledForPlayer) {
                    Supporters.SUPPORTERS.remove(player.method_7334().getName());
                    PacketDistributorHelper.sendToAllPlayers(new Clientbound(false, player.method_7334().getName()), server);
                }
            });
        }
    }
}

