/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.emi;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
class ViewerCategoryEmi<D>
extends EmiRecipeCategory {
    public final ViewerCategory<D> wrapped;

    public ViewerCategoryEmi(final ViewerCategory<D> category) {
        EmiRenderable emiRenderable;
        class_2960 class_29602 = category.id;
        ViewerCategory.Icon icon = category.icon;
        if (icon instanceof ViewerCategory.Icon.Stack) {
            ViewerCategory.Icon.Stack stack = (ViewerCategory.Icon.Stack)icon;
            emiRenderable = EmiStack.of((class_1799)stack.stack());
        } else {
            emiRenderable = new EmiRenderable(){

                public void render(class_332 guiGraphics, int x, int y, float delta) {
                    ViewerCategory.Icon.Texture texture = (ViewerCategory.Icon.Texture)category.icon;
                    guiGraphics.method_25291(texture.loc(), x - 1, y - 1, 0, (float)texture.u(), (float)texture.v(), 18, 18, 256, 256);
                }
            };
        }
        super(class_29602, emiRenderable);
        this.wrapped = category;
    }

    public class_2561 getName() {
        return this.wrapped.title;
    }

    private void processLayout(D recipe, final List<IngredientBuilder> inputs, final List<IngredientBuilder> outputs) {
        this.wrapped.buildLayout(recipe, new ViewerCategory.LayoutBuilder(){

            @Override
            public ViewerCategory.SlotBuilder inputSlot(int x, int y) {
                IngredientBuilder ing = new IngredientBuilder(x, y);
                inputs.add(ing);
                return ing;
            }

            @Override
            public ViewerCategory.SlotBuilder outputSlot(int x, int y) {
                IngredientBuilder ing = new IngredientBuilder(x, y);
                outputs.add(ing);
                return ing;
            }

            @Override
            public void invisibleOutput(class_1799 item) {
                IngredientBuilder ing = new IngredientBuilder(0, 0);
                ing.item(item);
                ing.isVisible = false;
                outputs.add(ing);
            }
        });
    }

    public void registerRecipes(EmiRegistry registry) {
        this.wrapped.buildRecipes(registry.getRecipeManager(), class_310.method_1551().field_1687.method_30349(), r -> registry.addRecipe((EmiRecipe)this.makeRecipe(r)));
    }

    private ViewerRecipe makeRecipe(D recipe) {
        ArrayList<IngredientBuilder> inputs = new ArrayList<IngredientBuilder>();
        ArrayList<IngredientBuilder> outputs = new ArrayList<IngredientBuilder>();
        this.processLayout(recipe, inputs, outputs);
        inputs.removeIf(b -> b.ing.isEmpty());
        outputs.removeIf(b -> b.ing.isEmpty());
        List<IngredientBuilder> catalysts = inputs.stream().filter(b -> b.isCatalyst).toList();
        inputs.removeIf(b -> b.isCatalyst);
        return new ViewerRecipe(recipe, ViewerCategoryEmi.convertInputs(inputs), ViewerCategoryEmi.convertInputs(catalysts), ViewerCategoryEmi.convertOutputs(outputs));
    }

    private static List<EmiIngredient> convertInputs(List<IngredientBuilder> list) {
        return list.stream().map(b -> b.ing).toList();
    }

    private static List<EmiStack> convertOutputs(List<IngredientBuilder> list) {
        return list.stream().flatMap(b -> b.ing.getEmiStacks().stream()).toList();
    }

    private static void createFluidSlotBackground(WidgetHolder widgets, int x, int y) {
        widgets.addDrawable(0, 0, 0, 0, (guiGraphics, mouseX, mouseY, delta) -> guiGraphics.method_25302(MachineScreen.SLOT_ATLAS, x - 1 - 4, y - 1 - 4, 18, 0, 18, 18));
    }

    private static void processIngredient(EmiRecipe recipe, WidgetHolder widgets, IngredientBuilder ing, boolean isInput) {
        if (!ing.isVisible) {
            return;
        }
        if (ing.isFluid) {
            ViewerCategoryEmi.createFluidSlotBackground(widgets, ing.x, ing.y);
        }
        SlotWidget slot = widgets.addSlot(ing.ing, ing.x - 1 - 4, ing.y - 1 - 4);
        if (!isInput) {
            slot.recipeContext(recipe);
        }
        if (!ing.hasBackground) {
            slot.drawBack(false);
        }
        if (ing.isCatalyst) {
            slot.catalyst(true);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class ViewerRecipe
    implements EmiRecipe {
        final D recipe;
        private final List<EmiIngredient> inputs;
        private final List<EmiIngredient> catalysts;
        private final List<EmiStack> outputs;

        public ViewerRecipe(D recipe, List<EmiIngredient> inputs, List<EmiIngredient> catalysts, List<EmiStack> outputs) {
            this.recipe = recipe;
            this.inputs = inputs;
            this.catalysts = catalysts;
            this.outputs = outputs;
        }

        public ViewerCategoryEmi<D> getCategory() {
            return ViewerCategoryEmi.this;
        }

        @Nullable
        public class_2960 getId() {
            class_2960 class_29602;
            Object d = this.recipe;
            if (d instanceof class_1860) {
                class_1860 r = (class_1860)d;
                class_29602 = r.method_8114();
            } else {
                class_29602 = null;
            }
            return class_29602;
        }

        public List<EmiIngredient> getInputs() {
            return this.inputs;
        }

        public List<EmiIngredient> getCatalysts() {
            return this.catalysts;
        }

        public List<EmiStack> getOutputs() {
            return this.outputs;
        }

        public int getDisplayWidth() {
            return ViewerCategoryEmi.this.wrapped.width - 8;
        }

        public int getDisplayHeight() {
            return ViewerCategoryEmi.this.wrapped.height - 8;
        }

        public void addWidgets(final WidgetHolder widgets) {
            ViewerCategoryEmi.this.wrapped.buildWidgets(this.recipe, new ViewerCategory.WidgetList(){

                @Override
                public void text(class_2561 text, float x, float y, ViewerCategory.TextAlign align, boolean shadow, boolean overrideColor, @Nullable class_2561 tooltip) {
                    class_327 font = class_310.method_1551().field_1772;
                    int width = font.method_27525((class_5348)text);
                    int alignedX = switch (align) {
                        default -> throw new IncompatibleClassChangeError();
                        case ViewerCategory.TextAlign.LEFT -> (int)x;
                        case ViewerCategory.TextAlign.CENTER -> (int)(x - (float)width / 2.0f);
                        case ViewerCategory.TextAlign.RIGHT -> (int)(x - (float)width);
                    };
                    widgets.addText(text.method_30937(), alignedX - 4, (int)y - 4, overrideColor ? -12566464 : -1, shadow);
                    if (tooltip != null) {
                        int n = (int)y;
                        Objects.requireNonNull(font);
                        this.tooltip(alignedX, n, width, 9, List.of(tooltip));
                    }
                }

                @Override
                public void arrow(int x, int y) {
                    this.texture(new MIIdentifier("textures/gui/jei/arrow.png"), x, y, 0, 17, 24, 17);
                }

                @Override
                public void texture(class_2960 loc, int x, int y, int u, int v, int width, int height) {
                    widgets.addTexture(loc, x - 4, y - 4, width, height, u, v);
                }

                @Override
                public void drawable(Consumer<class_332> widget) {
                    widgets.addDrawable(-4, -4, 0, 0, (matrices, mouseX, mouseY, delta) -> widget.accept(matrices));
                }

                @Override
                public void item(double x, double y, double w, double h, class_1935 item) {
                    EmiStack stack = EmiStack.of((class_1935)item);
                    widgets.addDrawable(-4, -4, 0, 0, (guiGraphics, mouseX, mouseY, delta) -> {
                        guiGraphics.method_51448().method_22903();
                        guiGraphics.method_51448().method_22904(x, y, 0.0);
                        guiGraphics.method_51448().method_22905((float)w / 16.0f, (float)h / 16.0f, 0.0f);
                        stack.render(guiGraphics, 0, 0, delta);
                        guiGraphics.method_51448().method_22909();
                    });
                }

                @Override
                public void tooltip(int x, int y, int w, int h, List<class_2561> tooltip) {
                    List<class_5684> mapped = tooltip.stream().map(c -> class_5684.method_32662((class_5481)c.method_30937())).toList();
                    widgets.addDrawable(x - 4, y - 4, w, h, (matrices, mouseX, mouseY, delta) -> {}).tooltip((mouseX, mouseY) -> mapped);
                }
            });
            ArrayList<IngredientBuilder> inputs = new ArrayList<IngredientBuilder>();
            ArrayList<IngredientBuilder> outputs = new ArrayList<IngredientBuilder>();
            ViewerCategoryEmi.this.processLayout(this.recipe, inputs, outputs);
            for (IngredientBuilder input : inputs) {
                ViewerCategoryEmi.processIngredient(this, widgets, input, true);
            }
            for (IngredientBuilder output : outputs) {
                ViewerCategoryEmi.processIngredient(this, widgets, output, false);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class IngredientBuilder
    implements ViewerCategory.SlotBuilder {
        private final int x;
        private final int y;
        private EmiIngredient ing = EmiStack.EMPTY;
        private boolean isFluid = false;
        private boolean hasBackground = true;
        private boolean isVisible = true;
        private boolean isCatalyst = false;

        IngredientBuilder(int x, int y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public ViewerCategory.SlotBuilder variant(TransferVariant<?> variant) {
            if (variant instanceof ItemVariant) {
                ItemVariant item = (ItemVariant)variant;
                this.item(item.toStack());
            } else if (variant instanceof FluidVariant) {
                FluidVariant fluid = (FluidVariant)variant;
                this.isFluid = true;
                this.hasBackground = false;
                if (!fluid.isBlank()) {
                    this.ing = EmiStack.of((class_3611)fluid.getFluid(), (class_2487)fluid.getNbt());
                }
            } else {
                throw new IllegalArgumentException("Unknown variant type: " + variant.getClass());
            }
            return this;
        }

        @Override
        public ViewerCategory.SlotBuilder fluid(FluidVariant fluid, long amount, float probability) {
            this.isFluid = true;
            this.hasBackground = false;
            this.ing = EmiStack.of((class_3611)fluid.getFluid(), (class_2487)fluid.getNbt(), (long)amount);
            this.processProbability(probability);
            return this;
        }

        private void processProbability(float probability) {
            if (probability == 0.0f) {
                this.markCatalyst();
            } else {
                this.ing.setChance(probability);
            }
        }

        @Override
        public ViewerCategory.SlotBuilder item(class_1799 stack, float probability) {
            this.ing = EmiStack.of((class_1799)stack);
            this.processProbability(probability);
            return this;
        }

        @Override
        public ViewerCategory.SlotBuilder ingredient(class_1856 ingredient, long amount, float probability) {
            this.ing = EmiIngredient.of((class_1856)ingredient, (long)amount);
            this.processProbability(probability);
            return this;
        }

        @Override
        public ViewerCategory.SlotBuilder removeBackground() {
            this.hasBackground = false;
            return this;
        }

        @Override
        public ViewerCategory.SlotBuilder markCatalyst() {
            this.isCatalyst = true;
            return this;
        }
    }
}

