/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.waila.server;

import aztech.modern_industrialization.api.machine.component.CrafterAccess;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.component.FluidAccess;
import aztech.modern_industrialization.api.machine.component.InventoryAccess;
import aztech.modern_industrialization.api.machine.component.ItemAccess;
import aztech.modern_industrialization.api.machine.holder.CrafterComponentHolder;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.api.machine.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.api.machine.holder.FluidStorageComponentHolder;
import aztech.modern_industrialization.api.machine.holder.MultiblockInventoryComponentHolder;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import java.util.List;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.data.EnergyData;
import mcp.mobius.waila.api.data.FluidData;
import mcp.mobius.waila.api.data.ItemData;
import mcp.mobius.waila.api.data.ProgressData;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;

public class MachineComponentProvider
implements IDataProvider<MachineBlockEntity> {
    public void appendData(IDataWriter data, IServerAccessor<MachineBlockEntity> accessor, IPluginConfig config) {
        MachineBlockEntity machine = (MachineBlockEntity)accessor.getTarget();
        data.add(EnergyData.class, res -> {
            if (machine instanceof EnergyListComponentHolder) {
                EnergyListComponentHolder holder = (EnergyListComponentHolder)((Object)machine);
                List<? extends EnergyAccess> components = holder.getEnergyComponents();
                if (!components.isEmpty()) {
                    long stored = 0L;
                    long capacity = 0L;
                    for (EnergyAccess energyAccess : components) {
                        stored += energyAccess.getEu();
                        capacity += energyAccess.getCapacity();
                    }
                    res.add((IData)EnergyData.of((double)stored, (double)capacity));
                }
            } else if (machine instanceof EnergyComponentHolder) {
                EnergyComponentHolder holder = (EnergyComponentHolder)((Object)machine);
                EnergyAccess component = holder.getEnergyComponent();
                res.add((IData)EnergyData.of((double)component.getEu(), (double)component.getCapacity()));
            }
            res.block();
        });
        data.add(FluidData.class, res -> {
            if (machine instanceof MultiblockInventoryComponentHolder) {
                MultiblockInventoryComponentHolder holder = (MultiblockInventoryComponentHolder)((Object)machine);
                InventoryAccess component = holder.getMultiblockInventoryComponent();
                List<? extends FluidAccess> inputs = component.getFluidInputs();
                List<? extends FluidAccess> outputs = component.getFluidOutputs();
                if (!inputs.isEmpty() || !outputs.isEmpty()) {
                    FluidData fluidData = FluidData.of((FluidData.Unit)FluidData.Unit.DROPLETS, (int)(inputs.size() + outputs.size()));
                    this.addFluids(fluidData, inputs);
                    this.addFluids(fluidData, outputs);
                    res.add((IData)fluidData);
                }
            } else if (machine instanceof FluidStorageComponentHolder) {
                FluidStorageComponentHolder holder = (FluidStorageComponentHolder)((Object)machine);
                FluidAccess component = holder.getFluidStorageComponent();
                if (component != null) {
                    FluidVariant fluid = component.getVariant();
                    res.add((IData)FluidData.of((FluidData.Unit)FluidData.Unit.DROPLETS).add(fluid.getFluid(), fluid.getNbt(), (double)component.getAmount(), (double)component.getCapacity()));
                }
            } else {
                List<ConfigurableFluidStack> stacks = machine.getInventory().getFluidStacks();
                FluidData fluidData = FluidData.of((FluidData.Unit)FluidData.Unit.DROPLETS, (int)stacks.size());
                this.addFluids(fluidData, stacks);
                res.add((IData)fluidData);
            }
            res.block();
        });
        data.add(ItemData.class, res -> {
            if (machine instanceof MultiblockInventoryComponentHolder) {
                MultiblockInventoryComponentHolder holder = (MultiblockInventoryComponentHolder)((Object)machine);
                InventoryAccess component = holder.getMultiblockInventoryComponent();
                List<? extends ItemAccess> inputs = component.getItemInputs();
                List<? extends ItemAccess> outputs = component.getItemOutputs();
                if (!inputs.isEmpty() || !outputs.isEmpty()) {
                    ItemData itemData = ItemData.of((IPluginConfig)config);
                    this.addItems(itemData, inputs);
                    this.addItems(itemData, outputs);
                    res.add((IData)itemData);
                }
            } else {
                ItemData itemData = ItemData.of((IPluginConfig)config);
                this.addItems(itemData, machine.getInventory().getItemStacks());
                res.add((IData)itemData);
            }
            res.block();
        });
        data.add(ProgressData.class, res -> {
            CrafterComponentHolder holder;
            CrafterAccess component;
            float progress;
            if (machine instanceof CrafterComponentHolder && (progress = (component = (holder = (CrafterComponentHolder)((Object)machine)).getCrafterComponent()).getProgress()) > 0.0f) {
                InventoryAccess inventory = component.getInventory();
                ProgressData progressData = ProgressData.ratio((float)progress);
                for (ItemAccess itemAccess : inventory.getItemInputs()) {
                    progressData.input(itemAccess.toStack());
                }
                for (ItemAccess itemAccess : inventory.getItemOutputs()) {
                    progressData.output(itemAccess.toStack());
                }
                res.add((IData)progressData);
            }
            res.block();
        });
    }

    private void addFluids(FluidData data, List<? extends FluidAccess> stacks) {
        for (FluidAccess fluidAccess : stacks) {
            data.add(fluidAccess.getVariant().getFluid(), fluidAccess.getVariant().getNbt(), (double)fluidAccess.getAmount(), (double)fluidAccess.getCapacity());
        }
    }

    private void addItems(ItemData data, List<? extends ItemAccess> stacks) {
        data.ensureSpace(stacks.size());
        for (ItemAccess itemAccess : stacks) {
            data.add(itemAccess.toStack());
        }
    }
}

