/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.texture;

import aztech.modern_industrialization.resource.FastPathPackResources;
import aztech.modern_industrialization.textures.MITextures;
import com.google.common.hash.Hashing;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import net.minecraft.class_2405;
import net.minecraft.class_3264;
import net.minecraft.class_5912;
import net.minecraft.class_6861;
import net.minecraft.class_7403;
import net.minecraft.class_7665;

@Environment(value=EnvType.CLIENT)
public record TexturesProvider(FabricDataOutput packOutput, boolean runtimeDatagen) implements class_2405
{
    public CompletableFuture<?> method_10319(class_7403 cache) {
        ArrayList<Object> packs = new ArrayList<Object>();
        packs.add(new class_7665().method_45206(new String[]{"minecraft"}).method_45197().method_45210());
        if (this.runtimeDatagen) {
            ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer("modern_industrialization").get();
            packs.add(ModNioResourcePack.create((String)"mi:runtimedatagen", (ModContainer)container, null, (class_3264)class_3264.field_14188, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED));
            Path extra = FabricLoader.getInstance().getGameDir().resolve("modern_industrialization").resolve("extra_datagen_resources");
            packs.add((Object)new FastPathPackResources("extra", extra, true));
        } else {
            Path nonGeneratedResources = this.packOutput.method_45971().resolve("../../main/resources");
            packs.add((Object)new FastPathPackResources("nonGen", nonGeneratedResources, true));
        }
        ArrayList jsonSaveFutures = new ArrayList();
        class_6861 fallbackProvider = new class_6861(class_3264.field_14188, packs);
        return ((CompletableFuture)this.generateTextures(cache, (class_5912)fallbackProvider, jsonSaveFutures::add).whenComplete((result, throwable) -> fallbackProvider.close())).thenRunAsync(() -> CompletableFuture.allOf((CompletableFuture[])jsonSaveFutures.toArray(CompletableFuture[]::new)), class_156.method_18349());
    }

    private CompletableFuture<?> generateTextures(class_7403 cache, class_5912 fallbackResourceProvider, Consumer<CompletableFuture<?>> futureList) {
        Path generatedResources = this.packOutput.method_45971();
        List<FastPathPackResources> generatedPack = List.of(new FastPathPackResources("gen", generatedResources, true));
        class_6861 outputPack = new class_6861(class_3264.field_14188, generatedPack);
        return MITextures.offerTextures((image, textureId) -> this.writeTexture(cache, (class_1011)image, (String)textureId), (json, path) -> futureList.accept(this.customJsonSave(cache, (JsonElement)json, (String)path)), resourceLocation -> {
            Optional generated = outputPack.method_14486(resourceLocation);
            if (generated.isPresent()) {
                return generated;
            }
            return fallbackResourceProvider.method_14486(resourceLocation);
        }).whenComplete((result, throwable) -> outputPack.close());
    }

    private void writeTexture(class_7403 cache, class_1011 image, String textureId) {
        try {
            Path path = this.packOutput.method_45971().resolve("assets").resolve(textureId.replace(':', '/'));
            cache.method_43346(path, image.method_24036(), Hashing.sha1().hashBytes(image.method_24036()));
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write texture " + textureId, ex);
        }
    }

    private CompletableFuture<?> customJsonSave(class_7403 cache, JsonElement jsonElement, String path) {
        Path pathFormatted = this.packOutput.method_45971().resolve("assets").resolve(path.replace(':', '/'));
        return class_2405.method_10320((class_7403)cache, (JsonElement)jsonElement, (Path)pathFormatted);
    }

    public String method_10321() {
        return "Textures";
    }
}

