/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.ModernIndustrialization;
import aztech.modern_industrialization.api.machine.component.CrafterAccess;
import aztech.modern_industrialization.api.machine.component.InventoryAccess;
import aztech.modern_industrialization.inventory.AbstractConfigurableStack;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import aztech.modern_industrialization.stats.PlayerStatistics;
import aztech.modern_industrialization.stats.PlayerStatisticsData;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class CrafterComponent
implements IComponent.ServerOnly,
CrafterAccess {
    private final MachineProcessCondition.Context conditionContext;
    private final Inventory inventory;
    private final Behavior behavior;
    private MachineRecipe activeRecipe = null;
    private class_2960 delayedActiveRecipe;
    private long usedEnergy;
    private long recipeEnergy;
    private long recipeMaxEu;
    private int efficiencyTicks;
    private int maxEfficiencyTicks;
    private long previousBaseEu = -1L;
    private long previousMaxEu = -1L;
    private int lastInvHash = 0;
    private int lastForcedTick = 0;

    public CrafterComponent(MachineBlockEntity blockEntity, Inventory inventory, Behavior behavior) {
        this.inventory = inventory;
        this.behavior = behavior;
        this.conditionContext = () -> blockEntity;
    }

    @Override
    public float getProgress() {
        return (float)this.usedEnergy / (float)this.recipeEnergy;
    }

    @Override
    public int getEfficiencyTicks() {
        return this.efficiencyTicks;
    }

    @Override
    public int getMaxEfficiencyTicks() {
        return this.maxEfficiencyTicks;
    }

    @Override
    public boolean hasActiveRecipe() {
        return this.activeRecipe != null;
    }

    @Override
    public Inventory getInventory() {
        return this.inventory;
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    public void decreaseEfficiencyTicks() {
        this.efficiencyTicks = Math.max(this.efficiencyTicks - 1, 0);
        this.clearActiveRecipeIfPossible();
    }

    public void increaseEfficiencyTicks(int increment) {
        this.efficiencyTicks = Math.min(this.efficiencyTicks + increment, this.maxEfficiencyTicks);
    }

    @Override
    public long getCurrentRecipeEu() {
        Preconditions.checkArgument((boolean)this.hasActiveRecipe());
        return this.recipeMaxEu;
    }

    @Override
    public long getBaseRecipeEu() {
        Preconditions.checkArgument((boolean)this.hasActiveRecipe());
        return this.activeRecipe.eu;
    }

    public boolean tickRecipe() {
        boolean isActive;
        if (this.behavior.getCrafterWorld().method_8608()) {
            throw new IllegalStateException("May not call client side.");
        }
        boolean isEnabled = this.behavior.isEnabled();
        this.loadDelayedActiveRecipe();
        boolean recipeStarted = false;
        if (this.usedEnergy == 0L && isEnabled && this.behavior.consumeEu(1L, Simulation.SIMULATE) == 1L) {
            recipeStarted = this.updateActiveRecipe();
        }
        if (this.activeRecipe != null) {
            this.lastForcedTick = 0;
        }
        long eu = 0L;
        boolean finishedRecipe = false;
        if (this.activeRecipe != null && (this.usedEnergy > 0L || recipeStarted) && isEnabled) {
            this.recipeMaxEu = this.getRecipeMaxEu(this.activeRecipe.eu, this.recipeEnergy, this.efficiencyTicks);
            eu = this.activeRecipe.conditionsMatch(this.conditionContext) ? this.behavior.consumeEu(Math.min(this.recipeMaxEu, this.recipeEnergy - this.usedEnergy), Simulation.ACT) : 0L;
            isActive = eu > 0L;
            this.usedEnergy += eu;
            if (this.usedEnergy == this.recipeEnergy) {
                this.putItemOutputs(this.activeRecipe, false, false);
                this.putFluidOutputs(this.activeRecipe, false, false);
                this.clearLocks();
                this.usedEnergy = 0L;
                finishedRecipe = true;
            }
        } else {
            isActive = false;
        }
        if (this.activeRecipe != null && (this.previousBaseEu != this.behavior.getBaseRecipeEu() || this.previousMaxEu != this.behavior.getMaxRecipeEu())) {
            this.previousBaseEu = this.behavior.getBaseRecipeEu();
            this.previousMaxEu = this.behavior.getMaxRecipeEu();
            this.maxEfficiencyTicks = this.getRecipeMaxEfficiencyTicks(this.activeRecipe);
            this.efficiencyTicks = Math.min(this.efficiencyTicks, this.maxEfficiencyTicks);
        }
        if (finishedRecipe) {
            if (this.efficiencyTicks < this.maxEfficiencyTicks) {
                ++this.efficiencyTicks;
            }
        } else if (eu < this.recipeMaxEu && this.efficiencyTicks > 0) {
            --this.efficiencyTicks;
        }
        this.clearActiveRecipeIfPossible();
        return isActive;
    }

    private void clearActiveRecipeIfPossible() {
        if (this.efficiencyTicks == 0 && this.usedEnergy == 0L) {
            this.activeRecipe = null;
        }
    }

    public boolean tryContinueRecipe() {
        this.loadDelayedActiveRecipe();
        if (this.activeRecipe != null) {
            if (this.putItemOutputs(this.activeRecipe, true, false) && this.putFluidOutputs(this.activeRecipe, true, false)) {
                this.putItemOutputs(this.activeRecipe, true, true);
                this.putFluidOutputs(this.activeRecipe, true, true);
            } else {
                return false;
            }
        }
        return true;
    }

    private void loadDelayedActiveRecipe() {
        if (this.delayedActiveRecipe != null) {
            this.activeRecipe = this.behavior.recipeType().getRecipe(this.behavior.getCrafterWorld(), this.delayedActiveRecipe);
            this.delayedActiveRecipe = null;
            if (this.activeRecipe == null) {
                this.efficiencyTicks = 0;
                this.usedEnergy = 0L;
            }
        }
    }

    private boolean updateActiveRecipe() {
        for (MachineRecipe recipe : this.getRecipes()) {
            if (this.behavior.banRecipe(recipe) || !this.tryStartRecipe(recipe)) continue;
            if (this.activeRecipe != recipe || this.efficiencyTicks == 0) {
                this.maxEfficiencyTicks = this.getRecipeMaxEfficiencyTicks(recipe);
            }
            this.activeRecipe = recipe;
            this.usedEnergy = 0L;
            this.recipeEnergy = recipe.getTotalEu();
            this.recipeMaxEu = this.getRecipeMaxEu(recipe.eu, this.recipeEnergy, this.efficiencyTicks);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Iterable<MachineRecipe> getRecipes() {
        if (this.efficiencyTicks > 0) {
            return Collections.singletonList(this.activeRecipe);
        }
        int currentHash = this.inventory.hash();
        if (currentHash == this.lastInvHash) {
            if (this.lastForcedTick != 0) {
                --this.lastForcedTick;
                return Collections.emptyList();
            }
            this.lastForcedTick = 100;
        } else {
            this.lastInvHash = currentHash;
        }
        class_3218 serverWorld = (class_3218)this.behavior.getCrafterWorld();
        MachineRecipeType recipeType = this.behavior.recipeType();
        ArrayList<MachineRecipe> recipes = new ArrayList<MachineRecipe>(recipeType.getFluidOnlyRecipes(serverWorld));
        Iterator<ConfigurableItemStack> iterator = this.inventory.getItemInputs().iterator();
        while (iterator.hasNext()) {
            ConfigurableItemStack stack = iterator.next();
            if (stack.isEmpty()) continue;
            recipes.addAll(recipeType.getMatchingRecipes(serverWorld, ((ItemVariant)stack.getResource()).getItem()));
        }
        return recipes;
    }

    private boolean tryStartRecipe(MachineRecipe recipe) {
        if (this.takeItemInputs(recipe, true) && this.takeFluidInputs(recipe, true) && this.putItemOutputs(recipe, true, false) && this.putFluidOutputs(recipe, true, false) && recipe.conditionsMatch(this.conditionContext)) {
            this.takeItemInputs(recipe, false);
            this.takeFluidInputs(recipe, false);
            this.putItemOutputs(recipe, true, true);
            this.putFluidOutputs(recipe, true, true);
            return true;
        }
        return false;
    }

    public static double getEfficiencyOverclock(int efficiencyTicks) {
        return Math.pow(2.0, (double)efficiencyTicks / 32.0);
    }

    private long getRecipeMaxEu(long recipeEu, long totalEu, int efficiencyTicks) {
        long baseEu = Math.max(this.behavior.getBaseRecipeEu(), recipeEu);
        return Math.min(totalEu, Math.min((long)((int)Math.floor((double)baseEu * CrafterComponent.getEfficiencyOverclock(efficiencyTicks))), this.behavior.getMaxRecipeEu()));
    }

    private int getRecipeMaxEfficiencyTicks(MachineRecipe recipe) {
        long eu = recipe.eu;
        long totalEu = recipe.getTotalEu();
        int ticks = 0;
        while (this.getRecipeMaxEu(eu, totalEu, ticks) != Math.min(this.behavior.getMaxRecipeEu(), totalEu)) {
            ++ticks;
        }
        return ticks;
    }

    @Override
    public void writeNbt(class_2487 tag) {
        tag.method_10544("usedEnergy", this.usedEnergy);
        tag.method_10544("recipeEnergy", this.recipeEnergy);
        tag.method_10544("recipeMaxEu", this.recipeMaxEu);
        if (this.activeRecipe != null) {
            tag.method_10582("activeRecipe", this.activeRecipe.method_8114().toString());
        } else if (this.delayedActiveRecipe != null) {
            tag.method_10582("activeRecipe", this.delayedActiveRecipe.toString());
        }
        tag.method_10569("efficiencyTicks", this.efficiencyTicks);
        tag.method_10569("maxEfficiencyTicks", this.maxEfficiencyTicks);
    }

    @Override
    public void readNbt(class_2487 tag) {
        this.usedEnergy = tag.method_10550("usedEnergy");
        this.recipeEnergy = tag.method_10550("recipeEnergy");
        this.recipeMaxEu = tag.method_10550("recipeMaxEu");
        class_2960 class_29602 = this.delayedActiveRecipe = tag.method_10545("activeRecipe") ? new class_2960(tag.method_10558("activeRecipe")) : null;
        if (this.delayedActiveRecipe == null && this.usedEnergy > 0L) {
            this.usedEnergy = 0L;
            ModernIndustrialization.LOGGER.error("Had to set the usedEnergy of CrafterComponent to 0, but that should never happen!");
        }
        this.efficiencyTicks = tag.method_10550("efficiencyTicks");
        this.maxEfficiencyTicks = tag.method_10550("maxEfficiencyTicks");
    }

    private boolean takeItemInputs(MachineRecipe recipe, boolean simulate) {
        List<ConfigurableItemStack> baseList = this.inventory.getItemInputs();
        List<ConfigurableItemStack> stacks = simulate ? ConfigurableItemStack.copyList(baseList) : baseList;
        boolean ok = true;
        for (MachineRecipe.ItemInput input : recipe.itemInputs) {
            if (!simulate && input.probability < 1.0f && ThreadLocalRandom.current().nextFloat() >= input.probability) continue;
            int remainingAmount = input.amount;
            for (ConfigurableItemStack stack : stacks) {
                if (stack.getAmount() <= 0L || !input.matches(((ItemVariant)stack.getResource()).toStack())) continue;
                int taken = Math.min((int)stack.getAmount(), remainingAmount);
                if (taken > 0 && !simulate) {
                    this.behavior.getStatsOrDummy().addUsedItems((class_1935)((ItemVariant)stack.getResource()).getItem(), taken);
                }
                stack.decrement(taken);
                if ((remainingAmount -= taken) != 0) continue;
                break;
            }
            if (remainingAmount <= 0) continue;
            ok = false;
        }
        return ok;
    }

    protected boolean takeFluidInputs(MachineRecipe recipe, boolean simulate) {
        List<ConfigurableFluidStack> baseList = this.inventory.getFluidInputs();
        List<ConfigurableFluidStack> stacks = simulate ? ConfigurableFluidStack.copyList(baseList) : baseList;
        boolean ok = true;
        for (MachineRecipe.FluidInput input : recipe.fluidInputs) {
            if (!simulate && input.probability < 1.0f && ThreadLocalRandom.current().nextFloat() >= input.probability) continue;
            long remainingAmount = input.amount;
            for (ConfigurableFluidStack stack : stacks) {
                if (!((FluidVariant)stack.getResource()).equals(FluidVariant.of((class_3611)input.fluid))) continue;
                long taken = Math.min(remainingAmount, stack.getAmount());
                if (taken > 0L && !simulate) {
                    this.behavior.getStatsOrDummy().addUsedFluids(((FluidVariant)stack.getResource()).getFluid(), taken);
                }
                stack.decrement(taken);
                if ((remainingAmount -= taken) != 0L) continue;
                break;
            }
            if (remainingAmount <= 0L) continue;
            ok = false;
        }
        return ok;
    }

    protected boolean putItemOutputs(MachineRecipe recipe, boolean simulate, boolean toggleLock) {
        List<ConfigurableItemStack> baseList = this.inventory.getItemOutputs();
        List<ConfigurableItemStack> stacks = simulate ? ConfigurableItemStack.copyList(baseList) : baseList;
        ArrayList<Integer> locksToToggle = new ArrayList<Integer>();
        ArrayList<class_1792> lockItems = new ArrayList<class_1792>();
        boolean ok = true;
        for (MachineRecipe.ItemOutput output : recipe.itemOutputs) {
            float randFloat;
            if (output.probability < 1.0f && (simulate || (randFloat = ThreadLocalRandom.current().nextFloat()) > output.probability)) continue;
            int remainingAmount = output.amount;
            block1: for (int loopRun = 0; loopRun < 2; ++loopRun) {
                int stackId = 0;
                for (ConfigurableItemStack stack : stacks) {
                    ++stackId;
                    ItemVariant key = (ItemVariant)stack.getResource();
                    if (key.getItem() != output.item && !key.isBlank()) continue;
                    int remainingCapacity = simulate || output.probability < 1.0f ? (int)stack.getRemainingCapacityFor(ItemVariant.of((class_1935)output.item)) : output.item.method_7882() - (int)stack.getAmount();
                    int ins = Math.min(remainingAmount, remainingCapacity);
                    if (key.isBlank()) {
                        if ((stack.isMachineLocked() || stack.isPlayerLocked() || loopRun == 1) && stack.isValid(new class_1799((class_1935)output.item))) {
                            stack.setAmount(ins);
                            stack.setKey(ItemVariant.of((class_1935)output.item));
                        } else {
                            ins = 0;
                        }
                    } else {
                        stack.increment(ins);
                    }
                    remainingAmount -= ins;
                    if (ins > 0) {
                        locksToToggle.add(stackId - 1);
                        lockItems.add(output.item);
                        if (!simulate) {
                            this.behavior.getStatsOrDummy().addProducedItems((class_1935)output.item, ins);
                        }
                    }
                    if (remainingAmount != 0) continue;
                    continue block1;
                }
            }
            if (remainingAmount <= 0) continue;
            ok = false;
        }
        if (toggleLock) {
            for (int i = 0; i < locksToToggle.size(); ++i) {
                baseList.get((Integer)locksToToggle.get(i)).enableMachineLock((class_1792)lockItems.get(i));
            }
        }
        return ok;
    }

    protected boolean putFluidOutputs(MachineRecipe recipe, boolean simulate, boolean toggleLock) {
        int i;
        List<ConfigurableFluidStack> baseList = this.inventory.getFluidOutputs();
        List<ConfigurableFluidStack> stacks = simulate ? ConfigurableFluidStack.copyList(baseList) : baseList;
        ArrayList<Integer> locksToToggle = new ArrayList<Integer>();
        ArrayList<class_3611> lockFluids = new ArrayList<class_3611>();
        boolean ok = true;
        block0: for (i = 0; i < Math.min(recipe.fluidOutputs.size(), this.behavior.getMaxFluidOutputs()); ++i) {
            float randFloat;
            MachineRecipe.FluidOutput output = recipe.fluidOutputs.get(i);
            if (output.probability < 1.0f && (simulate || (randFloat = ThreadLocalRandom.current().nextFloat()) > output.probability)) continue;
            for (int tries = 0; tries < 2; ++tries) {
                for (int j = 0; j < stacks.size(); ++j) {
                    FluidVariant outputKey;
                    ConfigurableFluidStack stack = stacks.get(j);
                    if (!stack.isResourceAllowedByLock(outputKey = FluidVariant.of((class_3611)output.fluid)) || (tries != 1 || !stack.isResourceBlank()) && !((FluidVariant)stack.getResource()).equals(outputKey)) continue;
                    long inserted = Math.min(output.amount, stack.getRemainingSpace());
                    if (inserted > 0L) {
                        stack.setKey(outputKey);
                        stack.increment(inserted);
                        locksToToggle.add(j);
                        lockFluids.add(output.fluid);
                        if (!simulate) {
                            this.behavior.getStatsOrDummy().addProducedFluids(output.fluid, inserted);
                        }
                    }
                    if (inserted >= output.amount) continue block0;
                    ok = false;
                    continue block0;
                }
                if (tries != 1) continue;
                ok = false;
            }
        }
        if (toggleLock) {
            for (i = 0; i < locksToToggle.size(); ++i) {
                baseList.get((Integer)locksToToggle.get(i)).enableMachineLock((class_3611)lockFluids.get(i));
            }
        }
        return ok;
    }

    protected void clearLocks() {
        for (ConfigurableItemStack configurableItemStack : this.inventory.getItemOutputs()) {
            if (!configurableItemStack.isMachineLocked()) continue;
            configurableItemStack.disableMachineLock();
        }
        for (ConfigurableFluidStack configurableFluidStack : this.inventory.getFluidOutputs()) {
            if (!configurableFluidStack.isMachineLocked()) continue;
            configurableFluidStack.disableMachineLock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void lockRecipe(class_2960 recipeId, class_1661 inventory) {
        Optional<MachineRecipe> optionalMachineRecipe = this.behavior.recipeType().getRecipes(this.behavior.getCrafterWorld()).stream().filter(recipe -> recipe.method_8114().equals((Object)recipeId)).findFirst();
        if (optionalMachineRecipe.isEmpty()) {
            return;
        }
        MachineRecipe recipe2 = optionalMachineRecipe.get();
        block0: for (MachineRecipe.ItemInput itemInput : recipe2.itemInputs) {
            void var8_16;
            for (ConfigurableItemStack configurableItemStack : this.inventory.getItemInputs()) {
                if (!itemInput.matches(new class_1799((class_1935)configurableItemStack.getLockedInstance()))) continue;
                continue block0;
            }
            class_1792 targetItem = null;
            boolean bl = false;
            while (var8_16 < inventory.method_5439()) {
                class_1799 playerStack = inventory.method_5438((int)var8_16);
                if (!playerStack.method_7960() && itemInput.matches(new class_1799((class_1935)playerStack.method_7909()))) {
                    targetItem = playerStack.method_7909();
                    break;
                }
                ++var8_16;
            }
            if (targetItem == null) {
                for (class_1792 item : itemInput.getInputItems()) {
                    class_2960 id = class_7923.field_41178.method_10221((Object)item);
                    if (!id.method_12836().equals("modern_industrialization")) continue;
                    targetItem = item;
                    break;
                }
            }
            if (targetItem == null && itemInput.getInputItems().size() == 1) {
                targetItem = itemInput.getInputItems().get(0);
            }
            if (targetItem == null) continue;
            AbstractConfigurableStack.playerLockNoOverride(targetItem, this.inventory.getItemInputs());
        }
        block4: for (MachineRecipe.ItemOutput itemOutput : recipe2.itemOutputs) {
            for (ConfigurableItemStack configurableItemStack : this.inventory.getItemOutputs()) {
                if (configurableItemStack.getLockedInstance() != itemOutput.item) continue;
                continue block4;
            }
            AbstractConfigurableStack.playerLockNoOverride(itemOutput.item, this.inventory.getItemOutputs());
        }
        block6: for (MachineRecipe.FluidInput fluidInput : recipe2.fluidInputs) {
            for (ConfigurableFluidStack configurableFluidStack : this.inventory.getFluidInputs()) {
                if (!configurableFluidStack.isLockedTo(fluidInput.fluid)) continue;
                continue block6;
            }
            AbstractConfigurableStack.playerLockNoOverride(fluidInput.fluid, this.inventory.getFluidInputs());
        }
        block8: for (MachineRecipe.FluidOutput fluidOutput : recipe2.fluidOutputs) {
            for (ConfigurableFluidStack configurableFluidStack : this.inventory.getFluidOutputs()) {
                if (!configurableFluidStack.isLockedTo(fluidOutput.fluid)) continue;
                continue block8;
            }
            AbstractConfigurableStack.playerLockNoOverride(fluidOutput.fluid, this.inventory.getFluidOutputs());
        }
        if (recipe2.itemInputs.size() > 0 || recipe2.itemOutputs.size() > 0) {
            CrafterComponent.lockAll(this.inventory.getItemInputs());
            CrafterComponent.lockAll(this.inventory.getItemOutputs());
        }
    }

    private static void lockAll(List<? extends AbstractConfigurableStack<?, ?>> stacks) {
        for (AbstractConfigurableStack<?, ?> stack : stacks) {
            if (!stack.isEmpty() || stack.getLockedInstance() != null) continue;
            stack.togglePlayerLock();
        }
    }

    public static interface Inventory
    extends InventoryAccess {
        public List<ConfigurableItemStack> getItemInputs();

        public List<ConfigurableItemStack> getItemOutputs();

        public List<ConfigurableFluidStack> getFluidInputs();

        public List<ConfigurableFluidStack> getFluidOutputs();

        public int hash();
    }

    public static interface Behavior {
        default public boolean isEnabled() {
            return true;
        }

        public long consumeEu(long var1, Simulation var3);

        default public boolean banRecipe(MachineRecipe recipe) {
            return (long)recipe.eu > this.getMaxRecipeEu();
        }

        public MachineRecipeType recipeType();

        public long getBaseRecipeEu();

        public long getMaxRecipeEu();

        public class_1937 getCrafterWorld();

        default public int getMaxFluidOutputs() {
            return Integer.MAX_VALUE;
        }

        @Nullable
        public UUID getOwnerUuid();

        default public PlayerStatistics getStatsOrDummy() {
            UUID uuid = this.getOwnerUuid();
            if (uuid == null) {
                return PlayerStatistics.DUMMY;
            }
            return PlayerStatisticsData.get(this.getCrafterWorld().method_8503()).get(uuid);
        }
    }
}

