/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.api.machine.component.InventoryAccess;
import aztech.modern_industrialization.inventory.AbstractConfigurableStack;
import aztech.modern_industrialization.inventory.ChangeListener;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;

public class MultiblockInventoryComponent
implements CrafterComponent.Inventory,
InventoryAccess {
    private final List<ConfigurableItemStack> itemInputs = new ArrayList<ConfigurableItemStack>();
    private final List<ConfigurableItemStack> itemOutputs = new ArrayList<ConfigurableItemStack>();
    private final List<ConfigurableFluidStack> fluidInputs = new ArrayList<ConfigurableFluidStack>();
    private final List<ConfigurableFluidStack> fluidOutputs = new ArrayList<ConfigurableFluidStack>();
    private int invHash = 0;
    private final ChangeListener listener = new ChangeListener(){

        @Override
        protected void onChange() {
            ++MultiblockInventoryComponent.this.invHash;
        }

        @Override
        protected boolean isValid(Object token) {
            return true;
        }
    };

    public void rebuild(ShapeMatcher shapeMatcher) {
        ArrayList<HatchBlockEntity> sortedHatches = new ArrayList<HatchBlockEntity>(shapeMatcher.getMatchedHatches());
        sortedHatches.sort(Comparator.comparing(h -> h.method_11016().method_10264()));
        this.rebuildList(sortedHatches, this.itemInputs, HatchBlockEntity::appendItemInputs);
        this.rebuildList(sortedHatches, this.itemOutputs, HatchBlockEntity::appendItemOutputs);
        this.rebuildList(sortedHatches, this.fluidInputs, HatchBlockEntity::appendFluidInputs);
        this.rebuildList(sortedHatches, this.fluidOutputs, HatchBlockEntity::appendFluidOutputs);
        ++this.invHash;
    }

    private <T, Stack extends AbstractConfigurableStack<T, ? extends TransferVariant<T>>> void rebuildList(List<HatchBlockEntity> sortedHatches, List<Stack> stacks, BiConsumer<HatchBlockEntity, List<Stack>> appender) {
        for (AbstractConfigurableStack stack : stacks) {
            stack.removeListener(this.listener);
        }
        stacks.clear();
        for (HatchBlockEntity hatch : sortedHatches) {
            appender.accept(hatch, stacks);
        }
        this.listener.listenAll(stacks, null);
    }

    @Override
    public List<ConfigurableItemStack> getItemInputs() {
        return this.itemInputs;
    }

    @Override
    public List<ConfigurableItemStack> getItemOutputs() {
        return this.itemOutputs;
    }

    @Override
    public List<ConfigurableFluidStack> getFluidInputs() {
        return this.fluidInputs;
    }

    @Override
    public List<ConfigurableFluidStack> getFluidOutputs() {
        return this.fluidOutputs;
    }

    @Override
    public int hash() {
        return this.invHash;
    }
}

