/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks;

import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineBlockEntityRenderer;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.MultiblockErrorHighlight;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.util.RenderHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class MultiblockMachineBER
extends MachineBlockEntityRenderer<MultiblockMachineBlockEntity> {
    public MultiblockMachineBER(class_5614.class_5615 ctx) {
        super(ctx);
    }

    @Override
    public void render(MultiblockMachineBlockEntity be, float tickDelta, class_4587 matrices, class_4597 vcp, int light, int overlay) {
        super.render(be, tickDelta, matrices, vcp, light, overlay);
        super.render(be, tickDelta, matrices, vcp, light, overlay);
        boolean drawHighlights = MultiblockMachineBER.isHoldingWrench() && !be.isShapeValid();
        HatchType hatchType = MultiblockMachineBER.getHeldHatchType();
        if (drawHighlights || hatchType != null) {
            ShapeMatcher matcher = new ShapeMatcher(be.method_10997(), be.method_11016(), be.getOrientation().facingDirection, be.getActiveShape());
            for (class_2338 pos : matcher.getPositions()) {
                matrices.method_22903();
                matrices.method_46416((float)(pos.method_10263() - be.method_11016().method_10263()), (float)(pos.method_10264() - be.method_11016().method_10264()), (float)(pos.method_10260() - be.method_11016().method_10260()));
                HatchFlags hatchFlag = matcher.getHatchFlags(pos);
                if (hatchType != null && MIConfig.getConfig().enableHatchPlacementOverlay && hatchFlag != null && hatchFlag.allows(hatchType)) {
                    matrices.method_22904(-0.005, -0.005, -0.005);
                    matrices.method_22905(1.01f, 1.01f, 1.01f);
                    RenderHelper.drawOverlay(matrices, vcp, 0.43359375f, 1.0f, 0.43359375f, 0xF000F0, overlay);
                }
                if (drawHighlights && !matcher.matches(pos, be.method_10997(), null)) {
                    if (be.method_10997().method_8320(pos).method_26215()) {
                        MultiblockErrorHighlight.enqueueHighlight(pos, matcher.getSimpleMember(pos).getPreviewState());
                    } else {
                        MultiblockErrorHighlight.enqueueHighlight(pos, null);
                    }
                }
                matrices.method_22909();
            }
        }
    }

    private static boolean isHoldingWrench() {
        class_746 player = class_310.method_1551().field_1724;
        return player.method_6047().method_31573(MITags.WRENCHES) || player.method_6079().method_31573(MITags.WRENCHES);
    }

    @Nullable
    private static HatchType getHeldHatchType() {
        class_746 player = class_310.method_1551().field_1724;
        HatchType mainHand = MultiblockMachineBER.getHatchType(player.method_6047());
        HatchType offHand = MultiblockMachineBER.getHatchType(player.method_6079());
        return mainHand == null ? offHand : mainHand;
    }

    @Nullable
    private static HatchType getHatchType(class_1799 stack) {
        MachineBlock block;
        MachineBlockEntity be;
        class_1747 blockItem;
        class_1792 item = stack.method_7909();
        if (item instanceof class_1747 && (blockItem = (class_1747)item).method_7711() instanceof MachineBlock && (be = (block = (MachineBlock)blockItem.method_7711()).newBlockEntity(new class_2338(0, 0, 0), block.method_9564())) instanceof HatchBlockEntity) {
            HatchBlockEntity hatch = (HatchBlockEntity)be;
            return hatch.getHatchType();
        }
        return null;
    }
}

