/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.IPlayerWaystoneData;
import net.minecraft.class_1657;

public class InMemoryPlayerWaystoneData
implements IPlayerWaystoneData {
    private final List<IWaystone> sortedWaystones = new ArrayList<IWaystone>();
    private final Map<UUID, IWaystone> waystones = new HashMap<UUID, IWaystone>();
    private long warpStoneCooldownUntil;
    private long inventoryButtonCooldownUntil;

    @Override
    public void activateWaystone(class_1657 player, IWaystone waystone) {
        this.waystones.put(waystone.getWaystoneUid(), waystone);
        this.sortedWaystones.add(waystone);
    }

    @Override
    public boolean isWaystoneActivated(class_1657 player, IWaystone waystone) {
        return this.waystones.containsKey(waystone.getWaystoneUid());
    }

    @Override
    public void deactivateWaystone(class_1657 player, IWaystone waystone) {
        this.waystones.remove(waystone.getWaystoneUid());
        this.sortedWaystones.remove(waystone);
    }

    @Override
    public long getWarpStoneCooldownUntil(class_1657 player) {
        return this.warpStoneCooldownUntil;
    }

    @Override
    public void setWarpStoneCooldownUntil(class_1657 player, long timeStamp) {
        this.warpStoneCooldownUntil = timeStamp;
    }

    @Override
    public long getInventoryButtonCooldownUntil(class_1657 player) {
        return this.inventoryButtonCooldownUntil;
    }

    @Override
    public void setInventoryButtonCooldownUntil(class_1657 player, long timeStamp) {
        this.inventoryButtonCooldownUntil = timeStamp;
    }

    @Override
    public List<IWaystone> getWaystones(class_1657 player) {
        return this.sortedWaystones;
    }

    @Override
    public void swapWaystoneSorting(class_1657 player, int index, int otherIndex) {
        if (otherIndex == -1) {
            IWaystone waystone = this.sortedWaystones.remove(index);
            this.sortedWaystones.add(0, waystone);
        } else if (otherIndex == this.sortedWaystones.size()) {
            IWaystone waystone = this.sortedWaystones.remove(index);
            this.sortedWaystones.add(waystone);
        } else {
            Collections.swap(this.sortedWaystones, index, otherIndex);
        }
    }

    public void setWaystones(List<IWaystone> waystones) {
        this.sortedWaystones.clear();
        this.waystones.clear();
        this.sortedWaystones.addAll(waystones);
        for (IWaystone waystone : waystones) {
            this.waystones.put(waystone.getWaystoneUid(), waystone);
        }
    }
}

