/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmEnvironment;
import net.blay09.mods.waystones.api.IMutableWaystone;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.IWaystoneTeleportContext;
import net.blay09.mods.waystones.api.TeleportDestination;
import net.blay09.mods.waystones.api.WaystoneActivatedEvent;
import net.blay09.mods.waystones.api.WaystoneTeleportError;
import net.blay09.mods.waystones.api.WaystoneTeleportEvent;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.config.DimensionalWarp;
import net.blay09.mods.waystones.config.InventoryButtonMode;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.IPlayerWaystoneData;
import net.blay09.mods.waystones.core.InMemoryPlayerWaystoneData;
import net.blay09.mods.waystones.core.PersistentPlayerWaystoneData;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.core.WaystoneTeleportContext;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.blay09.mods.waystones.network.message.TeleportEffectMessage;
import net.blay09.mods.waystones.tag.ModItemTags;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerator;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2748;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PlayerWaystoneManager {
    private static final Logger logger = LogManager.getLogger();
    private static final IPlayerWaystoneData persistentPlayerWaystoneData = new PersistentPlayerWaystoneData();
    private static final IPlayerWaystoneData inMemoryPlayerWaystoneData = new InMemoryPlayerWaystoneData();

    public static boolean mayBreakWaystone(class_1657 player, class_1922 world, class_2338 pos) {
        if (WaystonesConfig.getActive().restrictions.restrictToCreative && !player.method_31549().field_7477) {
            return false;
        }
        return WaystoneManager.get(player.method_5682()).getWaystoneAt(world, pos).map(waystone -> {
            if (!player.method_31549().field_7477) {
                if (waystone.wasGenerated() && WaystonesConfig.getActive().restrictions.generatedWaystonesUnbreakable) {
                    return false;
                }
                boolean isGlobal = waystone.isGlobal();
                boolean mayBreakGlobalWaystones = !WaystonesConfig.getActive().restrictions.globalWaystoneSetupRequiresCreativeMode;
                return !isGlobal || mayBreakGlobalWaystones;
            }
            return true;
        }).orElse(true);
    }

    public static boolean mayPlaceWaystone(@Nullable class_1657 player) {
        return !WaystonesConfig.getActive().restrictions.restrictToCreative || player != null && player.method_31549().field_7477;
    }

    public static WaystoneEditPermissions mayEditWaystone(class_1657 player, class_1937 world, IWaystone waystone) {
        if (WaystonesConfig.getActive().restrictions.restrictToCreative && !player.method_31549().field_7477) {
            return WaystoneEditPermissions.NOT_CREATIVE;
        }
        if (WaystonesConfig.getActive().restrictions.restrictRenameToOwner && !waystone.isOwner(player)) {
            return WaystoneEditPermissions.NOT_THE_OWNER;
        }
        if (waystone.isGlobal() && !player.method_31549().field_7477 && WaystonesConfig.getActive().restrictions.globalWaystoneSetupRequiresCreativeMode) {
            return WaystoneEditPermissions.GET_CREATIVE;
        }
        return WaystoneEditPermissions.ALLOW;
    }

    public static boolean isWaystoneActivated(class_1657 player, IWaystone waystone) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).isWaystoneActivated(player, waystone);
    }

    public static void activateWaystone(class_1657 player, IWaystone waystone) {
        if (!waystone.hasName() && waystone instanceof IMutableWaystone && waystone.wasGenerated()) {
            NameGenerationMode nameGenerationMode = WaystonesConfig.getActive().worldGen.nameGenerationMode;
            String name = NameGenerator.get(player.method_5682()).getName(waystone, player.method_37908().field_9229, nameGenerationMode);
            ((IMutableWaystone)((Object)waystone)).setName(name);
        }
        if (!waystone.hasOwner() && waystone instanceof IMutableWaystone) {
            ((IMutableWaystone)((Object)waystone)).setOwnerUid(player.method_5667());
        }
        if (player.method_5682() != null) {
            WaystoneManager.get(player.method_5682()).method_80();
        }
        if (!PlayerWaystoneManager.isWaystoneActivated(player, waystone) && waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
            PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).activateWaystone(player, waystone);
            Balm.getEvents().fireEvent((Object)new WaystoneActivatedEvent(player, waystone));
        }
    }

    public static int predictExperienceLevelCost(class_1297 player, IWaystone waystone, WarpMode warpMode, @Nullable IWaystone fromWaystone) {
        WaystoneTeleportContext context = new WaystoneTeleportContext(player, waystone, null);
        context.getLeashedEntities().addAll(PlayerWaystoneManager.findLeashedAnimals(player));
        context.setFromWaystone(fromWaystone);
        return PlayerWaystoneManager.getExperienceLevelCost(player, waystone, warpMode, context);
    }

    public static int getExperienceLevelCost(class_1297 entity, IWaystone waystone, WarpMode warpMode, IWaystoneTeleportContext context) {
        double xpLevelCost;
        if (!(entity instanceof class_1657)) {
            return 0;
        }
        class_1657 player = (class_1657)entity;
        if (context.getFromWaystone() != null && waystone.getWaystoneUid().equals(context.getFromWaystone().getWaystoneUid())) {
            return 0;
        }
        boolean enableXPCost = !player.method_31549().field_7477;
        int xpForLeashed = WaystonesConfig.getActive().xpCost.xpCostPerLeashed * context.getLeashedEntities().size();
        double xpCostMultiplier = warpMode.getXpCostMultiplier();
        if (waystone.isGlobal()) {
            xpCostMultiplier *= WaystonesConfig.getActive().xpCost.globalWaystoneXpCostMultiplier;
        }
        class_2338 pos = waystone.getPos();
        double dist = Math.sqrt(player.method_5649((double)pos.method_10263(), player.method_23318(), (double)pos.method_10260()));
        double minimumXpCost = WaystonesConfig.getActive().xpCost.minimumBaseXpCost;
        double maximumXpCost = WaystonesConfig.getActive().xpCost.maximumBaseXpCost;
        if (waystone.getDimension() != player.method_37908().method_27983()) {
            int dimensionalWarpXpCost = WaystonesConfig.getActive().xpCost.dimensionalWarpXpCost;
            xpLevelCost = class_3532.method_15350((double)dimensionalWarpXpCost, (double)minimumXpCost, (double)dimensionalWarpXpCost);
        } else if (WaystonesConfig.getActive().xpCost.blocksPerXpLevel > 0) {
            xpLevelCost = class_3532.method_15350((double)Math.floor(dist / (double)WaystonesConfig.getActive().xpCost.blocksPerXpLevel), (double)minimumXpCost, (double)maximumXpCost);
            if (WaystonesConfig.getActive().xpCost.inverseXpCost) {
                xpLevelCost = maximumXpCost - xpLevelCost;
            }
        } else {
            xpLevelCost = minimumXpCost;
        }
        return enableXPCost ? (int)Math.round((xpLevelCost + (double)xpForLeashed) * xpCostMultiplier) : 0;
    }

    @Nullable
    public static IWaystone getInventoryButtonWaystone(class_1657 player) {
        InventoryButtonMode inventoryButtonMode = WaystonesConfig.getActive().getInventoryButtonMode();
        if (inventoryButtonMode.isReturnToNearest()) {
            return PlayerWaystoneManager.getNearestWaystone(player);
        }
        if (inventoryButtonMode.hasNamedTarget()) {
            return WaystoneManager.get(player.method_5682()).findWaystoneByName(inventoryButtonMode.getNamedTarget()).orElse(null);
        }
        return null;
    }

    public static boolean canUseInventoryButton(class_1657 player) {
        IWaystone waystone = PlayerWaystoneManager.getInventoryButtonWaystone(player);
        int xpLevelCost = waystone != null ? PlayerWaystoneManager.predictExperienceLevelCost((class_1297)player, waystone, WarpMode.INVENTORY_BUTTON, null) : 0;
        return PlayerWaystoneManager.getInventoryButtonCooldownLeft(player) <= 0L && (xpLevelCost <= 0 || player.field_7520 >= xpLevelCost);
    }

    public static boolean canUseWarpStone(class_1657 player, class_1799 heldItem) {
        return PlayerWaystoneManager.getWarpStoneCooldownLeft(player) <= 0L;
    }

    public static double getCooldownMultiplier(IWaystone waystone) {
        return waystone.isGlobal() ? WaystonesConfig.getActive().cooldowns.globalWaystoneCooldownMultiplier : 1.0;
    }

    private static void informPlayer(class_1297 entity, String translationKey) {
        if (entity instanceof class_1657) {
            class_5250 chatComponent = class_2561.method_43471((String)translationKey);
            chatComponent.method_27692(class_124.field_1061);
            ((class_1657)entity).method_7353((class_2561)chatComponent, false);
        }
    }

    public static Consumer<WaystoneTeleportError> informRejectedTeleport(class_1297 entityToInform) {
        return error -> {
            logger.info("Rejected teleport: " + error.getClass().getSimpleName());
            if (error.getTranslationKey() != null) {
                PlayerWaystoneManager.informPlayer(entityToInform, error.getTranslationKey());
            }
        };
    }

    public static Either<List<class_1297>, WaystoneTeleportError> tryTeleportToWaystone(class_1297 entity, IWaystone waystone, WarpMode warpMode, @Nullable IWaystone fromWaystone) {
        return WaystonesAPI.createDefaultTeleportContext(entity, waystone, warpMode, fromWaystone).flatMap(PlayerWaystoneManager::tryTeleport).ifRight(PlayerWaystoneManager.informRejectedTeleport(entity));
    }

    public static Either<List<class_1297>, WaystoneTeleportError> tryTeleport(IWaystoneTeleportContext context) {
        boolean isCreativeMode;
        WarpMode warpMode;
        WaystoneTeleportEvent.Pre event = new WaystoneTeleportEvent.Pre(context);
        Balm.getEvents().fireEvent((Object)event);
        if (event.isCanceled()) {
            return Either.right((Object)new WaystoneTeleportError.CancelledByEvent());
        }
        IWaystone waystone = context.getTargetWaystone();
        class_1297 entity = context.getEntity();
        if (!PlayerWaystoneManager.canUseWarpMode(entity, warpMode = context.getWarpMode(), context.getWarpItem(), context.getFromWaystone())) {
            return Either.right((Object)new WaystoneTeleportError.WarpModeRejected());
        }
        if (!warpMode.getAllowTeleportPredicate().test(entity, waystone)) {
            return Either.right((Object)new WaystoneTeleportError.WarpModeRejected());
        }
        if (context.isDimensionalTeleport() && !event.getDimensionalTeleportResult().withDefault(() -> PlayerWaystoneManager.canDimensionalWarpBetween(entity, waystone))) {
            return Either.right((Object)new WaystoneTeleportError.DimensionalWarpDenied());
        }
        if (!context.getLeashedEntities().isEmpty()) {
            if (!WaystonesConfig.getActive().restrictions.transportLeashed) {
                return Either.right((Object)new WaystoneTeleportError.LeashedWarpDenied());
            }
            List<class_2960> forbidden = WaystonesConfig.getActive().restrictions.leashedDenyList.stream().map(class_2960::new).toList();
            if (context.getLeashedEntities().stream().anyMatch(e -> forbidden.contains(class_7923.field_41177.method_10221((Object)e.method_5864())))) {
                return Either.right((Object)new WaystoneTeleportError.SpecificLeashedWarpDenied());
            }
            if (context.isDimensionalTeleport() && !WaystonesConfig.getActive().restrictions.transportLeashedDimensional) {
                return Either.right((Object)new WaystoneTeleportError.LeashedDimensionalWarpDenied());
            }
        }
        if (entity instanceof class_1657 && ((class_1657)entity).field_7520 < context.getXpCost()) {
            return Either.right((Object)new WaystoneTeleportError.NotEnoughXp());
        }
        boolean bl = isCreativeMode = entity instanceof class_1657 && ((class_1657)entity).method_31549().field_7477;
        if (!context.getWarpItem().method_7960() && event.getConsumeItemResult().withDefault(() -> !isCreativeMode && context.consumesWarpItem())) {
            context.getWarpItem().method_7934(1);
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            PlayerWaystoneManager.applyCooldown(warpMode, player, context.getCooldown());
            PlayerWaystoneManager.applyXpCost(player, context.getXpCost());
        }
        List<class_1297> teleportedEntities = PlayerWaystoneManager.doTeleport(context);
        Balm.getEvents().fireEvent((Object)new WaystoneTeleportEvent.Post(context, teleportedEntities));
        return Either.left(teleportedEntities);
    }

    private static void sendHackySyncPacketsAfterTeleport(class_1297 entity) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            player.field_13987.method_14364((class_2596)new class_2748(player.field_7510, player.field_7495, player.field_7520));
        }
    }

    private static void applyXpCost(class_1657 player, int xpLevelCost) {
        if (xpLevelCost > 0) {
            player.method_7316(-xpLevelCost);
        }
    }

    private static void applyCooldown(WarpMode warpMode, class_1657 player, int cooldown) {
        if (cooldown > 0) {
            class_1937 level = player.method_37908();
            switch (warpMode) {
                case INVENTORY_BUTTON: {
                    PlayerWaystoneManager.getPlayerWaystoneData(level).setInventoryButtonCooldownUntil(player, System.currentTimeMillis() + (long)cooldown * 1000L);
                    break;
                }
                case WARP_STONE: {
                    PlayerWaystoneManager.getPlayerWaystoneData(level).setWarpStoneCooldownUntil(player, System.currentTimeMillis() + (long)cooldown * 1000L);
                }
            }
            WaystoneSyncManager.sendWaystoneCooldowns(player);
        }
    }

    public static int getCooldownPeriod(WarpMode warpMode, IWaystone waystone) {
        return (int)((double)PlayerWaystoneManager.getCooldownPeriod(warpMode) * PlayerWaystoneManager.getCooldownMultiplier(waystone));
    }

    private static int getCooldownPeriod(WarpMode warpMode) {
        return switch (warpMode) {
            case WarpMode.INVENTORY_BUTTON -> WaystonesConfig.getActive().cooldowns.inventoryButtonCooldown;
            case WarpMode.WARP_STONE -> WaystonesConfig.getActive().cooldowns.warpStoneCooldown;
            default -> 0;
        };
    }

    private static boolean canDimensionalWarpBetween(class_1297 player, IWaystone waystone) {
        class_2960 fromDimension = player.method_37908().method_27983().method_29177();
        class_2960 toDimension = waystone.getDimension().method_29177();
        List<String> dimensionAllowList = WaystonesConfig.getActive().restrictions.dimensionalWarpAllowList;
        List<String> dimensionDenyList = WaystonesConfig.getActive().restrictions.dimensionalWarpDenyList;
        if (!(dimensionAllowList.isEmpty() || dimensionAllowList.contains(toDimension.toString()) && dimensionAllowList.contains(fromDimension.toString()))) {
            return false;
        }
        if (!dimensionDenyList.isEmpty() && (dimensionDenyList.contains(toDimension.toString()) || dimensionDenyList.contains(fromDimension.toString()))) {
            return false;
        }
        DimensionalWarp dimensionalWarpMode = WaystonesConfig.getActive().restrictions.dimensionalWarp;
        return dimensionalWarpMode == DimensionalWarp.ALLOW || dimensionalWarpMode == DimensionalWarp.GLOBAL_ONLY && waystone.isGlobal();
    }

    public static class_1799 findWarpItem(class_1297 entity, WarpMode warpMode) {
        return switch (warpMode) {
            case WarpMode.WARP_SCROLL -> PlayerWaystoneManager.findWarpItem(entity, ModItemTags.WARP_SCROLLS);
            case WarpMode.WARP_STONE -> PlayerWaystoneManager.findWarpItem(entity, ModItemTags.WARP_STONES);
            case WarpMode.RETURN_SCROLL -> PlayerWaystoneManager.findWarpItem(entity, ModItemTags.RETURN_SCROLLS);
            case WarpMode.BOUND_SCROLL -> PlayerWaystoneManager.findWarpItem(entity, ModItemTags.BOUND_SCROLLS);
            default -> class_1799.field_8037;
        };
    }

    private static class_1799 findWarpItem(class_1297 entity, class_6862<class_1792> warpItemTag) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (livingEntity.method_6047().method_31573(warpItemTag)) {
                return livingEntity.method_6047();
            }
            if (livingEntity.method_6079().method_31573(warpItemTag)) {
                return livingEntity.method_6079();
            }
        }
        return class_1799.field_8037;
    }

    public static List<class_1308> findLeashedAnimals(class_1297 player) {
        return player.method_37908().method_8390(class_1308.class, new class_238(player.method_24515()).method_1014(10.0), e -> player.equals((Object)e.method_5933()));
    }

    public static List<class_1297> doTeleport(IWaystoneTeleportContext context) {
        List<class_1297> teleportedEntities = PlayerWaystoneManager.teleportEntityAndAttached(context.getEntity(), context);
        context.getAdditionalEntities().forEach(additionalEntity -> teleportedEntities.addAll(PlayerWaystoneManager.teleportEntityAndAttached(additionalEntity, context)));
        class_3218 sourceWorld = (class_3218)context.getEntity().method_37908();
        class_2338 sourcePos = context.getEntity().method_24515();
        TeleportDestination destination = context.getDestination();
        class_3218 targetLevel = destination.getLevel();
        class_2338 targetPos = class_2338.method_49638((class_2374)destination.getLocation());
        class_2586 targetTileEntity = targetLevel.method_8321(targetPos);
        if (targetTileEntity instanceof WarpPlateBlockEntity) {
            WarpPlateBlockEntity warpPlate = (WarpPlateBlockEntity)targetTileEntity;
            teleportedEntities.forEach(warpPlate::markEntityForCooldown);
        }
        if (context.playsSound()) {
            sourceWorld.method_8396(null, sourcePos, class_3417.field_14716, class_3419.field_15248, 0.1f, 1.0f);
            targetLevel.method_8396(null, targetPos, class_3417.field_14716, class_3419.field_15248, 0.1f, 1.0f);
        }
        if (context.playsEffect()) {
            teleportedEntities.forEach(additionalEntity -> Balm.getNetworking().sendToTracking(sourceWorld, sourcePos, (Object)new TeleportEffectMessage(sourcePos)));
            Balm.getNetworking().sendToTracking(targetLevel, targetPos, (Object)new TeleportEffectMessage(targetPos));
        }
        return teleportedEntities;
    }

    private static List<class_1297> teleportEntityAndAttached(class_1297 entity, IWaystoneTeleportContext context) {
        ArrayList<class_1297> teleportedEntities = new ArrayList<class_1297>();
        TeleportDestination destination = context.getDestination();
        class_3218 targetLevel = destination.getLevel();
        class_243 targetLocation = destination.getLocation();
        class_2350 targetDirection = destination.getDirection();
        class_1297 mount = entity.method_5854();
        class_1297 teleportedMount = null;
        if (mount != null) {
            teleportedMount = PlayerWaystoneManager.teleportEntity(mount, targetLevel, targetLocation, targetDirection);
            teleportedEntities.add(teleportedMount);
        }
        List<class_1308> leashedEntities = context.getLeashedEntities();
        ArrayList teleportedLeashedEntities = new ArrayList();
        leashedEntities.forEach(leashedEntity -> {
            class_1297 teleportedLeashedEntity = PlayerWaystoneManager.teleportEntity((class_1297)leashedEntity, targetLevel, targetLocation, targetDirection);
            teleportedEntities.add(teleportedLeashedEntity);
            teleportedLeashedEntities.add(teleportedLeashedEntity);
        });
        class_1297 teleportedEntity = PlayerWaystoneManager.teleportEntity(entity, targetLevel, targetLocation, targetDirection);
        teleportedEntities.add(teleportedEntity);
        teleportedLeashedEntities.forEach(teleportedLeashedEntity -> {
            if (teleportedLeashedEntity instanceof class_1308) {
                class_1308 teleportedLeashedMob = (class_1308)teleportedLeashedEntity;
                teleportedLeashedMob.method_5954(teleportedEntity, true);
            }
        });
        if (teleportedMount != null) {
            // empty if block
        }
        return teleportedEntities;
    }

    private static class_1297 teleportEntity(class_1297 entity, class_3218 targetWorld, class_243 targetPos3d, class_2350 direction) {
        float yaw = direction.method_10144();
        double x = targetPos3d.field_1352;
        double y = targetPos3d.field_1351;
        double z = targetPos3d.field_1350;
        if (entity instanceof class_3222) {
            class_1923 chunkPos = new class_1923(class_2338.method_49637((double)x, (double)y, (double)z));
            targetWorld.method_14178().method_17297(class_3230.field_19347, chunkPos, 1, (Object)entity.method_5628());
            entity.method_5848();
            if (((class_3222)entity).method_6113()) {
                ((class_3222)entity).method_7358(true, true);
            }
            if (targetWorld == entity.method_37908()) {
                ((class_3222)entity).field_13987.method_14360(x, y, z, yaw, entity.method_36455(), Collections.emptySet());
            } else {
                ((class_3222)entity).method_14251(targetWorld, x, y, z, yaw, entity.method_36455());
            }
            entity.method_5847(yaw);
        } else {
            float pitch = class_3532.method_15363((float)entity.method_36455(), (float)-90.0f, (float)90.0f);
            if (targetWorld == entity.method_37908()) {
                entity.method_5808(x, y, z, yaw, pitch);
                entity.method_5847(yaw);
            } else {
                entity.method_18375();
                class_1297 oldEntity = entity;
                entity = entity.method_5864().method_5883((class_1937)targetWorld);
                if (entity == null) {
                    return oldEntity;
                }
                entity.method_5878(oldEntity);
                entity.method_5808(x, y, z, yaw, pitch);
                entity.method_5847(yaw);
                oldEntity.method_31745(class_1297.class_5529.field_27002);
                targetWorld.method_18769(entity);
            }
        }
        if (!(entity instanceof class_1309) || !((class_1309)entity).method_6128()) {
            entity.method_18799(entity.method_18798().method_18805(1.0, 0.0, 1.0));
            entity.method_24830(true);
        }
        if (entity instanceof class_1314) {
            ((class_1314)entity).method_5942().method_6340();
        }
        PlayerWaystoneManager.sendHackySyncPacketsAfterTeleport(entity);
        return entity;
    }

    public static void deactivateWaystone(class_1657 player, IWaystone waystone) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).deactivateWaystone(player, waystone);
    }

    private static boolean canUseWarpMode(class_1297 entity, WarpMode warpMode, class_1799 heldItem, @Nullable IWaystone fromWaystone) {
        return switch (warpMode) {
            default -> throw new IncompatibleClassChangeError();
            case WarpMode.INVENTORY_BUTTON -> {
                if (entity instanceof class_1657 && PlayerWaystoneManager.canUseInventoryButton((class_1657)entity)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.WARP_SCROLL -> {
                if (!heldItem.method_7960() && heldItem.method_31573(ModItemTags.WARP_SCROLLS)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.BOUND_SCROLL -> {
                if (!heldItem.method_7960() && heldItem.method_31573(ModItemTags.BOUND_SCROLLS)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.RETURN_SCROLL -> {
                if (!heldItem.method_7960() && heldItem.method_31573(ModItemTags.RETURN_SCROLLS)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.WARP_STONE -> {
                if (!heldItem.method_7960() && heldItem.method_31573(ModItemTags.WARP_STONES) && entity instanceof class_1657 && PlayerWaystoneManager.canUseWarpStone((class_1657)entity, heldItem)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.WAYSTONE_TO_WAYSTONE -> {
                if (WaystonesConfig.getActive().restrictions.allowWaystoneToWaystoneTeleport && fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.SHARESTONE_TO_SHARESTONE -> {
                if (fromWaystone != null && fromWaystone.isValid() && WaystoneTypes.isSharestone(fromWaystone.getWaystoneType())) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.WARP_PLATE -> {
                if (fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.WARP_PLATE)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.PORTSTONE_TO_WAYSTONE -> {
                if (fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.PORTSTONE)) {
                    yield true;
                }
                yield false;
            }
            case WarpMode.CUSTOM -> true;
        };
    }

    public static long getWarpStoneCooldownUntil(class_1657 player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).getWarpStoneCooldownUntil(player);
    }

    public static long getWarpStoneCooldownLeft(class_1657 player) {
        long cooldownUntil = PlayerWaystoneManager.getWarpStoneCooldownUntil(player);
        return Math.max(0L, cooldownUntil - System.currentTimeMillis());
    }

    public static void setWarpStoneCooldownUntil(class_1657 player, long timeStamp) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).setWarpStoneCooldownUntil(player, timeStamp);
    }

    public static long getInventoryButtonCooldownUntil(class_1657 player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).getInventoryButtonCooldownUntil(player);
    }

    public static long getInventoryButtonCooldownLeft(class_1657 player) {
        long cooldownUntil = PlayerWaystoneManager.getInventoryButtonCooldownUntil(player);
        return Math.max(0L, cooldownUntil - System.currentTimeMillis());
    }

    public static void setInventoryButtonCooldownUntil(class_1657 player, long timeStamp) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).setInventoryButtonCooldownUntil(player, timeStamp);
    }

    @Nullable
    public static IWaystone getNearestWaystone(class_1657 player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).getWaystones(player).stream().filter(it -> it.getDimension() == player.method_37908().method_27983()).min((first, second) -> {
            double firstDist = first.getPos().method_10268(player.method_23317(), player.method_23318(), player.method_23321());
            double secondDist = second.getPos().method_10268(player.method_23317(), player.method_23318(), player.method_23321());
            return (int)Math.round(firstDist) - (int)Math.round(secondDist);
        }).orElse(null);
    }

    public static List<IWaystone> getWaystones(class_1657 player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).getWaystones(player);
    }

    public static IPlayerWaystoneData getPlayerWaystoneData(@Nullable class_1937 world) {
        return world == null || world.field_9236 ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static IPlayerWaystoneData getPlayerWaystoneData(BalmEnvironment side) {
        return side.isClient() ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static boolean mayTeleportToWaystone(class_1657 player, IWaystone waystone) {
        return true;
    }

    public static void swapWaystoneSorting(class_1657 player, int index, int otherIndex) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.method_37908()).swapWaystoneSorting(player, index, otherIndex);
    }

    public static boolean mayEditGlobalWaystones(class_1657 player) {
        return player.method_31549().field_7477 || !WaystonesConfig.getActive().restrictions.globalWaystoneSetupRequiresCreativeMode;
    }

    public static void activeWaystoneForEveryone(@Nullable MinecraftServer server, IWaystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            if (PlayerWaystoneManager.isWaystoneActivated((class_1657)player, waystone)) continue;
            PlayerWaystoneManager.activateWaystone((class_1657)player, waystone);
        }
    }

    public static void removeKnownWaystone(@Nullable MinecraftServer server, IWaystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.method_3760().method_14571();
        for (class_3222 player : players) {
            PlayerWaystoneManager.deactivateWaystone((class_1657)player, waystone);
            WaystoneSyncManager.sendActivatedWaystones((class_1657)player);
        }
    }
}

