/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core.recipe;

import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.DetachedDrawerData;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModRecipes;
import com.jaquadro.minecraft.storagedrawers.item.ItemDetachedDrawer;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeDetachedDrawerRecipe
extends class_1852 {
    public UpgradeDetachedDrawerRecipe(class_2960 name, class_7710 cat) {
        super(name, cat);
    }

    public boolean matches(@NotNull class_8566 inv, @NotNull class_1937 world) {
        return this.findContext(inv) != null;
    }

    @NotNull
    public class_1799 assemble(@NotNull class_8566 inv, class_5455 access) {
        Context ctx = this.findContext(inv);
        if (ctx == null) {
            return class_1799.field_8037;
        }
        class_1799 ret = ctx.drawer.method_7972();
        DetachedDrawerData data = new DetachedDrawerData(ret.method_7948());
        int cap = data.getStorageMultiplier();
        if (ctx.upgrades.isEmpty()) {
            ret = ((class_1792)ModItems.DETACHED_DRAWER.get()).method_7854();
            data = new DetachedDrawerData();
            data.setStorageMultiplier(cap);
        } else {
            int addedCap = ctx.storageMult * (Integer)ModCommonConfig.INSTANCE.DRAWERS.baseStackStorage.get() * (Integer)ModCommonConfig.INSTANCE.DRAWERS.fullDrawers1x1.unitsPerSlot.get();
            data.setStorageMultiplier(data.getStorageMultiplier() + addedCap);
        }
        ret.method_7980(data.serializeNBT());
        return ret;
    }

    @Nullable
    private Context findContext(class_8566 inv) {
        Context ret = new Context();
        for (int x = 0; x < inv.method_5439(); ++x) {
            class_1799 stack = inv.method_5438(x);
            if (stack.method_7960()) continue;
            if (stack.method_7909() instanceof ItemDetachedDrawer) {
                if (!ret.drawer.method_7960()) {
                    return null;
                }
                ret.drawer = stack;
                continue;
            }
            if (stack.method_7909() instanceof ItemUpgradeStorage) {
                ret.upgrades.add(stack);
                continue;
            }
            return null;
        }
        if (ret.drawer.method_7960()) {
            return null;
        }
        for (class_1799 upgrade : ret.upgrades) {
            class_1792 class_17922 = upgrade.method_7909();
            if (!(class_17922 instanceof ItemUpgradeStorage)) continue;
            ItemUpgradeStorage storageUpgrade = (ItemUpgradeStorage)class_17922;
            ret.storageMult += ModCommonConfig.INSTANCE.UPGRADES.getLevelMult(storageUpgrade.level.getLevel());
        }
        return ret;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)ModRecipes.DETACHED_UPGRADE_RECIPE_SERIALIZER.get();
    }

    private static class Context {
        class_1799 drawer = class_1799.field_8037;
        List<class_1799> upgrades = new ArrayList<class_1799>();
        int storageMult = 0;

        private Context() {
        }
    }
}

