/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeMagnet;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemUpgradeMagnet
extends ItemUpgrade {
    private static final int magnetGroupId = ItemUpgrade.getNextGroupId();
    public final EnumUpgradeMagnet type;

    public ItemUpgradeMagnet(EnumUpgradeMagnet type, class_1792.class_1793 properties) {
        this(type, properties, magnetGroupId);
    }

    protected ItemUpgradeMagnet(EnumUpgradeMagnet type, class_1792.class_1793 properties, int groupId) {
        super(properties, groupId);
        this.setAllowMultiple(true);
        this.type = type;
    }

    @Override
    @NotNull
    public class_2561 method_7848() {
        if (!this.isEnabled()) {
            return super.method_7848();
        }
        return class_2561.method_43471((String)"item.storagedrawers.magnet_upgrade.desc");
    }

    @Override
    public void method_7851(@NotNull class_1799 itemStack, @Nullable class_1937 world, List<class_2561> list, class_1836 advanced) {
        super.method_7851(itemStack, world, list, advanced);
        if (!this.isEnabled()) {
            return;
        }
        String rangeId = ((class_1792)ModItems.MAGNET_UPGRADE.get()).method_7876() + ".range";
        list.add((class_2561)class_2561.method_43469((String)rangeId, (Object[])new Object[]{this.buildRangeString()}).method_27692(class_124.field_1063));
        String rateId = ((class_1792)ModItems.MAGNET_UPGRADE.get()).method_7876() + ".speed";
        int activeSpeed = this.getActiveSpeed();
        list.add((class_2561)class_2561.method_43469((String)rateId, (Object[])new Object[]{1, activeSpeed}).method_27692(class_124.field_1063));
    }

    private String buildRangeString() {
        ArrayList<CallSite> result = new ArrayList<CallSite>();
        int hRange = this.getHorzRange();
        int upRange = this.getUpRange();
        int downRange = this.getDownRange();
        if (hRange == upRange && hRange == downRange) {
            return Integer.toString(hRange);
        }
        if (hRange > 0) {
            result.add((CallSite)((Object)(hRange + "\u2194")));
        }
        if (upRange > 0) {
            result.add((CallSite)((Object)(upRange + "\u2191")));
        }
        if (downRange > 0) {
            result.add((CallSite)((Object)(downRange + "\u2193")));
        }
        return String.join((CharSequence)", ", result);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)this.getConfig().enableUpgrade.get();
    }

    public int getActiveSpeed() {
        return (Integer)this.getConfig().activeSpeed.get();
    }

    public int getIdleSpeed() {
        return (Integer)this.getConfig().idleSpeed.get();
    }

    public int getHorzRange() {
        return this.getIndexedRange(0);
    }

    public int getUpRange() {
        return this.getIndexedRange(1);
    }

    public int getDownRange() {
        return this.getIndexedRange(2);
    }

    private int getIndexedRange(int index) {
        return (Integer)((List)this.getConfig().range.get()).get(index);
    }

    private ModCommonConfig.Upgrades.MagnetTierUpgrade getConfig() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case EnumUpgradeMagnet.LEVEL1 -> ModCommonConfig.INSTANCE.UPGRADES.magnetUpgrade.tier1;
            case EnumUpgradeMagnet.LEVEL2 -> ModCommonConfig.INSTANCE.UPGRADES.magnetUpgrade.tier2;
            case EnumUpgradeMagnet.LEVEL3 -> ModCommonConfig.INSTANCE.UPGRADES.magnetUpgrade.tier3;
        };
    }
}

