/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.spookydoors.block.entity;

import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.spookydoors.ModBlockEntities;
import net.blay09.mods.spookydoors.ModSounds;
import net.blay09.mods.spookydoors.block.SpookyDoorBlock;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_8177;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public class SpookyDoorBlockEntity
extends BalmBlockEntity
implements CustomRenderBoundingBox {
    private static final int SYNC_INTERVAL = 1;
    private int ticksSinceLastSync = 0;
    private int soundCooldownTicks = 0;
    private boolean isDirty;
    private float openness;
    private boolean clientControl;

    public SpookyDoorBlockEntity(class_2338 pos, class_2680 blockState) {
        super((class_2591)ModBlockEntities.spookyDoor.get(), pos, blockState);
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10548("Openness", this.openness);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (!this.clientControl) {
            this.setOpennessBy(tag.method_10583("Openness"), null);
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    protected void writeUpdateTag(class_2487 tag) {
        tag.method_10548("Openness", this.openness);
    }

    public void method_5431() {
        super.method_5431();
        this.isDirty = true;
    }

    public float getOpenness() {
        return this.openness;
    }

    public void setOpennessBy(float openness, @Nullable class_1297 entity) {
        float prevOpenness = this.openness;
        this.openness = Math.clamp((float)0.0f, (float)1.0f, (float)openness);
        if (prevOpenness != this.openness) {
            this.method_5431();
            this.updateBlockState();
            this.playSounds(entity, prevOpenness, this.openness);
        }
    }

    public void playSounds(class_1297 entity, float prevOpenness, float openness) {
        if (this.field_11863 != null) {
            float speed = Math.abs((float)(openness - prevOpenness));
            if (prevOpenness <= 0.0f && openness > 0.0f) {
                class_8177 class_81772;
                class_2248 class_22482 = this.method_11010().method_26204();
                if (class_22482 instanceof class_2323) {
                    class_2323 doorBlock = (class_2323)class_22482;
                    class_81772 = doorBlock.method_51169();
                } else {
                    class_81772 = class_8177.field_42823;
                }
                class_8177 type = class_81772;
                this.field_11863.method_45445(entity, this.field_11867, type.comp_1292(), class_3419.field_15245, this.field_11863.method_8409().method_43057() * 0.2f + 0.9f, this.field_11863.method_8409().method_43057() * 0.2f + 0.9f);
            } else if (prevOpenness > 0.0f && openness == 0.0f) {
                class_8177 class_81773;
                class_2248 class_22483 = this.method_11010().method_26204();
                if (class_22483 instanceof class_2323) {
                    class_2323 doorBlock = (class_2323)class_22483;
                    class_81773 = doorBlock.method_51169();
                } else {
                    class_81773 = class_8177.field_42823;
                }
                class_8177 type = class_81773;
                this.field_11863.method_45445(entity, this.field_11867, type.comp_1291(), class_3419.field_15245, this.field_11863.method_8409().method_43057() * 0.2f + 0.9f, this.field_11863.method_8409().method_43057() * 0.2f + 0.9f);
            } else if (this.soundCooldownTicks <= 0) {
                this.field_11863.method_45445(entity, this.field_11867, (class_3414)ModSounds.doorCreak.get(), class_3419.field_15245, this.field_11863.method_8409().method_43057() * 0.2f + 0.5f, this.field_11863.method_8409().method_43057() * 0.4f + 0.8f);
                this.soundCooldownTicks = 2;
            }
        }
    }

    public void updateBlockState() {
        class_2680 state;
        if (this.field_11863 != null && (state = this.field_11863.method_8320(this.field_11867)).method_28498((class_2769)SpookyDoorBlock.field_10945)) {
            class_2680 newState = (class_2680)state.method_11657((class_2769)SpookyDoorBlock.field_10945, (Comparable)Boolean.valueOf(this.openness > 0.5f));
            if (state.method_11654((class_2769)SpookyDoorBlock.field_10945) != newState.method_11654((class_2769)SpookyDoorBlock.field_10945)) {
                this.field_11863.method_8652(this.field_11867, newState, 10);
            }
        }
    }

    public void sync() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            ((class_3218)this.field_11863).method_14178().method_14128(this.field_11867);
        }
    }

    public void serverTick() {
        ++this.ticksSinceLastSync;
        if (this.ticksSinceLastSync >= 1) {
            if (this.isDirty) {
                this.sync();
            }
            this.ticksSinceLastSync = 0;
            this.isDirty = false;
        }
        if (this.soundCooldownTicks > 0) {
            --this.soundCooldownTicks;
        }
    }

    public void clientTick() {
        if (this.soundCooldownTicks > 0) {
            --this.soundCooldownTicks;
        }
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        if (blockEntity instanceof SpookyDoorBlockEntity) {
            SpookyDoorBlockEntity spookyDoor = (SpookyDoorBlockEntity)blockEntity;
            spookyDoor.serverTick();
        }
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        if (blockEntity instanceof SpookyDoorBlockEntity) {
            SpookyDoorBlockEntity spookyDoor = (SpookyDoorBlockEntity)blockEntity;
            spookyDoor.clientTick();
        }
    }

    public SpookyDoorBlockEntity getBaseDoor() {
        class_2586 lowerBlockEntity;
        if (this.field_11863 != null && this.method_11010().method_11654((class_2769)SpookyDoorBlock.field_10946) == class_2756.field_12609 && (lowerBlockEntity = this.field_11863.method_8321(this.field_11867.method_10074())) instanceof SpookyDoorBlockEntity) {
            SpookyDoorBlockEntity lowerSpookyDoor = (SpookyDoorBlockEntity)lowerBlockEntity;
            return lowerSpookyDoor;
        }
        return this;
    }

    public void setClientControl(boolean clientControl) {
        this.clientControl = clientControl;
    }

    public class_238 getRenderBoundingBox() {
        return new class_238(this.method_11016()).method_1014(1.0);
    }
}

