/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.ModContainer;
import net.frozenblock.lib.FrozenSharedConstants;
import net.frozenblock.lib.cape.impl.ServerCapeData;
import net.frozenblock.lib.config.api.instance.Config;
import net.frozenblock.lib.config.api.registry.ConfigRegistry;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.config.impl.ConfigCommand;
import net.frozenblock.lib.core.impl.DataPackReloadMarker;
import net.frozenblock.lib.entity.api.EntityUtils;
import net.frozenblock.lib.entrypoint.api.FrozenMainEntrypoint;
import net.frozenblock.lib.entrypoint.api.FrozenModInitializer;
import net.frozenblock.lib.event.api.PlayerJoinEvents;
import net.frozenblock.lib.event.api.RegistryFreezeEvents;
import net.frozenblock.lib.ingamedevtools.RegisterInGameDevTools;
import net.frozenblock.lib.integration.api.ModIntegrations;
import net.frozenblock.lib.networking.FrozenNetworking;
import net.frozenblock.lib.particle.api.FrozenParticleTypes;
import net.frozenblock.lib.registry.api.FrozenRegistry;
import net.frozenblock.lib.screenshake.api.ScreenShakeManager;
import net.frozenblock.lib.screenshake.api.command.ScreenShakeCommand;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Contract;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.sound.api.predicate.SoundPredicate;
import net.frozenblock.lib.sound.impl.block_sound_group.BlockSoundGroupManager;
import net.frozenblock.lib.spotting_icons.api.SpottingIconPredicate;
import net.frozenblock.lib.tag.api.TagKeyArgument;
import net.frozenblock.lib.tag.api.TagListCommand;
import net.frozenblock.lib.wind.api.WindDisturbanceLogic;
import net.frozenblock.lib.wind.api.WindManager;
import net.frozenblock.lib.wind.api.command.WindCommand;
import net.frozenblock.lib.worldgen.feature.api.FrozenFeatures;
import net.frozenblock.lib.worldgen.feature.api.placementmodifier.FrozenPlacementModifiers;
import net.frozenblock.lib.worldgen.structure.impl.FrozenRuleBlockEntityModifiers;
import net.frozenblock.lib.worldgen.structure.impl.FrozenStructureProcessorTypes;
import net.frozenblock.lib.worldgen.surface.impl.BiomeTagConditionSource;
import net.frozenblock.lib.worldgen.surface.impl.OptimizedBiomeTagConditionSource;
import net.minecraft.class_2168;
import net.minecraft.class_2316;
import net.minecraft.class_2378;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7240;
import net.minecraft.class_7923;
import org.quiltmc.qsl.frozenblock.core.registry.api.sync.ModProtocol;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.impl.ServerFreezer;

public final class FrozenMain
extends FrozenModInitializer {
    public FrozenMain() {
        super("frozenlib");
    }

    @Override
    public void onInitialize(String modId, ModContainer container) {
        FrozenRegistry.initRegistry();
        ServerFreezer.onInitialize();
        ModProtocol.loadVersions();
        FrozenRuleBlockEntityModifiers.init();
        FrozenStructureProcessorTypes.init();
        SoundPredicate.init();
        SpottingIconPredicate.init();
        WindDisturbanceLogic.init();
        FrozenFeatures.init();
        FrozenPlacementModifiers.init();
        DataPackReloadMarker.init();
        class_2378.method_10230((class_2378)class_7923.field_41158, (class_2960)FrozenSharedConstants.id("biome_tag_condition_source"), (Object)BiomeTagConditionSource.CODEC.comp_640());
        class_2378.method_10230((class_2378)class_7923.field_41158, (class_2960)FrozenSharedConstants.id("optimized_biome_tag_condition_source"), (Object)OptimizedBiomeTagConditionSource.CODEC.comp_640());
        RegisterInGameDevTools.register();
        FrozenParticleTypes.registerParticles();
        ServerCapeData.init();
        ((FrozenMainEntrypoint)FrozenMainEntrypoint.EVENT.invoker()).init();
        class_2316.method_10017((class_2378)class_7923.field_41192, (String)FrozenSharedConstants.string("tag_key"), (Class)class_2316.method_41181(TagKeyArgument.class), new TagKeyArgument.Info());
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            WindCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ScreenShakeCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ConfigCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TagListCommand.register((CommandDispatcher<class_2168>)dispatcher);
        });
        ServerWorldEvents.LOAD.register((server, level) -> {
            class_26 dimensionDataStorage = level.method_17983();
            WindManager windManager = WindManager.getWindManager(level);
            dimensionDataStorage.method_17924(windManager::createData, windManager::createData, "frozenlib_wind");
            ScreenShakeManager screenShakeManager = ScreenShakeManager.getScreenShakeManager(level);
            dimensionDataStorage.method_17924(screenShakeManager::createData, screenShakeManager::createData, "frozenlib_screen_shakes");
        });
        ServerWorldEvents.UNLOAD.register((server, serverLevel) -> {
            EntityUtils.clearEntitiesPerLevel(serverLevel);
            WindManager.getWindManager(serverLevel).clearAllWindDisturbances();
        });
        ServerTickEvents.START_WORLD_TICK.register(serverLevel -> {
            WindManager.getWindManager(serverLevel).clearAndSwitchWindDisturbances();
            WindManager.getWindManager(serverLevel).tick(serverLevel);
            ScreenShakeManager.getScreenShakeManager(serverLevel).tick();
            EntityUtils.populateEntitiesPerLevel(serverLevel);
        });
        PlayerJoinEvents.ON_PLAYER_ADDED_TO_LEVEL.register((server, serverLevel, player) -> {
            WindManager windManager = WindManager.getWindManager(serverLevel);
            windManager.sendSyncToPlayer(windManager.createSyncByteBuf(), player);
        });
        if (FrozenLibConfig.get().wardenSpawnTrackerCommand) {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> class_7240.method_42100((CommandDispatcher)dispatcher));
        }
        FrozenNetworking.registerNetworking();
        RegistryFreezeEvents.START_REGISTRY_FREEZE.register((registry, allRegistries) -> {
            if (!allRegistries) {
                return;
            }
            ModIntegrations.initialize();
        });
        RegistryFreezeEvents.END_REGISTRY_FREEZE.register((registry, allRegistries) -> {
            if (!allRegistries) {
                return;
            }
            for (Config<?> config : ConfigRegistry.getAllConfigs()) {
                config.save();
            }
        });
        ResourceManagerHelper resourceLoader = ResourceManagerHelper.get((class_3264)class_3264.field_14190);
        resourceLoader.registerReloadListener((IdentifiableResourceReloadListener)BlockSoundGroupManager.INSTANCE);
    }

    @Deprecated(forRemoval=true)
    @Contract(value="_ -> new")
    @NotNull
    public static class_2960 resourceLocation(String path) {
        return new class_2960("frozenlib", path);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static String string(String path) {
        return FrozenMain.resourceLocation(path).toString();
    }
}

