/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.networking;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.frozenblock.lib.FrozenSharedConstants;
import net.frozenblock.lib.cape.api.CapeUtil;
import net.frozenblock.lib.cape.impl.ServerCapeData;
import net.frozenblock.lib.cape.impl.networking.CapeCustomizePacket;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.config.impl.network.ConfigSyncPacket;
import net.frozenblock.lib.event.api.PlayerJoinEvents;
import net.frozenblock.lib.image_transfer.FileTransferPacket;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.wind.api.WindManager;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.quiltmc.qsl.frozenblock.resource.loader.api.ResourceLoaderEvents;

public final class FrozenNetworking {
    public static final class_2960 WIND_SYNC_PACKET = FrozenSharedConstants.id("wind_sync_packet");
    public static final class_2960 STARTING_RESTRICTION_LOOPING_SOUND_PACKET = FrozenSharedConstants.id("starting_moving_restriction_looping_sound_packet");
    public static final class_2960 MOVING_RESTRICTION_LOOPING_FADING_DISTANCE_SOUND_PACKET = FrozenSharedConstants.id("moving_restriction_looping_fading_distance_sound_packet");
    public static final class_2960 FADING_DISTANCE_SOUND_PACKET = FrozenSharedConstants.id("fading_distance_sound_packet");
    public static final class_2960 MOVING_FADING_DISTANCE_SOUND_PACKET = FrozenSharedConstants.id("moving_fading_distance_sound_packet");

    private FrozenNetworking() {
    }

    public static void registerNetworking() {
        PlayerJoinEvents.ON_PLAYER_ADDED_TO_LEVEL.register((server, serverLevel, player) -> {
            WindManager windManager = WindManager.getWindManager(serverLevel);
            windManager.sendSyncToPlayer(windManager.createSyncByteBuf(), player);
            ServerCapeData.sendAllCapesToPlayer(player);
        });
        PlayerJoinEvents.ON_JOIN_SERVER.register((server, player) -> {
            ConfigSyncPacket.sendS2C(player);
            ServerCapeData.sendCapeReposToPlayer(player);
        });
        ResourceLoaderEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, error) -> {
            if (error != null || server == null) {
                return;
            }
            for (class_3222 player : PlayerLookup.all((MinecraftServer)server)) {
                ConfigSyncPacket.sendS2C(player);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(ConfigSyncPacket.PACKET_TYPE, (packet, player, sender) -> {
            if (ConfigSyncPacket.hasPermissionsToSendSync((class_1657)player, true)) {
                ConfigSyncPacket.receive(packet, player.field_13995);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(CapeCustomizePacket.PACKET_TYPE, (packet, ctx, sender) -> {
            UUID uuid = ctx.method_5667();
            class_2960 capeId = packet.getCapeId();
            if (capeId == null || CapeUtil.canPlayerUserCape(uuid, capeId)) {
                CapeCustomizePacket.sendCapeToAll(ctx.field_13995, uuid, capeId);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(FileTransferPacket.PACKET_TYPE, (packet, player, sender) -> {
            if (packet.request()) {
                Path path = player.field_13995.method_3831().toPath().resolve(packet.transferPath()).resolve(packet.fileName());
                try {
                    FileTransferPacket fileTransferPacket = FileTransferPacket.create(packet.transferPath(), path.toFile());
                    ServerPlayNetworking.send((class_3222)player, (FabricPacket)fileTransferPacket);
                }
                catch (IOException iOException) {}
            } else {
                if (!FrozenLibConfig.FILE_TRANSFER_SERVER) {
                    return;
                }
                try {
                    Path path = player.field_13995.method_3831().toPath().resolve(packet.transferPath().replace(".local/", "")).resolve(packet.fileName());
                    FileUtils.copyInputStreamToFile((InputStream)new ByteArrayInputStream(packet.bytes()), (File)path.toFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public static void sendPacketToAllPlayers(@NotNull class_3218 world, FabricPacket payload) {
        PlayerLookup.world((class_3218)world).forEach(player -> ServerPlayNetworking.send((class_3222)player, (FabricPacket)payload));
    }

    public static boolean isLocalPlayer(class_1657 player) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return false;
        }
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        return player.method_7334().getId().equals(class_310.method_1551().field_1724.method_7334().getId());
    }

    public static boolean connectedToIntegratedServer() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return false;
        }
        class_310 minecraft = class_310.method_1551();
        return minecraft.method_1496();
    }

    public static boolean connectedToServer() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return false;
        }
        class_310 minecraft = class_310.method_1551();
        class_634 listener = minecraft.method_1562();
        if (listener == null) {
            return false;
        }
        return listener.method_48296().method_10758();
    }

    public static boolean isMultiplayer() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return true;
        }
        return !class_310.method_1551().method_47392();
    }
}

