/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.shadow.xjs.data.Json;
import net.frozenblock.lib.shadow.xjs.data.JsonArray;
import net.frozenblock.lib.shadow.xjs.data.JsonLiteral;
import net.frozenblock.lib.shadow.xjs.data.JsonObject;
import net.frozenblock.lib.shadow.xjs.data.JsonString;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.serialization.parser.ValueParser;
import net.frozenblock.lib.shadow.xjs.data.serialization.util.PositionTrackingReader;

public class JsonParser
implements ValueParser {
    private final PositionTrackingReader reader;

    public JsonParser(String text) {
        this.reader = PositionTrackingReader.fromString(text);
    }

    public JsonParser(File file) throws IOException {
        this.reader = PositionTrackingReader.fromIs(new FileInputStream(file));
    }

    public JsonParser(File file, int bufferSize) throws IOException {
        this.reader = PositionTrackingReader.fromIs(new FileInputStream(file), bufferSize, false);
    }

    public JsonParser(PositionTrackingReader reader) {
        this.reader = reader;
    }

    @Override
    @NotNull
    public JsonValue parse() throws IOException {
        this.reader.skipWhitespace();
        int linesAbove = this.reader.linesSkipped;
        JsonValue result = this.readValue().setLinesAbove(linesAbove);
        this.reader.skipWhitespace();
        if (!this.reader.isEndOfText()) {
            throw this.reader.unexpected();
        }
        return result;
    }

    protected JsonValue readValue() throws IOException {
        return switch (this.reader.current) {
            case 110 -> this.readNull();
            case 116 -> this.readTrue();
            case 102 -> this.readFalse();
            case 34 -> this.readString();
            case 91 -> this.readArray();
            case 123 -> this.readObject();
            case 45, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57 -> Json.value(this.reader.readNumber());
            default -> throw this.reader.expected("value");
        };
    }

    protected JsonValue readNull() throws IOException {
        this.reader.read();
        this.reader.expect('u');
        this.reader.expect('l');
        this.reader.expect('l');
        return JsonLiteral.jsonNull();
    }

    protected JsonValue readTrue() throws IOException {
        this.reader.read();
        this.reader.expect('r');
        this.reader.expect('u');
        this.reader.expect('e');
        return JsonLiteral.jsonTrue();
    }

    protected JsonValue readFalse() throws IOException {
        this.reader.read();
        this.reader.expect('a');
        this.reader.expect('l');
        this.reader.expect('s');
        this.reader.expect('e');
        return JsonLiteral.jsonFalse();
    }

    protected JsonValue readString() throws IOException {
        return new JsonString(this.reader.readQuoted('\"'));
    }

    protected JsonArray readArray() throws IOException {
        this.reader.read();
        JsonArray array = new JsonArray();
        this.reader.skipWhitespace();
        if (this.reader.readIf(']')) {
            return array;
        }
        do {
            this.reader.skipWhitespace(false);
            int linesAbove = this.reader.linesSkipped;
            array.add(this.readValue().setLinesAbove(linesAbove));
            this.reader.skipWhitespace();
        } while (this.reader.readIf(','));
        if (!this.reader.readIf(']')) {
            throw this.reader.expected("',' or ']'");
        }
        return (JsonArray)array.setLinesTrailing(this.reader.linesSkipped);
    }

    protected JsonObject readObject() throws IOException {
        this.reader.read();
        JsonObject object = new JsonObject();
        this.reader.skipWhitespace();
        if (this.reader.readIf('}')) {
            return object;
        }
        do {
            this.reader.skipWhitespace(false);
            int linesAbove = this.reader.linesSkipped;
            String key = this.readKey();
            this.reader.skipWhitespace();
            this.reader.expect(':');
            this.reader.skipWhitespace();
            int linesBetween = this.reader.linesSkipped;
            object.add(key, this.readValue().setLinesAbove(linesAbove).setLinesBetween(linesBetween));
            this.reader.skipWhitespace();
        } while (this.reader.readIf(','));
        if (!this.reader.readIf('}')) {
            throw this.reader.expected("',' or '}'");
        }
        return (JsonObject)object.setLinesTrailing(this.reader.linesSkipped);
    }

    protected String readKey() throws IOException {
        if (this.reader.current != 34) {
            throw this.reader.expected("key");
        }
        return this.reader.readQuoted('\"');
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

