/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.structure.api;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Nullable;
import net.frozenblock.lib.worldgen.structure.api.WeightedProcessorRule;
import net.frozenblock.lib.worldgen.structure.impl.FrozenStructureProcessorTypes;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class WeightedRuleProcessor
extends class_3491 {
    public static final Codec<WeightedRuleProcessor> CODEC = WeightedProcessorRule.CODEC.listOf().fieldOf("rules").xmap(WeightedRuleProcessor::new, processor -> processor.rules).codec();
    private final ImmutableList<WeightedProcessorRule> rules;

    public WeightedRuleProcessor(List<? extends WeightedProcessorRule> rules) {
        this.rules = ImmutableList.copyOf(rules);
    }

    @Nullable
    public class_3499.class_3501 method_15110(class_4538 world, class_2338 pos, class_2338 pivot, class_3499.class_3501 localBlockInfo, class_3499.class_3501 absoluteBlockInfo, class_3492 placementData) {
        class_2338 posInfo = absoluteBlockInfo.comp_1341();
        class_5819 randomSource = class_5819.method_43049((long)class_3532.method_15389((class_2382)posInfo));
        class_2680 blockState = world.method_8320(posInfo);
        class_2680 inputState = absoluteBlockInfo.comp_1342();
        for (WeightedProcessorRule processorRule : this.rules) {
            if (!processorRule.test(inputState, blockState, localBlockInfo.comp_1341(), absoluteBlockInfo.comp_1341(), pivot, randomSource)) continue;
            return new class_3499.class_3501(absoluteBlockInfo.comp_1341(), processorRule.getOutputState(randomSource), absoluteBlockInfo.comp_1343());
        }
        return absoluteBlockInfo;
    }

    @NotNull
    protected class_3828<?> method_16772() {
        return FrozenStructureProcessorTypes.WEIGHTED_RULE_PROCESSOR;
    }
}

