/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3883;
import net.minecraft.class_591;
import net.minecraft.class_742;
import snownee.kiwi.contributor.client.CosmeticLayer;

public interface ITierProvider {
    public String getAuthor();

    public Set<String> getTiers();

    public List<String> getRenderableTiers();

    public Set<String> getPlayerTiers(String var1);

    default public CompletableFuture<Void> refresh() {
        return CompletableFuture.completedFuture(null);
    }

    @Environment(value=EnvType.CLIENT)
    public CosmeticLayer createRenderer(class_3883<class_742, class_591<class_742>> var1, String var2);

    default public boolean isContributor(String playerName) {
        return !this.getPlayerTiers(playerName).isEmpty();
    }

    default public boolean isContributor(String playerName, String tier) {
        return this.getPlayerTiers(playerName).contains(tier);
    }

    public static enum Empty implements ITierProvider
    {
        INSTANCE;


        @Override
        public String getAuthor() {
            return "";
        }

        @Override
        public Set<String> getTiers() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set<String> getPlayerTiers(String playerName) {
            return Collections.EMPTY_SET;
        }

        @Override
        public List<String> getRenderableTiers() {
            return Collections.EMPTY_LIST;
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public CosmeticLayer createRenderer(class_3883<class_742, class_591<class_742>> entityRenderer, String tier) {
            return null;
        }
    }
}

