/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.family;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2510;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.customization.block.family.BlockFamily;
import snownee.kiwi.util.KHolder;

public class BlockFamilyInferrer {
    public static final class_6862<class_2248> IGNORE = AbstractModule.blockTag("kswitch", "ignore");
    private final List<KHolder<BlockFamily>> families = Lists.newArrayList();
    private final Set<class_2248> capturedBlocks = Sets.newHashSet();
    private final List<String> colorPrefixed = Lists.newArrayList();
    private final List<String> colorSuffixed = Lists.newArrayList();
    private final List<String> logs = List.of("%s_log", "%s_wood", "stripped_%s_log", "stripped_%s_wood");
    private final List<String> netherLogs = List.of("%s_stem", "%s_hyphae", "stripped_%s_stem", "stripped_%s_hyphae");
    private final List<String> general = List.of("%s", "%s_planks", "%s_bricks", "%s_block", "%s_stairs", "%s_slab", "%s_wall", "%s_fence", "%s_fence_gate", "%s_door", "%s_trapdoor", "%s_button", "%s_pressure_plate");
    private final List<String> variants = List.of("%s", "chiseled_%s", "polished_%s", "cut_%s", "smooth_%s", "cracked_%s", "%s_bricks", "%s_pillar");

    public BlockFamilyInferrer() {
        for (class_1767 color : class_1767.values()) {
            this.colorPrefixed.add(color.method_7792() + "_%s");
            this.colorSuffixed.add("%s_" + color.method_7792());
        }
    }

    public Collection<KHolder<BlockFamily>> generate() {
        ArrayList sorted = Lists.newArrayList();
        for (class_6880 holder : class_7923.field_41175.method_40295()) {
            String path = ((class_5321)holder.method_40230().orElseThrow()).method_29177().method_12832();
            if (!path.startsWith("pink_") && !path.endsWith("_pink") && !path.endsWith("_log") && !path.endsWith("_stem") && !path.endsWith("_stairs") && !path.endsWith("_slab") && !path.startsWith("smooth_") || holder.method_40220(IGNORE)) continue;
            sorted.add(holder);
        }
        sorted.sort((a, b) -> {
            String aPath = ((class_5321)a.method_40230().orElseThrow()).method_29177().method_12832();
            String bPath = ((class_5321)b.method_40230().orElseThrow()).method_29177().method_12832();
            boolean aIsStairs = aPath.endsWith("_stairs");
            boolean bIsStairs = bPath.endsWith("_stairs");
            return Boolean.compare(bIsStairs, aIsStairs);
        });
        for (class_6880 holder : sorted) {
            class_2960 id;
            class_2248 block = (class_2248)holder.comp_349();
            if (this.capturedBlocks.contains(block)) continue;
            class_2960 key = ((class_5321)holder.method_40230().orElseThrow()).method_29177();
            String path = key.method_12832();
            boolean captured = false;
            if (path.startsWith("pink_")) {
                id = key.method_45136(path.substring(5));
                this.generateColored(id, this.colorPrefixed);
                captured = true;
            } else if (path.endsWith("_pink")) {
                id = key.method_45136(path.substring(0, path.length() - 5));
                this.generateColored(id, this.colorSuffixed);
                captured = true;
            }
            if (path.endsWith("_log")) {
                if (!holder.method_40220(class_3481.field_15475)) continue;
                id = key.method_45136(path.substring(0, path.length() - 4));
                this.fromTemplates(id, "logs", this.logs, true);
                continue;
            }
            if (path.endsWith("_stem")) {
                if (!holder.method_40220(class_3481.field_15475)) continue;
                id = key.method_45136(path.substring(0, path.length() - 5));
                this.fromTemplates(id, "logs", this.netherLogs, true);
                continue;
            }
            if (path.endsWith("_stairs")) {
                class_2960 id1;
                Optional holder1;
                if (!(block instanceof class_2510)) continue;
                class_2510 stairBlock = (class_2510)block;
                class_2960 id2 = key.method_45136(path.substring(0, path.length() - 7));
                List<class_6880.class_6883<class_2248>> blocks = this.collectBlocks(id2, this.general);
                if (id2.method_12832().endsWith("brick") && (holder1 = class_7923.field_41175.method_40264(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)(id1 = id2.method_48331("s"))))).isPresent()) {
                    id2 = id1;
                    blocks.add(0, (class_6880.class_6883<class_2248>)((class_6880.class_6883)holder1.get()));
                }
                blocks.addAll(this.collectBlocks(id2, this.variants));
                this.family(id2, "variants", blocks.stream().distinct().toList(), true);
                continue;
            }
            if (path.endsWith("_slab")) {
                id = key.method_45136(path.substring(0, path.length() - 5));
                this.fromTemplates(id, "general", this.general, true);
                captured = true;
            } else if (path.startsWith("smooth_")) {
                id = key.method_45136(path.substring(7));
                this.fromTemplates(id, "variants", this.variants, true);
                captured = true;
            }
            if (captured) continue;
            throw new IllegalStateException("Unrecognized block: " + holder.comp_349());
        }
        List<String> normalCopperTemplate = List.of("%s_block", "cut_%s", "chiseled_%s", "%s_grate");
        List<String> otherCopperTemplate = List.of("%s", "cut_%s", "chiseled_%s", "%s_grate");
        class_2960 copperId = new class_2960("copper");
        for (String waxed : List.of("", "waxed_")) {
            for (String variant : List.of("", "exposed_", "weathered_", "oxidized_")) {
                List<String> template = variant.isEmpty() ? normalCopperTemplate : otherCopperTemplate;
                template = template.stream().map($ -> waxed + variant + $).toList();
                this.fromTemplates(copperId, waxed + variant + "copper", template, true);
            }
        }
        return this.families;
    }

    private List<class_6880.class_6883<class_2248>> collectBlocks(class_2960 id, List<String> templates) {
        ArrayList blocks = Lists.newArrayList();
        for (String template : templates) {
            class_2960 blockId = id.method_45136(String.format(template, id.method_12832()));
            Optional holder = class_7923.field_41175.method_40264(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)blockId));
            holder.ifPresent(blocks::add);
        }
        return blocks;
    }

    private void fromTemplates(class_2960 id, String desc, List<String> templates, boolean cascading) {
        List<class_6880.class_6883<class_2248>> blocks = this.collectBlocks(id, templates);
        if (blocks.size() < 2) {
            return;
        }
        this.family(id, desc, blocks, cascading);
    }

    private void generateColored(class_2960 id, List<String> templates) {
        List<class_6880.class_6883<class_2248>> blocks = this.collectBlocks(id, templates);
        if (blocks.size() != templates.size()) {
            return;
        }
        this.family(id, "colored", blocks, false);
    }

    private void family(class_2960 id, String desc, List<class_6880.class_6883<class_2248>> blocks, boolean cascading) {
        List<class_5321<class_2248>> blockKeys = blocks.stream().filter($ -> !$.method_40220(IGNORE)).map(class_6880.class_6883::method_40237).toList();
        KHolder<BlockFamily> family = new KHolder<BlockFamily>(id.method_45138("auto/%s/".formatted(desc)), new BlockFamily(false, blockKeys, List.of(), List.of(), false, Optional.empty(), 1, BlockFamily.SwitchAttrs.create(true, cascading, false)));
        this.families.add(family);
        family.value().blocks().forEach(this.capturedBlocks::add);
    }
}

