/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.layer;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import journeymap.client.JourneymapClient;
import journeymap.client.api.impl.BlockInfo;
import journeymap.client.data.DataCache;
import journeymap.client.event.dispatchers.FullscreenEventDispatcher;
import journeymap.client.io.FileHandler;
import journeymap.client.io.ThemeLoader;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.RegionCoord;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.fullscreen.layer.Layer;
import journeymap.client.ui.option.LocationFormat;
import journeymap.client.ui.theme.Theme;
import journeymap.client.world.JmBlockAccess;
import journeymap.common.helper.BiomeHelper;
import journeymap.common.nbt.RegionData;
import journeymap.common.nbt.RegionDataStorageHandler;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5321;

public class BlockInfoLayer
extends Layer {
    private final List<DrawStep> drawStepList = new ArrayList<DrawStep>(1);
    LocationFormat locationFormat = new LocationFormat();
    LocationFormat.LocationFormatKeys locationFormatKeys;
    class_2338 lastCoord = null;
    PlayerInfoStep playerInfoStep;
    BlockInfoStep blockInfoStep = new BlockInfoStep();
    private boolean isSinglePlayer;
    long lastHover = 0L;
    private final long hoverDelay = 25L;
    private final class_310 mc;

    public BlockInfoLayer(Fullscreen fullscreen) {
        super(fullscreen);
        this.playerInfoStep = new PlayerInfoStep();
        this.mc = class_310.method_1551();
        this.isSinglePlayer = this.mc.method_1496();
    }

    @Override
    public List<DrawStep> onMouseMove(class_310 mc, GridRenderer gridRenderer, Point2D.Double mousePosition, class_2338 blockPos, float fontScale, boolean isScrolling) {
        long now = class_156.method_658();
        Rectangle2D.Double optionsToolbarRect = this.fullscreen.getOptionsToolbarBounds();
        Rectangle2D.Double menuToolbarRect = this.fullscreen.getMenuToolbarBounds();
        if (optionsToolbarRect == null || menuToolbarRect == null) {
            return Collections.emptyList();
        }
        if (now - this.lastHover < 25L) {
            return this.drawStepList;
        }
        if (this.drawStepList.isEmpty()) {
            this.drawStepList.add(this.playerInfoStep);
            this.drawStepList.add(this.blockInfoStep);
        }
        this.playerInfoStep.update(mc.method_22683().method_4480() / 2, optionsToolbarRect.getMaxY());
        if (!blockPos.equals((Object)this.lastCoord)) {
            this.getBlockInfo(blockPos, gridRenderer, (String info, BlockInfo.Builder builder) -> {
                FullscreenEventDispatcher.moveEvent((class_5321<class_1937>)class_310.method_1551().field_1687.method_27983(), builder.build(), mousePosition);
                this.blockInfoStep.update((String)info, gridRenderer.getWidth() >> 1, menuToolbarRect.getMinY());
            });
        }
        this.lastHover = now;
        return this.drawStepList;
    }

    private void getBlockInfo(class_2338 blockPos, GridRenderer gridRenderer, BiConsumer<String, BlockInfo.Builder> blockInfo) {
        BlockInfo.Builder infoBuilder = new BlockInfo.Builder();
        CompletableFuture.supplyAsync(() -> this.buildBlockInfo(blockPos, gridRenderer, infoBuilder), class_156.method_18349()).whenCompleteAsync((info, throwable) -> blockInfo.accept((String)info, infoBuilder), (Executor)class_156.method_18349());
    }

    private String buildBlockInfo(class_2338 blockPos, GridRenderer gridRenderer, BlockInfo.Builder infoBuilder) {
        this.lastCoord = blockPos;
        ChunkMD chunkMD = DataCache.INSTANCE.getChunkMD(blockPos);
        String info = "";
        infoBuilder.withBlockPos(blockPos);
        RegionCoord regionCoord = RegionCoord.fromChunkPos(FileHandler.getJMWorldDir(class_310.method_1551()), gridRenderer.getMapType(), blockPos.method_10263() >> 4, blockPos.method_10260() >> 4);
        RegionData regionData = RegionDataStorageHandler.getInstance().getRegionDataAsyncNoCache(regionCoord, gridRenderer.getMapType());
        class_2248 block = null;
        class_1959 biome = null;
        if (regionData != null && JourneymapClient.getInstance().getCoreProperties().dataCachingEnabled.get().booleanValue()) {
            class_2680 blockState = regionData.getBlockState(blockPos);
            if (blockState != null) {
                block = blockState.method_26204();
                infoBuilder.withBlockState(blockState);
            }
            biome = regionData.getBiome(blockPos);
        }
        if (chunkMD != null && chunkMD.hasChunk() && block == null) {
            BlockMD blockMD = chunkMD.getBlockMD(blockPos.method_10084());
            if (blockMD == null || blockMD.isIgnore()) {
                blockMD = chunkMD.getBlockMD(blockPos);
            }
            if (blockMD.isIgnore()) {
                blockMD = chunkMD.getBlockMD(blockPos.method_10074());
            }
            if (!blockMD.isIgnore()) {
                block = blockMD.getBlock();
            }
            infoBuilder.withBlockState(blockMD.getBlockState());
            infoBuilder.withChunk(chunkMD.getChunk());
        }
        if (biome == null) {
            biome = JmBlockAccess.INSTANCE.getBiome(blockPos);
        }
        String biomeName = "";
        if (block != null && biome != null) {
            biomeName = BiomeHelper.getTranslatedBiomeName(biome);
        }
        infoBuilder.withChunkPos(new class_1923(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4));
        infoBuilder.withBiome(biome);
        infoBuilder.withRegionX(regionCoord.regionX);
        infoBuilder.withRegionZ(regionCoord.regionZ);
        info = this.getBlockInfo(blockPos, biomeName, regionCoord);
        if (block != null) {
            infoBuilder.withBlock(block);
            String blockName = BlockMD.getBlockName(block);
            info = String.format("%s \u25a0 %s", blockName, info);
        }
        return info;
    }

    private String getBlockInfo(class_2338 blockPos, String biomeName, RegionCoord regionCoord) {
        FullMapProperties fullMapProperties = JourneymapClient.getInstance().getFullMapProperties();
        String region = "Region: x:" + regionCoord.regionX + " z:" + regionCoord.regionZ;
        this.locationFormatKeys = this.locationFormat.getFormatKeys(fullMapProperties.locationFormat.get());
        return this.locationFormatKeys.format(fullMapProperties.locationFormatVerbose.get(), blockPos.method_10263(), blockPos.method_10260(), blockPos.method_10264(), blockPos.method_10264() >> 4) + " " + biomeName + " " + region;
    }

    @Override
    public List<DrawStep> onMouseClick(class_310 mc, GridRenderer gridRenderer, Point2D.Double mousePosition, class_2338 blockCoord, int button, boolean doubleClick, float fontScale) {
        if (button == 1) {
            this.fullscreen.popupMenu.displayBasicOptions(blockCoord);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean propagateClick() {
        return true;
    }

    class BlockInfoStep
    implements DrawStep {
        private Theme.LabelSpec labelSpec;
        private double x;
        private double y;
        private String text;

        BlockInfoStep() {
        }

        void update(String text, double x, double y) {
            Theme theme = ThemeLoader.getCurrentTheme();
            this.labelSpec = theme.fullscreen.statusLabel;
            this.text = text;
            this.x = x;
            this.y = y - (double)theme.container.toolbar.horizontal.margin * BlockInfoLayer.this.fullscreen.getScaleFactor();
        }

        @Override
        public void draw(class_332 graphics, class_4597 buffers, DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
            if (pass == DrawStep.Pass.Text && JourneymapClient.getInstance().getFullMapProperties().showMouseLoc.get().booleanValue() && this.text != null) {
                DrawUtil.drawLabel(graphics, this.text, this.labelSpec, this.x, this.y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, fontScale, 0.0);
            }
        }

        @Override
        public int getDisplayOrder() {
            return 0;
        }

        @Override
        public String getModId() {
            return "journeymap";
        }
    }

    class PlayerInfoStep
    implements DrawStep {
        private Theme.LabelSpec labelSpec;
        private String prefix;
        private double x;
        private double y;

        PlayerInfoStep() {
        }

        void update(double x, double y) {
            Theme theme = ThemeLoader.getCurrentTheme();
            this.labelSpec = theme.fullscreen.statusLabel;
            if (this.prefix == null) {
                this.prefix = BlockInfoLayer.this.mc.field_1724.method_5477().getString() + " \u25a0 ";
            }
            this.x = x;
            this.y = y + (double)theme.container.toolbar.horizontal.margin * BlockInfoLayer.this.fullscreen.getScaleFactor();
        }

        @Override
        public void draw(class_332 graphics, class_4597 buffers, DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
            if (pass == DrawStep.Pass.Text && JourneymapClient.getInstance().getFullMapProperties().showPlayerLoc.get().booleanValue()) {
                DrawUtil.drawLabel(graphics, this.prefix + Fullscreen.state().playerLastPos, this.labelSpec, this.x, this.y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, fontScale, 0.0);
            }
        }

        @Override
        public int getDisplayOrder() {
            return 0;
        }

        @Override
        public String getModId() {
            return "journeymap";
        }
    }
}

