/*
 * Decompiled with CFR 0.152.
 */
package forge.me.thosea.badoptimizations.utils;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;

public final class CommonColorFactors {
    private static final Minecraft CLIENT = Objects.requireNonNull(Minecraft.m_91087_(), "loaded too early");
    public static final CommonColorFactors SKY_COLOR = new CommonColorFactors();
    public static final CommonColorFactors LIGHTMAP = new CommonColorFactors();
    private static int lastUpdateTick = -1;
    public static float lastRainGradient;
    public static float lastThunderGradient;
    public static int lastLightningTicks;
    public static float rainGradientMultiplier;
    public static float thunderGradientMultiplier;
    private boolean thisInstanceDirty;
    private boolean didTickChange;
    private long lastTime;

    private CommonColorFactors() {
    }

    public static void tick(float tickDelta) {
        int tick = CommonColorFactors.CLIENT.f_91074_.f_19797_;
        if (lastUpdateTick == tick) {
            return;
        }
        lastUpdateTick = tick;
        ClientLevel world = CommonColorFactors.CLIENT.f_91073_;
        boolean result = false;
        float rainGradient = world.m_46722_(tickDelta);
        float thunderGradient = world.m_46661_(tickDelta);
        int lightningTicks = world.m_104819_();
        if (rainGradient != lastRainGradient) {
            result = true;
            lastRainGradient = rainGradient;
            rainGradientMultiplier = rainGradient > 0.0f ? 1.0f - rainGradient * 0.75f : 0.0f;
        }
        if (thunderGradient != lastThunderGradient) {
            result = true;
            lastThunderGradient = thunderGradient;
            thunderGradientMultiplier = thunderGradient > 0.0f ? 1.0f - thunderGradient * 0.75f : 0.0f;
        }
        if (lastLightningTicks != lightningTicks) {
            result = true;
            lastLightningTicks = lightningTicks;
        }
        CommonColorFactors.SKY_COLOR.didTickChange = true;
        CommonColorFactors.LIGHTMAP.didTickChange = true;
        if (result) {
            CommonColorFactors.SKY_COLOR.thisInstanceDirty = true;
            CommonColorFactors.LIGHTMAP.thisInstanceDirty = true;
        }
    }

    public boolean isDirty() {
        if (this.thisInstanceDirty) {
            this.thisInstanceDirty = false;
            return true;
        }
        return false;
    }

    public boolean didTickChange() {
        if (this.didTickChange) {
            this.didTickChange = false;
            return true;
        }
        return false;
    }

    public long getTimeDelta() {
        return Math.abs(CommonColorFactors.CLIENT.f_91073_.m_8044_() - this.lastTime);
    }

    public void updateLastTime() {
        this.lastTime = CommonColorFactors.CLIENT.f_91073_.m_8044_();
    }
}

