/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import java.util.Iterator;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.access.ClientAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IInstanceRegistry;
import mcp.mobius.waila.api.IObjectPicker;
import mcp.mobius.waila.api.IRayCastVectorProvider;
import mcp.mobius.waila.api.ITargetRedirector;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.gui.hud.ComponentHandler;
import mcp.mobius.waila.gui.hud.Line;
import mcp.mobius.waila.gui.hud.RayCaster;
import mcp.mobius.waila.gui.hud.TargetRedirector;
import mcp.mobius.waila.gui.hud.Tooltip;
import mcp.mobius.waila.gui.hud.TooltipPosition;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.mixin.PlayerTabOverlayAccess;
import mcp.mobius.waila.pick.PickerAccessor;
import mcp.mobius.waila.pick.PickerResults;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.ProfilerUtil;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_746;

public class TooltipHandler {
    private static final ConfigTooltipRendererState STATE = new ConfigTooltipRendererState();
    private static final Tooltip TOOLTIP = new Tooltip();
    private static final class_2561 SNEAK_DETAIL = class_2561.method_43471((String)"tooltip.waila.sneak_for_details").method_27692(class_124.field_1056);

    public static void tick() {
        TooltipHandler.tick(STATE, false);
    }

    public static boolean tick(TooltipRenderer.State state, boolean inspect) {
        try (ProfilerUtil.Impl ignored = ProfilerUtil.profile("wthit:tick");){
            boolean bl = TooltipHandler._tick(state, inspect);
            return bl;
        }
    }

    private static boolean _tick(TooltipRenderer.State state, boolean inspect) {
        class_239 target;
        class_746 player;
        TooltipHandler.STATE.render = false;
        class_310 client = class_310.method_1551();
        WailaConfig.General config = Waila.CONFIG.get().getGeneral();
        if (client.field_1687 == null) {
            return false;
        }
        if (client.field_1761 == null) {
            return false;
        }
        if (!inspect) {
            if (client.field_1690.field_1842) {
                return false;
            }
            if (client.field_1755 != null && !(client.field_1755 instanceof class_408)) {
                return false;
            }
            if (!config.isDisplayTooltip()) {
                return false;
            }
            if (config.getDisplayMode() == IWailaConfig.General.DisplayMode.HOLD_KEY && !WailaClient.keyShowOverlay.method_1434()) {
                return false;
            }
            if (config.isHideFromPlayerList() && ((PlayerTabOverlayAccess)client.field_1705.method_1750()).wthit_isVisible()) {
                return false;
            }
            if (config.isHideFromDebug() && client.field_1690.field_1866) {
                return false;
            }
        }
        if ((player = client.field_1724) == null) {
            return false;
        }
        class_1297 camera = client.field_1719;
        if (camera == null) {
            return false;
        }
        float frameTime = client.method_1488();
        float pickRange = client.field_1761.method_2904();
        PickerResults results = PickerResults.get();
        class_243 castOrigin = null;
        class_243 castDirection = null;
        IObjectPicker picker = Registrar.get().picker;
        if (picker != null) {
            castOrigin = camera.method_5836(frameTime);
            castDirection = camera.method_5828(frameTime);
            picker.pick(PickerAccessor.of(client, camera, pickRange, frameTime), results, PluginConfig.CLIENT);
        } else {
            for (IInstanceRegistry.Entry<IRayCastVectorProvider> entry : Registrar.get().raycastVectorProviders.get(Object.class)) {
                IRayCastVectorProvider provider = entry.instance();
                if (!provider.isEnabled(PluginConfig.CLIENT)) continue;
                castOrigin = provider.getOrigin(frameTime);
                castDirection = provider.getDirection(frameTime);
                RayCaster.cast((class_1937)client.field_1687, camera, castOrigin, castDirection, pickRange, results);
                break;
            }
        }
        if (castOrigin == null) {
            return false;
        }
        Iterator<IInstanceRegistry.Entry<IRayCastVectorProvider>> iterator = results.iterator();
        while (iterator.hasNext() && TooltipHandler.processTarget(state, target = (class_239)iterator.next(), client, (class_1657)player, castOrigin, castDirection, pickRange, config) != ProcessResult.BREAK) {
        }
        return true;
    }

    private static ProcessResult redirectTarget(TooltipRenderer.State state, class_239 target, TargetRedirector redirector, class_310 client, class_1657 player, class_243 castOrigin, class_243 castDirection, double pickRange, WailaConfig.General config) {
        if (redirector.nowhere) {
            return ProcessResult.BREAK;
        }
        if (redirector.behind) {
            return ProcessResult.CONTINUE;
        }
        class_239 redirect = redirector.to;
        if (redirect == null) {
            return ProcessResult.CONTINUE;
        }
        if (redirect.method_17783() == class_239.class_240.field_1333) {
            return ProcessResult.CONTINUE;
        }
        return TooltipHandler.processTarget(state, redirect, client, player, castOrigin.method_1020(target.method_17784().method_1020(redirect.method_17784())), castDirection, pickRange, config);
    }

    private static ProcessResult processTarget(TooltipRenderer.State state, class_239 target, class_310 client, class_1657 player, class_243 castOrigin, class_243 castDirection, double pickRange, WailaConfig.General config) {
        ClientAccessor accessor = ClientAccessor.INSTANCE;
        accessor.set((class_1937)client.field_1687, player, target, client.field_1719, castOrigin, castDirection, pickRange, client.method_1488());
        TooltipRenderer.beginBuild(state);
        if (target.method_17783() == class_239.class_240.field_1332) {
            class_2248 block = accessor.getBlock();
            Object blockEntity = accessor.getBlockEntity();
            TargetRedirector redirector = TargetRedirector.get();
            int redirectPriority = Integer.MAX_VALUE;
            ITargetRedirector.Result redirectResult = null;
            for (IInstanceRegistry.Entry<IBlockComponentProvider> entry : Registrar.get().blockRedirect.get(block)) {
                redirectResult = entry.instance().redirect(redirector, accessor, PluginConfig.CLIENT);
                redirectPriority = entry.priority();
                if (redirectResult == null) continue;
                break;
            }
            boolean hasBeRedirector = false;
            for (IInstanceRegistry.Entry<IBlockComponentProvider> entry : Registrar.get().blockRedirect.get(blockEntity)) {
                if (entry.priority() >= redirectPriority) break;
                if (!hasBeRedirector) {
                    hasBeRedirector = true;
                    redirector = TargetRedirector.get();
                }
                if ((redirectResult = entry.instance().redirect(redirector, accessor, PluginConfig.CLIENT)) == null) continue;
                break;
            }
            if (redirectResult != null && !redirector.self) {
                return TooltipHandler.redirectTarget(state, target, redirector, client, player, castOrigin, castDirection, pickRange, config);
            }
            if (block instanceof class_2404 ? !PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_FLUID) : !PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_BLOCK)) {
                return ProcessResult.CONTINUE;
            }
            class_2680 class_26802 = ComponentHandler.getOverrideBlock(target);
            if (class_26802 == IBlockComponentProvider.EMPTY_BLOCK_STATE) {
                return ProcessResult.CONTINUE;
            }
            accessor.setState(class_26802);
            ComponentHandler.requestBlockData(accessor);
            TOOLTIP.clear();
            ComponentHandler.gatherBlock(accessor, TOOLTIP, TooltipPosition.HEAD);
            TooltipRenderer.add(TOOLTIP);
            TOOLTIP.clear();
            ComponentHandler.gatherBlock(accessor, TOOLTIP, TooltipPosition.BODY);
            if (config.isShiftForDetails() && !TOOLTIP.isEmpty() && !player.method_5715()) {
                if (!config.isHideShiftText()) {
                    TooltipRenderer.add(new Line(null).with(SNEAK_DETAIL));
                }
            } else {
                TooltipRenderer.add(TOOLTIP);
            }
            TOOLTIP.clear();
            ComponentHandler.gatherBlock(accessor, TOOLTIP, TooltipPosition.TAIL);
        } else if (target.method_17783() == class_239.class_240.field_1331) {
            IInstanceRegistry.Entry<IEntityComponentProvider> entry;
            Object actualEntity = accessor.getEntity();
            TargetRedirector redirector = TargetRedirector.get();
            ITargetRedirector.Result redirectResult = null;
            Iterator<IInstanceRegistry.Entry<IEntityComponentProvider>> redirectPriority = Registrar.get().entityRedirect.get(actualEntity).iterator();
            while (redirectPriority.hasNext() && (redirectResult = (entry = redirectPriority.next()).instance().redirect(redirector, accessor, PluginConfig.CLIENT)) == null) {
            }
            if (redirectResult != null && !redirector.self) {
                return TooltipHandler.redirectTarget(state, target, redirector, client, player, castOrigin, castDirection, pickRange, config);
            }
            if (!PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_ENTITY)) {
                return ProcessResult.CONTINUE;
            }
            if (actualEntity == null) {
                return ProcessResult.CONTINUE;
            }
            class_1297 targetEnt = ComponentHandler.getOverrideEntity(target);
            if (targetEnt == IEntityComponentProvider.EMPTY_ENTITY) {
                return ProcessResult.CONTINUE;
            }
            accessor.setEntity(targetEnt);
            if (targetEnt == null) {
                return ProcessResult.CONTINUE;
            }
            ComponentHandler.requestEntityData(targetEnt, accessor);
            TOOLTIP.clear();
            ComponentHandler.gatherEntity(targetEnt, accessor, TOOLTIP, TooltipPosition.HEAD);
            TooltipRenderer.add(TOOLTIP);
            TOOLTIP.clear();
            ComponentHandler.gatherEntity(targetEnt, accessor, TOOLTIP, TooltipPosition.BODY);
            if (config.isShiftForDetails() && !TOOLTIP.isEmpty() && !player.method_5715()) {
                if (!config.isHideShiftText()) {
                    TooltipRenderer.add(new Line(null).with(SNEAK_DETAIL));
                }
            } else {
                TooltipRenderer.add(TOOLTIP);
            }
            TOOLTIP.clear();
            ComponentHandler.gatherEntity(targetEnt, accessor, TOOLTIP, TooltipPosition.TAIL);
        }
        TooltipRenderer.add(TOOLTIP);
        if (PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_ICON)) {
            TooltipRenderer.setIcon(ComponentHandler.getIcon(target));
        }
        TooltipHandler.STATE.render = true;
        TooltipRenderer.endBuild();
        return ProcessResult.BREAK;
    }

    private static class ConfigTooltipRendererState
    implements TooltipRenderer.State {
        private boolean render;

        private ConfigTooltipRendererState() {
        }

        @Override
        public boolean render() {
            return this.render;
        }

        @Override
        public boolean fireEvent() {
            return true;
        }

        private WailaConfig.Overlay getOverlay() {
            return Waila.CONFIG.get().getOverlay();
        }

        @Override
        public int getFps() {
            return this.getOverlay().getFps();
        }

        @Override
        public float getScale() {
            return this.getOverlay().getScale();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAnchor() {
            return this.getOverlay().getPosition().getAnchor().getX();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAnchor() {
            return this.getOverlay().getPosition().getAnchor().getY();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAlign() {
            return this.getOverlay().getPosition().getAlign().getX();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAlign() {
            return this.getOverlay().getPosition().getAlign().getY();
        }

        @Override
        public int getX() {
            return this.getOverlay().getPosition().getX();
        }

        @Override
        public int getY() {
            return this.getOverlay().getPosition().getY();
        }

        @Override
        public boolean bossBarsOverlap() {
            return this.getOverlay().getPosition().isBossBarsOverlap();
        }

        @Override
        public ITheme getTheme() {
            return this.getOverlay().getColor().getTheme();
        }

        @Override
        public int getBackgroundAlpha() {
            return this.getOverlay().getColor().getBackgroundAlpha();
        }

        @Override
        public boolean enableTextToSpeech() {
            return Waila.CONFIG.get().getGeneral().isEnableTextToSpeech();
        }
    }

    private static enum ProcessResult {
        CONTINUE,
        BREAK;

    }
}

