/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.mcless.json5;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class Json5Writer
extends JsonWriter {
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private final Writer out;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private final String indent = "  ";
    private String deferredName;
    private String deferredComment;
    private final Function<List<String>, @Nullable String> commenter;
    private final ArrayList<String> pathNames;
    private final List<String> pathNamesView;

    public Json5Writer(Writer out, Function<List<String>, @Nullable String> commenter) {
        super(Writer.nullWriter());
        this.push(6);
        this.indent = "  ";
        this.pathNames = new ArrayList(32);
        this.pathNamesView = Collections.unmodifiableList(this.pathNames);
        Objects.requireNonNull(out, "Writer cannot be null");
        this.out = out;
        this.commenter = commenter;
    }

    public Json5Writer name(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException();
        }
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.deferredName = name;
        this.pathNames.set(this.pathNames.size() - 1, name);
        this.comment(this.commenter.apply(this.pathNamesView));
        return this;
    }

    public Json5Writer beginObject() throws IOException {
        this.writeDeferredName();
        return this.open(3, '{');
    }

    public Json5Writer endObject() throws IOException {
        return this.close(3, 5, '}');
    }

    public Json5Writer beginArray() throws IOException {
        this.writeDeferredName();
        return this.open(1, '[');
    }

    public Json5Writer endArray() throws IOException {
        return this.close(1, 2, ']');
    }

    public Json5Writer value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.string(value, true, true);
        return this;
    }

    public Json5Writer value(boolean value) throws IOException {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(value ? "true" : "false");
        return this;
    }

    public Json5Writer value(@Nullable Boolean value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(value != false ? "true" : "false");
        return this;
    }

    public Json5Writer value(Number value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        String string = value.toString();
        this.beforeValue();
        this.out.append(string);
        return this;
    }

    public Json5Writer value(double value) throws IOException {
        this.writeDeferredName();
        this.beforeValue();
        this.out.append(Double.toString(value));
        return this;
    }

    public Json5Writer value(long value) throws IOException {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(Long.toString(value));
        return this;
    }

    public Json5Writer nullValue() throws IOException {
        if (this.deferredName != null) {
            this.writeDeferredName();
        }
        this.beforeValue();
        this.out.write("null");
        return this;
    }

    public Json5Writer jsonValue(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.append(value);
        return this;
    }

    public Json5Writer comment(String comment) throws IOException {
        if (comment == null) {
            return this;
        }
        this.deferredComment = this.deferredComment == null ? comment : this.deferredComment + "\n" + comment;
        if (this.stackSize == 1 && this.peek() == 7) {
            this.out.append('\n');
            this.writeDeferredComment();
        }
        return this;
    }

    public void flush() throws IOException {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
        int size = this.stackSize;
        if (size > 1 || size == 1 && this.stack[size - 1] != 7) {
            throw new IOException("Incomplete document");
        }
        this.stackSize = 0;
    }

    private Json5Writer open(int empty, char openBracket) throws IOException {
        this.beforeValue();
        this.pathNames.add("NULL");
        this.push(empty);
        this.out.write(openBracket);
        return this;
    }

    private Json5Writer close(int empty, int nonempty, char closeBracket) throws IOException {
        int context = this.peek();
        if (context != nonempty && context != empty) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException("Dangling name: " + this.deferredName);
        }
        --this.stackSize;
        if (!this.pathNames.isEmpty()) {
            this.pathNames.remove(this.pathNames.size() - 1);
        }
        if (context == nonempty) {
            this.commentAndNewline();
        }
        this.out.write(closeBracket);
        return this;
    }

    private void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            int newLength = this.stackSize * 2;
            this.stack = Arrays.copyOf(this.stack, newLength);
            this.pathNames.ensureCapacity(newLength);
        }
        this.stack[this.stackSize++] = newTop;
    }

    private int peek() {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.stack[this.stackSize - 1];
    }

    private void replaceTop(int topOfStack) {
        this.stack[this.stackSize - 1] = topOfStack;
    }

    private void writeDeferredName() throws IOException {
        if (this.deferredName != null) {
            this.beforeName();
            boolean quotes = true;
            if (this.deferredName.length() > 0 && Character.isJavaIdentifierStart(this.deferredName.charAt(0))) {
                quotes = false;
                for (int i = 1; i < this.deferredName.length(); ++i) {
                    if (Character.isJavaIdentifierPart(this.deferredName.charAt(i))) continue;
                    quotes = true;
                    break;
                }
            }
            this.string(this.deferredName, quotes, true);
            this.deferredName = null;
        }
    }

    private void writeDeferredComment() throws IOException {
        if (this.deferredComment == null) {
            return;
        }
        for (String s : this.deferredComment.split("\n")) {
            int size = this.stackSize;
            for (int i = 1; i < size; ++i) {
                this.out.write("  ");
            }
            this.out.write("// ");
            this.string(s, false, false);
            this.out.write("\n");
        }
        this.deferredComment = null;
    }

    private void string(String value, boolean quotes, boolean escapeQuotesAndBackspace) throws IOException {
        if (quotes) {
            this.out.write(34);
        }
        int last = 0;
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            String replacement;
            char c = value.charAt(i);
            if (c < '\u0080') {
                if (!escapeQuotesAndBackspace && (c == '\"' || c == '\\') || (replacement = REPLACEMENT_CHARS[c]) == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i) {
                this.out.write(value, last, i - last);
            }
            this.out.write(replacement);
            last = i + 1;
        }
        if (last < length) {
            this.out.write(value, last, length - last);
        }
        if (quotes) {
            this.out.write(34);
        }
    }

    private void commentAndNewline() throws IOException {
        this.out.write(10);
        this.writeDeferredComment();
        int size = this.stackSize;
        for (int i = 1; i < size; ++i) {
            this.out.write("  ");
        }
    }

    private void beforeName() throws IOException {
        int context = this.peek();
        if (context == 5) {
            this.out.write(44);
        } else if (context != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.commentAndNewline();
        this.replaceTop(4);
    }

    private void beforeValue() throws IOException {
        switch (this.peek()) {
            case 7: {
                throw new IllegalStateException("JSON must have only one top-level value.");
            }
            case 6: {
                this.comment(this.commenter.apply(List.of()));
                this.writeDeferredComment();
                this.replaceTop(7);
                break;
            }
            case 1: {
                this.replaceTop(2);
                this.commentAndNewline();
                break;
            }
            case 2: {
                this.out.append(',');
                this.commentAndNewline();
                break;
            }
            case 4: {
                this.out.append(": ");
                this.replaceTop(5);
                break;
            }
            default: {
                throw new IllegalStateException("Nesting problem.");
            }
        }
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            Json5Writer.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        Json5Writer.REPLACEMENT_CHARS[34] = "\\\"";
        Json5Writer.REPLACEMENT_CHARS[92] = "\\\\";
        Json5Writer.REPLACEMENT_CHARS[9] = "\\t";
        Json5Writer.REPLACEMENT_CHARS[8] = "\\b";
        Json5Writer.REPLACEMENT_CHARS[10] = "\\n";
        Json5Writer.REPLACEMENT_CHARS[13] = "\\r";
        Json5Writer.REPLACEMENT_CHARS[12] = "\\f";
    }
}

