/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.serialization;

import com.cursee.monolib.core.serialization.ISerializer;
import com.cursee.monolib.core.serialization.NBTParseException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_3518;

public class SerializerCompoundTag
implements ISerializer<class_2487> {
    public static final ISerializer<class_2487> SERIALIZER = new SerializerCompoundTag();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    private SerializerCompoundTag() {
    }

    @Override
    public class_2487 fromJSON(JsonElement json) {
        try {
            if (json.isJsonObject()) {
                return class_2522.method_10718((String)GSON.toJson(json));
            }
            return class_2522.method_10718((String)class_3518.method_15287((JsonElement)json, (String)"nbt"));
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException("Failed to read NBT from " + class_3518.method_15266((JsonElement)json), (Throwable)e);
        }
    }

    @Override
    public JsonElement toJSON(class_2487 toWrite) {
        return new JsonPrimitive(toWrite.toString());
    }

    @Override
    public class_2487 fromByteBuf(class_2540 buffer) {
        return buffer.method_10798();
    }

    @Override
    public void toByteBuf(class_2540 buffer, class_2487 toWrite) {
        buffer.method_10794(toWrite);
    }

    @Override
    public class_2520 toNBT(class_2487 toWrite) {
        return toWrite;
    }

    @Override
    public class_2487 fromNBT(class_2520 nbt) {
        if (nbt instanceof class_2487) {
            class_2487 compound = (class_2487)nbt;
            return compound;
        }
        throw new NBTParseException("Expected NBT to be a compound tag. Class was " + String.valueOf(nbt.getClass()) + " with ID " + nbt.method_10711() + " instead.");
    }
}

