/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0017"}, d2={"Ljuuxel/adorn/util/Fractions;", "", "", "long", "", "digits", "(J)[I", "numerator", "denominator", "", "toString", "(JJ)Ljava/lang/String;", "whole", "(JJJ)Ljava/lang/String;", "", "FRACTION_BAR", "C", "", "SUBSCRIPTS", "[C", "SUPERSCRIPTS", "<init>", "()V", "Adorn"})
public final class Fractions {
    @NotNull
    public static final Fractions INSTANCE = new Fractions();
    @NotNull
    private static final char[] SUPERSCRIPTS;
    @NotNull
    private static final char[] SUBSCRIPTS;
    private static final char FRACTION_BAR = '\u2044';

    private Fractions() {
    }

    @NotNull
    public final String toString(long numerator, long denominator) {
        if (denominator == 1L) {
            return String.valueOf(numerator);
        }
        long realNumerator = numerator % denominator;
        long whole = (numerator - realNumerator) / denominator;
        return this.toString(whole, realNumerator, denominator);
    }

    @NotNull
    public final String toString(long whole, long numerator, long denominator) {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (MathKt.getSign((long)whole) * MathKt.getSign((long)numerator) * MathKt.getSign((long)denominator) == -1) {
            $this$toString_u24lambda_u240.append('-');
        }
        $this$toString_u24lambda_u240.append(Math.abs(whole));
        if (numerator != 0L) {
            $this$toString_u24lambda_u240.append(' ');
            for (int digit : INSTANCE.digits(numerator)) {
                $this$toString_u24lambda_u240.append(SUPERSCRIPTS[digit]);
            }
            $this$toString_u24lambda_u240.append('\u2044');
            for (int digit : INSTANCE.digits(denominator)) {
                $this$toString_u24lambda_u240.append(SUBSCRIPTS[digit]);
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final int[] digits(long l) {
        long abs = Math.abs(l);
        String str = String.valueOf(abs);
        int[] result = new int[str.length()];
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            char c = str.charAt(i);
            if (!('0' <= c ? c < ':' : false)) {
                throw new IllegalStateException(("Unknown digit character: " + c).toString());
            }
            result[i2] = c - 48;
        }
        return result;
    }

    static {
        char[] cArray = new char[]{'\u2070', '\u00b9', '\u00b2', '\u00b3', '\u2074', '\u2075', '\u2076', '\u2077', '\u2078', '\u2079'};
        SUPERSCRIPTS = cArray;
        cArray = new char[]{'\u2080', '\u2081', '\u2082', '\u2083', '\u2084', '\u2085', '\u2086', '\u2087', '\u2088', '\u2089'};
        SUBSCRIPTS = cArray;
    }
}

