/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.handrails;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.class_1767;
import net.minecraft.class_1936;
import net.minecraft.class_1944;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_7833;
import rbasamoyai.escalated.handrails.AbstractHandrailBlock;
import rbasamoyai.escalated.handrails.HandrailBlockEntity;
import rbasamoyai.escalated.handrails.HandrailData;
import rbasamoyai.escalated.handrails.HandrailRenderer;
import rbasamoyai.escalated.index.EscalatedMaterialSpecs;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class HandrailInstance
extends BlockEntityInstance<HandrailBlockEntity>
implements DynamicInstance {
    protected HandrailData leftHandrail;
    protected HandrailData rightHandrail;
    private float v0;
    private float v1;
    private class_2350 facing;
    private class_1767 handrailColor;

    public HandrailInstance(MaterialManager materialManager, HandrailBlockEntity blockEntity) {
        super(materialManager, (class_2586)blockEntity);
    }

    public void init() {
        super.init();
        AbstractHandrailBlock handrail = (AbstractHandrailBlock)this.blockState.method_26204();
        WalkwaySlope slope = handrail.getHandrailSlope(this.blockState);
        boolean end = handrail.isEndHandrail(this.blockState);
        AbstractHandrailBlock.Side side = (AbstractHandrailBlock.Side)((Object)this.blockState.method_11654(AbstractHandrailBlock.SIDE));
        this.handrailColor = ((HandrailBlockEntity)this.blockEntity).getHandrailColor();
        PartialModel partial = HandrailRenderer.getHandrailModel(slope, end);
        SpriteShiftEntry spriteShift = HandrailRenderer.getSpriteShift(this.handrailColor);
        Instancer handrailModel = this.materialManager.defaultSolid().material(EscalatedMaterialSpecs.HANDRAIL).getModel(partial, this.blockState);
        this.v0 = spriteShift.getTarget().method_4593();
        this.v1 = spriteShift.getTarget().method_4575();
        this.facing = (class_2350)this.blockState.method_11654((class_2769)AbstractHandrailBlock.field_11177);
        if (side == AbstractHandrailBlock.Side.LEFT || side == AbstractHandrailBlock.Side.BOTH) {
            this.leftHandrail = this.setup((HandrailData)handrailModel.createInstance(), true, spriteShift);
        }
        if (side == AbstractHandrailBlock.Side.RIGHT || side == AbstractHandrailBlock.Side.BOTH) {
            this.rightHandrail = this.setup((HandrailData)handrailModel.createInstance(), false, spriteShift);
        }
    }

    private HandrailData setup(HandrailData data, boolean left, SpriteShiftEntry spriteShift) {
        class_2350 offset = left ? this.facing.method_10160() : this.facing.method_10170();
        data.setScrollTexture(spriteShift).setScrollOffset(0.0f).setRotation(class_7833.field_40715.rotationDegrees(this.facing.method_10153().method_10144())).setPosition(this.getInstancePosition()).nudge((float)(offset.method_10148() * 7) / 16.0f, 0.0f, (float)(offset.method_10165() * 7) / 16.0f).setBlockLight(this.world.method_8314(class_1944.field_9282, this.pos)).setSkyLight(this.world.method_8314(class_1944.field_9284, this.pos));
        return data;
    }

    public void beginFrame() {
        float partialTick = AnimationTickHolder.getPartialTicks((class_1936)this.world);
        float scroll = HandrailRenderer.getScrollOffset((HandrailBlockEntity)this.blockEntity, partialTick, this.facing, this.v0, this.v1);
        if (this.leftHandrail != null) {
            this.leftHandrail.setScrollOffset(scroll);
        }
        if (this.rightHandrail != null) {
            this.rightHandrail.setScrollOffset(scroll);
        }
    }

    public boolean shouldReset() {
        if (super.shouldReset()) {
            return true;
        }
        return ((HandrailBlockEntity)this.blockEntity).getHandrailColor() != this.handrailColor;
    }

    public void updateLight() {
        super.updateLight();
        if (this.leftHandrail != null) {
            this.relight(this.pos, new FlatLit[]{this.leftHandrail});
        }
        if (this.rightHandrail != null) {
            this.relight(this.pos, new FlatLit[]{this.rightHandrail});
        }
    }

    protected void remove() {
        if (this.leftHandrail != null) {
            this.leftHandrail.delete();
        }
        this.leftHandrail = null;
        if (this.rightHandrail != null) {
            this.rightHandrail.delete();
        }
        this.rightHandrail = null;
    }
}

