/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.peripheral;

import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;

public final class AttachedComputerSet {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Set<IComputerAccess> computers = new HashSet<IComputerAccess>(0);

    public void add(IComputerAccess computer) {
        this.lock.writeLock().lock();
        try {
            this.computers.add(computer);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void remove(IComputerAccess computer) {
        this.lock.writeLock().lock();
        try {
            this.computers.remove(computer);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void forEach(Consumer<? super IComputerAccess> action) {
        this.lock.readLock().lock();
        try {
            this.computers.forEach(action);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void queueEvent(String event, Object ... arguments) {
        this.forEach(c -> c.queueEvent(event, arguments));
    }

    public boolean hasComputers() {
        this.lock.readLock().lock();
        try {
            boolean bl = !this.computers.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

