/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.core.methods.PeripheralMethod;

final class SaturatedMethod {
    private final Object target;
    private final String name;
    private final PeripheralMethod method;

    SaturatedMethod(Object target, String name, PeripheralMethod method) {
        this.target = target;
        this.name = name;
        this.method = method;
    }

    MethodResult apply(ILuaContext context, IComputerAccess computer, IArguments args) throws LuaException {
        return this.method.apply(this.target, context, computer, args);
    }

    String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SaturatedMethod)) {
            return false;
        }
        SaturatedMethod other = (SaturatedMethod)obj;
        return this.method == other.method && this.target.equals(other.target);
    }

    public int hashCode() {
        return 31 * this.target.hashCode() + this.method.hashCode();
    }
}

