/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.item;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.item.BalmItems;
import net.blay09.mods.balm.common.NamespaceResolver;
import net.blay09.mods.balm.common.StaticNamespaceResolver;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public record FabricBalmItems(NamespaceResolver namespaceResolver) implements BalmItems
{
    private static final Set<class_2960> managedCreativeTabs = Collections.synchronizedSet(new HashSet());
    private static final Multimap<class_2960, class_1935> creativeTabContents = Multimaps.synchronizedMultimap((Multimap)ArrayListMultimap.create());
    private static final Map<class_2960, Comparator<class_1935>> creativeTabSorting = new HashMap<class_2960, Comparator<class_1935>>();

    @Override
    public DeferredObject<class_1792> registerItem(Function<class_2960, class_1792> supplier, class_2960 identifier, @Nullable class_2960 creativeTab) {
        return new DeferredObject<class_1792>(identifier, () -> {
            class_1792 item = (class_1792)supplier.apply(identifier);
            item = (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)identifier, (Object)item);
            if (creativeTab != null) {
                this.manageCreativeModeTab(creativeTab);
                creativeTabContents.put((Object)creativeTab, (Object)item);
            }
            return item;
        }).resolveImmediately();
    }

    @Override
    public DeferredObject<class_1761> registerCreativeModeTab(Supplier<class_1799> iconSupplier, class_2960 identifier) {
        return new DeferredObject<class_1761>(identifier, () -> {
            class_5250 displayName = class_2561.method_43471((String)("itemGroup." + identifier.toString().replace(':', '.')));
            class_1761 creativeModeTab = FabricItemGroup.builder().method_47321((class_2561)displayName).method_47320(iconSupplier).method_47324();
            creativeModeTab = (class_1761)class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)identifier, (Object)creativeModeTab);
            return creativeModeTab;
        }).resolveImmediately();
    }

    @Override
    public void addToCreativeModeTab(class_2960 tabIdentifier, Supplier<class_1935[]> itemsSupplier) {
        this.manageCreativeModeTab(tabIdentifier);
        for (class_1935 itemStack : itemsSupplier.get()) {
            creativeTabContents.put((Object)tabIdentifier, (Object)itemStack);
        }
    }

    @Override
    public void setCreativeModeTabSorting(class_2960 tabIdentifier, Comparator<class_1935> comparator) {
        creativeTabSorting.put(tabIdentifier, comparator);
    }

    @Override
    public BalmItems scoped(String modId) {
        return new FabricBalmItems(new StaticNamespaceResolver(modId));
    }

    private void manageCreativeModeTab(class_2960 creativeTab) {
        if (!managedCreativeTabs.contains(creativeTab)) {
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)creativeTab)).register(entries -> {
                List<class_1935> itemStacks = creativeTabContents.get((Object)creativeTab);
                Comparator<class_1935> comparator = creativeTabSorting.get(creativeTab);
                List<class_1935> sortedItemStacks = comparator != null ? itemStacks.stream().sorted(comparator).toList() : itemStacks;
                Multimap<class_2960, class_1935> multimap = creativeTabContents;
                synchronized (multimap) {
                    sortedItemStacks.forEach(arg_0 -> ((FabricItemGroupEntries)entries).method_45421(arg_0));
                }
            });
            managedCreativeTabs.add(creativeTab);
        }
    }
}

