/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.events.extra;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.events.extra.AllowWalkingOnSnow;
import io.wispforest.accessories.api.events.extra.EndermanMasked;
import io.wispforest.accessories.api.events.extra.FortuneAdjustment;
import io.wispforest.accessories.api.events.extra.LootingAdjustment;
import io.wispforest.accessories.api.events.extra.PiglinNeutralInducer;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_47;

public class ExtraEventHandler {
    private static final LoadingCache<Integer, Map<Integer, TriState>> endermanAngyCacheResults = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(Duration.ofSeconds(1L)).weakKeys().build(CacheLoader.from(() -> new HashMap()));

    public static int lootingAdjustments(class_1309 entity, class_1282 damageSource, int currentLevel) {
        class_1297 class_12972;
        if (damageSource != null && (class_12972 = damageSource.method_5529()) instanceof class_1309) {
            class_1309 targetEntity = (class_1309)class_12972;
            AccessoriesCapability capability = AccessoriesCapability.get(entity);
            if (capability != null) {
                for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                    SlotReference reference = entryRef.reference();
                    class_1799 stack = entryRef.stack();
                    Accessory accessory = AccessoriesAPI.getAccessory(stack);
                    if (accessory instanceof LootingAdjustment) {
                        LootingAdjustment lootingAdjustment = (LootingAdjustment)((Object)accessory);
                        currentLevel += lootingAdjustment.getLootingAdjustment(stack, reference, targetEntity, damageSource, currentLevel);
                    }
                    currentLevel += ((LootingAdjustment)LootingAdjustment.EVENT.invoker()).getLootingAdjustment(stack, reference, targetEntity, damageSource, currentLevel);
                }
            }
        }
        return currentLevel;
    }

    public static int fortuneAdjustment(class_47 context, int currentLevel) {
        class_1309 livingEntity;
        AccessoriesCapability capability;
        Object object = context.method_296(class_181.field_1226);
        if (object instanceof class_1309 && (capability = AccessoriesCapability.get(livingEntity = (class_1309)object)) != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                SlotReference reference = entryRef.reference();
                class_1799 stack = entryRef.stack();
                Accessory accessory = AccessoriesAPI.getAccessory(stack);
                if (accessory instanceof FortuneAdjustment) {
                    FortuneAdjustment fortuneAdjustment = (FortuneAdjustment)((Object)accessory);
                    currentLevel += fortuneAdjustment.getFortuneAdjustment(stack, reference, context, currentLevel);
                }
                currentLevel += ((FortuneAdjustment)FortuneAdjustment.EVENT.invoker()).getFortuneAdjustment(stack, reference, context, currentLevel);
            }
        }
        return currentLevel;
    }

    public static TriState isPiglinsNeutral(class_1309 entity) {
        TriState state = TriState.DEFAULT;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                PiglinNeutralInducer inducer;
                SlotReference reference = entryRef.reference();
                class_1799 stack = entryRef.stack();
                Accessory accessory = AccessoriesAPI.getAccessory(stack);
                if (accessory instanceof PiglinNeutralInducer && (state = (inducer = (PiglinNeutralInducer)((Object)accessory)).makePiglinsNeutral(stack, reference)) != TriState.DEFAULT) {
                    return state;
                }
                state = ((PiglinNeutralInducer)PiglinNeutralInducer.EVENT.invoker()).makePiglinsNeutral(stack, reference);
                if (state == TriState.DEFAULT) continue;
                return state;
            }
        }
        return state;
    }

    public static TriState allowWalkingOnSnow(class_1309 entity) {
        TriState state = TriState.DEFAULT;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                AllowWalkingOnSnow event;
                SlotReference reference = entryRef.reference();
                class_1799 stack = entryRef.stack();
                Accessory accessory = AccessoriesAPI.getAccessory(stack);
                if (accessory instanceof AllowWalkingOnSnow && (state = (event = (AllowWalkingOnSnow)((Object)accessory)).allowWalkingOnSnow(stack, reference)) != TriState.DEFAULT) {
                    return state;
                }
                state = ((AllowWalkingOnSnow)AllowWalkingOnSnow.EVENT.invoker()).allowWalkingOnSnow(stack, reference);
                if (state == TriState.DEFAULT) continue;
                return state;
            }
        }
        return state;
    }

    public static TriState isEndermanMask(class_1309 entity, class_1560 enderMan) {
        Map cache = (Map)endermanAngyCacheResults.getIfPresent((Object)entity.method_5628());
        if (cache != null && cache.containsKey(enderMan.method_5628())) {
            return (TriState)cache.get(enderMan.method_5628());
        }
        TriState state = TriState.DEFAULT;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                EndermanMasked masked;
                SlotReference reference = entryRef.reference();
                class_1799 stack = entryRef.stack();
                Accessory accessory = AccessoriesAPI.getAccessory(stack);
                if (accessory instanceof EndermanMasked && (state = (masked = (EndermanMasked)((Object)accessory)).isEndermanMasked(enderMan, stack, reference)) != TriState.DEFAULT) {
                    return state;
                }
                state = ((EndermanMasked)EndermanMasked.EVENT.invoker()).isEndermanMasked(enderMan, stack, reference);
                if (state == TriState.DEFAULT) continue;
                return state;
            }
        }
        ((Map)endermanAngyCacheResults.getUnchecked((Object)entity.method_5628())).put(enderMan.method_5628(), state);
        return state;
    }
}

