/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.item;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.fluids.tank.FluidTankItem;
import com.simibubi.create.foundation.utility.VecHelper;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_6328;
import net.minecraft.server.MinecraftServer;
import net.zlt.create_vibrant_vaults.block.entity.AbstractItemVaultBlockEntity;

@ParametersAreNonnullByDefault
@class_6328
public abstract class AbstractItemVaultItem<BE extends AbstractItemVaultBlockEntity<BE>>
extends class_1747 {
    public AbstractItemVaultItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    protected abstract void setIsPlacingNbt(boolean var1);

    public class_1269 method_7712(class_1750 ctx) {
        this.setIsPlacingNbt(FluidTankItem.checkPlacingNbt((class_1750)ctx));
        class_1269 initialResult = super.method_7712(ctx);
        this.setIsPlacingNbt(false);
        if (initialResult.method_23665()) {
            this.tryMultiPlace(ctx);
        }
        return initialResult;
    }

    protected boolean method_7710(class_2338 pos, class_1937 level, @Nullable class_1657 player, class_1799 itemStack, class_2680 state) {
        MinecraftServer minecraftserver = level.method_8503();
        if (minecraftserver == null) {
            return false;
        }
        class_2487 nbt = itemStack.method_7941("BlockEntityTag");
        if (nbt != null) {
            nbt.method_10551("Length");
            nbt.method_10551("Size");
            nbt.method_10551("Controller");
            nbt.method_10551("LastKnownPos");
        }
        return super.method_7710(pos, level, player, itemStack, state);
    }

    protected abstract boolean isVault(class_2680 var1);

    protected abstract class_2591<BE> getBlockEntityType();

    @Nullable
    protected abstract class_2350.class_2351 getVaultBlockAxis(class_2680 var1);

    protected void tryMultiPlace(class_1750 ctx) {
        class_2680 blockState;
        class_2338 offsetPos;
        int zOffset;
        int xOffset;
        class_2338 startPos;
        class_2338 pos;
        class_2338 placedOnPos;
        class_1657 player = ctx.method_8036();
        if (player == null || player.method_5715()) {
            return;
        }
        class_2350 face = ctx.method_8038();
        class_1799 stack = ctx.method_8041();
        class_1937 world = ctx.method_8045();
        class_2680 placedOnState = world.method_8320(placedOnPos = (pos = ctx.method_8037()).method_10093(face.method_10153()));
        if (!this.isVault(placedOnState)) {
            return;
        }
        AbstractItemVaultBlockEntity vaultAt = (AbstractItemVaultBlockEntity)ConnectivityHandler.partAt(this.getBlockEntityType(), (class_1922)world, (class_2338)placedOnPos);
        if (vaultAt == null) {
            return;
        }
        Object controllerBE = vaultAt.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        int width = ((AbstractItemVaultBlockEntity)((Object)controllerBE)).radius;
        if (width == 1) {
            return;
        }
        int vaultsToPlace = 0;
        class_2350.class_2351 vaultBlockAxis = this.getVaultBlockAxis(placedOnState);
        if (vaultBlockAxis == null || face.method_10166() != vaultBlockAxis) {
            return;
        }
        class_2350 vaultFacing = class_2350.method_10169((class_2350.class_2351)vaultBlockAxis, (class_2350.class_2352)class_2350.class_2352.field_11056);
        class_2338 class_23382 = startPos = face == vaultFacing.method_10153() ? controllerBE.method_11016().method_10093(vaultFacing.method_10153()) : controllerBE.method_11016().method_10079(vaultFacing, ((AbstractItemVaultBlockEntity)((Object)controllerBE)).length);
        if (VecHelper.getCoordinate((class_2382)startPos, (class_2350.class_2351)vaultBlockAxis) != VecHelper.getCoordinate((class_2382)pos, (class_2350.class_2351)vaultBlockAxis)) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = vaultBlockAxis == class_2350.class_2351.field_11048 ? startPos.method_10069(0, xOffset, zOffset) : startPos.method_10069(xOffset, zOffset, 0);
                blockState = world.method_8320(offsetPos);
                if (this.isVault(blockState)) continue;
                if (!blockState.method_45474()) {
                    return;
                }
                ++vaultsToPlace;
            }
        }
        if (!player.method_7337() && stack.method_7947() < vaultsToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = vaultBlockAxis == class_2350.class_2351.field_11048 ? startPos.method_10069(0, xOffset, zOffset) : startPos.method_10069(xOffset, zOffset, 0);
                blockState = world.method_8320(offsetPos);
                if (this.isVault(blockState)) continue;
                class_1750 context = class_1750.method_16355((class_1750)ctx, (class_2338)offsetPos, (class_2350)face);
                player.getCustomData().method_10556("SilenceVaultSound", true);
                this.setIsPlacingNbt(FluidTankItem.checkPlacingNbt((class_1750)context));
                super.method_7712(context);
                this.setIsPlacingNbt(false);
                player.getCustomData().method_10551("SilenceVaultSound");
            }
        }
    }
}

