/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.psi;

import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import com.simibubi.create.foundation.item.ItemHandlerWrapper;
import com.simibubi.create.foundation.utility.fabric.ListeningStorageView;
import com.simibubi.create.foundation.utility.fabric.ProcessingIterator;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class PortableItemInterfaceBlockEntity
extends PortableStorageInterfaceBlockEntity
implements SidedStorageBlockEntity {
    protected InterfaceItemHandler capability = this.createEmptyHandler();

    public PortableItemInterfaceBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void startTransferringTo(Contraption contraption, float distance) {
        this.capability.setWrapped((Storage<ItemVariant>)contraption.getSharedInventory());
        super.startTransferringTo(contraption, distance);
    }

    @Override
    protected void stopTransferring() {
        this.capability.setWrapped((Storage<ItemVariant>)Storage.empty());
        super.stopTransferring();
    }

    private InterfaceItemHandler createEmptyHandler() {
        return new InterfaceItemHandler((Storage<ItemVariant>)Storage.empty());
    }

    @Override
    protected void invalidateCapability() {
        this.capability.setWrapped((Storage<ItemVariant>)Storage.empty());
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        return this.capability;
    }

    class InterfaceItemHandler
    extends ItemHandlerWrapper {
        public InterfaceItemHandler(Storage<ItemVariant> wrapped) {
            super(wrapped);
        }

        @Override
        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (!PortableItemInterfaceBlockEntity.this.canTransfer()) {
                return 0L;
            }
            long extracted = super.extract(resource, maxAmount, transaction);
            if (extracted != 0L) {
                TransactionCallback.onSuccess((TransactionContext)transaction, PortableItemInterfaceBlockEntity.this::onContentTransferred);
            }
            return extracted;
        }

        @Override
        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (!PortableItemInterfaceBlockEntity.this.canTransfer()) {
                return 0L;
            }
            long inserted = super.insert(resource, maxAmount, transaction);
            if (inserted != 0L) {
                TransactionCallback.onSuccess((TransactionContext)transaction, PortableItemInterfaceBlockEntity.this::onContentTransferred);
            }
            return inserted;
        }

        @Override
        @Nullable
        public StorageView<ItemVariant> exactView(ItemVariant resource) {
            return this.listen(super.exactView(resource));
        }

        @Override
        public Iterator<StorageView<ItemVariant>> iterator() {
            return new ProcessingIterator<StorageView<ItemVariant>>(super.iterator(), this::listen);
        }

        public <T> StorageView<T> listen(StorageView<T> view) {
            return new ListeningStorageView<T>(view, PortableItemInterfaceBlockEntity.this::onContentTransferred);
        }

        private void setWrapped(Storage<ItemVariant> wrapped) {
            this.wrapped = wrapped;
        }
    }
}

