/*
 * Decompiled with CFR 0.152.
 */
package dev.mrturtle.analog.gui;

import dev.mrturtle.analog.ModItems;
import dev.mrturtle.analog.config.ConfigManager;
import dev.mrturtle.analog.gui.RadioSelectChannelGui;
import dev.mrturtle.analog.util.RadioUtil;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;

public class RadioItemGui
extends SimpleGui {
    private final class_1799 radioStack;

    public RadioItemGui(class_3222 player, class_1799 radioStack) {
        super(class_3917.field_17328, player, false);
        this.radioStack = radioStack;
        this.createEnableButton();
        this.createTransmitButton();
        this.createReceiveButton();
        this.createChannelText();
        this.setSlot(0, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(ModItems.RADIO_CHANNEL_DOWN_BUTTON).setName((class_2561)class_2561.method_43471((String)"gui.analog.radio.channel_down")).setCallback(() -> {
            int currentChannel = RadioUtil.getRadioChannel(radioStack);
            RadioUtil.setRadioChannel(radioStack, Math.max(0, currentChannel - 1));
            this.createChannelText();
        })).build());
        this.setSlot(1, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(ModItems.RADIO_SET_CHANNEL_BUTTON).setName((class_2561)class_2561.method_43471((String)"gui.analog.radio.set_channel")).setCallback(() -> {
            RadioSelectChannelGui gui = new RadioSelectChannelGui(player, RadioUtil.getRadioChannel(radioStack), channel -> {
                RadioUtil.setRadioChannel(radioStack, channel);
                RadioItemGui radioGui = new RadioItemGui(player, radioStack);
                radioGui.open();
            });
            gui.open();
        })).build());
        this.setSlot(2, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(ModItems.RADIO_CHANNEL_UP_BUTTON).setName((class_2561)class_2561.method_43471((String)"gui.analog.radio.channel_up")).setCallback(() -> {
            int maxRadioChannel = ConfigManager.config.maxRadioChannels - 1;
            int currentChannel = RadioUtil.getRadioChannel(radioStack);
            RadioUtil.setRadioChannel(radioStack, Math.min(maxRadioChannel, currentChannel + 1));
            this.createChannelText();
        })).build());
    }

    private void createChannelText() {
        int currentChannel = RadioUtil.getRadioChannel(this.radioStack);
        Object channelText = String.valueOf(currentChannel);
        if (((String)channelText).length() == 1) {
            channelText = "0" + (String)channelText;
        }
        String offsetString = "z".repeat(((String)channelText).length() - 2);
        this.setTitle((class_2561)class_2561.method_43470((String)offsetString).method_10862(this.getTitleStyle()).method_10852((class_2561)this.getDefaultTitle().method_10852((class_2561)class_2561.method_43470((String)channelText))));
    }

    private void createEnableButton() {
        boolean isEnabled = RadioUtil.isRadioEnabled(this.radioStack);
        this.setSlot(4, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(isEnabled ? ModItems.RADIO_DISABLE_BUTTON : ModItems.RADIO_ENABLE_BUTTON).setName((class_2561)class_2561.method_43471((String)(isEnabled ? "gui.analog.radio.turn_off" : "gui.analog.radio.turn_on"))).setCallback(() -> {
            RadioUtil.setRadioEnabled(this.radioStack, !isEnabled);
            this.createEnableButton();
        })).build());
    }

    private void createTransmitButton() {
        boolean isTransmitting = RadioUtil.isRadioTransmitting(this.radioStack);
        this.setSlot(5, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(isTransmitting ? ModItems.RADIO_STOP_TRANSMIT_BUTTON : ModItems.RADIO_START_TRANSMIT_BUTTON).setName((class_2561)class_2561.method_43471((String)(isTransmitting ? "gui.analog.radio.stop_transmitting" : "gui.analog.radio.start_transmitting"))).setCallback(() -> {
            RadioUtil.setRadioTransmitting(this.radioStack, !isTransmitting);
            this.createTransmitButton();
        })).build());
    }

    private void createReceiveButton() {
        boolean isReceiving = RadioUtil.isRadioReceiving(this.radioStack);
        this.setSlot(3, (GuiElementInterface)((GuiElementBuilder)new GuiElementBuilder(isReceiving ? ModItems.RADIO_STOP_RECEIVE_BUTTON : ModItems.RADIO_START_RECEIVE_BUTTON).setName((class_2561)class_2561.method_43471((String)(isReceiving ? "gui.analog.radio.stop_receiving" : "gui.analog.radio.start_receiving"))).setCallback(() -> {
            RadioUtil.setRadioReceiving(this.radioStack, !isReceiving);
            this.createReceiveButton();
        })).build());
    }

    public class_5250 getDefaultTitle() {
        return class_2561.method_43470((String)"abc").method_10862(this.getTitleStyle());
    }

    public class_2583 getTitleStyle() {
        return class_2583.field_24360.method_10977(class_124.field_1068).method_27704(new class_2960("analog", "radio_gui"));
    }
}

