/*
 * Decompiled with CFR 0.152.
 */
package dev.mrturtle.analog.util;

import dev.mrturtle.analog.AnalogPlugin;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class RadioAudioUtil {
    public static AudioFormat FORMAT = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 48000.0f, 16, 1, 2, 48000.0f, false);

    public static short[] getAudioData(Path path) throws Exception {
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            BufferedInputStream bufferedInput = new BufferedInputStream(input);
            AudioInputStream stream = AudioSystem.getAudioInputStream(bufferedInput);
            short[] sArray = RadioAudioUtil.convertStreamToArray(stream);
            return sArray;
        }
    }

    public static float getAudioDuration(Path path) {
        return (float)path.toFile().length() / ((float)FORMAT.getFrameSize() * FORMAT.getFrameRate());
    }

    public static short[] convertStreamToArray(AudioInputStream stream) throws Exception {
        AudioFormat streamFormat = stream.getFormat();
        AudioFormat arrayFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, streamFormat.getSampleRate(), 16, streamFormat.getChannels(), streamFormat.getChannels() * 2, streamFormat.getSampleRate(), false);
        AudioInputStream stream1 = AudioSystem.getAudioInputStream(arrayFormat, stream);
        AudioInputStream stream2 = AudioSystem.getAudioInputStream(FORMAT, stream1);
        return AnalogPlugin.API.getAudioConverter().bytesToShorts(stream2.readAllBytes());
    }
}

