/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.wiretap.wiretap;

import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.ServerLevel;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.AudioPlayer;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import de.maxhenkel.voicechat.api.opus.OpusDecoder;
import de.maxhenkel.wiretap.Wiretap;
import de.maxhenkel.wiretap.WiretapVoicechatPlugin;
import de.maxhenkel.wiretap.soundeffects.SoundEffect;
import de.maxhenkel.wiretap.soundeffects.SoundEffectManager;
import de.maxhenkel.wiretap.utils.AudioUtils;
import de.maxhenkel.wiretap.wiretap.DimensionLocation;
import de.maxhenkel.wiretap.wiretap.WiretapManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class SpeakerChannel
implements Supplier<short[]> {
    private WiretapManager wiretapManager;
    private final UUID id;
    private final Map<UUID, List<short[]>> packetBuffer;
    private final DimensionLocation dimensionLocation;
    private final Map<UUID, OpusDecoder> decoders;
    private final SoundEffect effect;
    @Nullable
    private AudioPlayer audioPlayer;
    private long lastParticle = 0L;

    public SpeakerChannel(WiretapManager wiretapManager, UUID id, DimensionLocation dimensionLocation) {
        this.wiretapManager = wiretapManager;
        this.id = id;
        this.dimensionLocation = dimensionLocation;
        this.packetBuffer = new HashMap<UUID, List<short[]>>();
        this.decoders = new HashMap<UUID, OpusDecoder>();
        this.effect = SoundEffectManager.getSoundEffect();
    }

    public void addPacket(UUID sender, class_243 senderLocation, byte[] opusEncodedData) {
        DimensionLocation microphoneLocation = this.wiretapManager.getMicrophoneLocation(this.id);
        if (microphoneLocation == null) {
            Wiretap.LOGGER.warn("Microphone location not found for {}}", (Object)this.id);
            return;
        }
        List microphonePackets = this.packetBuffer.computeIfAbsent(sender, k -> new ArrayList());
        if (microphonePackets.isEmpty()) {
            for (int i = 0; i < Wiretap.SERVER_CONFIG.packetBufferSize.get(); ++i) {
                microphonePackets.add(null);
            }
        }
        OpusDecoder decoder = this.getDecoder(sender);
        if (opusEncodedData == null || opusEncodedData.length <= 0) {
            decoder.resetState();
            return;
        }
        double distance = microphoneLocation.getDistance(senderLocation);
        double volume = AudioUtils.getDistanceVolume(Wiretap.SERVER_CONFIG.microphonePickupRange.get(), distance);
        microphonePackets.add(AudioUtils.setVolume(decoder.decode(opusEncodedData), volume));
        if (this.audioPlayer == null) {
            this.getAudioPlayer().startPlaying();
        }
    }

    private OpusDecoder getDecoder(UUID sender) {
        return this.decoders.computeIfAbsent(sender, k -> WiretapVoicechatPlugin.voicechatServerApi.createDecoder());
    }

    private AudioPlayer getAudioPlayer() {
        if (this.audioPlayer == null) {
            ServerLevel serverLevel = WiretapVoicechatPlugin.voicechatServerApi.fromServerLevel((Object)this.dimensionLocation.getLevel());
            Position position = WiretapVoicechatPlugin.voicechatServerApi.createPosition((double)this.dimensionLocation.getX() + 0.5, (double)this.dimensionLocation.getY() + 0.5, (double)this.dimensionLocation.getZ() + 0.5);
            LocationalAudioChannel channel = WiretapVoicechatPlugin.voicechatServerApi.createLocationalAudioChannel(this.id, serverLevel, position);
            channel.setCategory(WiretapVoicechatPlugin.WIRETAP_CATEGORY);
            channel.setDistance(Wiretap.SERVER_CONFIG.speakerAudioRange.get().floatValue());
            this.audioPlayer = WiretapVoicechatPlugin.voicechatServerApi.createAudioPlayer((AudioChannel)channel, WiretapVoicechatPlugin.voicechatServerApi.createEncoder(), (Supplier)this);
        }
        return this.audioPlayer;
    }

    @Nullable
    public short[] generatePacket() {
        ArrayList<short[]> packetsToCombine = new ArrayList<short[]>();
        for (Map.Entry<UUID, List<short[]>> packets : this.packetBuffer.entrySet()) {
            if (packets.getValue().isEmpty()) continue;
            short[] audio = packets.getValue().remove(0);
            packetsToCombine.add(audio);
        }
        this.packetBuffer.values().removeIf(List::isEmpty);
        if (packetsToCombine.isEmpty()) {
            return null;
        }
        short[] combinedAudio = AudioUtils.combineAudio(packetsToCombine);
        this.spawnParticle();
        return this.effect.applyEffect(combinedAudio);
    }

    public void close() {
        this.decoders.values().forEach(OpusDecoder::close);
        if (this.audioPlayer != null) {
            this.audioPlayer.stopPlaying();
        }
    }

    @Override
    public short[] get() {
        short[] audio = this.generatePacket();
        if (audio == null) {
            if (this.audioPlayer != null) {
                this.audioPlayer.stopPlaying();
            }
            this.audioPlayer = null;
            return null;
        }
        return audio;
    }

    public DimensionLocation getDimensionLocation() {
        return this.dimensionLocation;
    }

    public void spawnParticle() {
        long time = System.currentTimeMillis();
        if (time - this.lastParticle < 1000L) {
            return;
        }
        this.lastParticle = time;
        class_3218 level = this.dimensionLocation.getLevel();
        class_243 vec3 = class_243.method_24955((class_2382)this.dimensionLocation.getPos()).method_1031(0.0, 0.8, 0.0);
        level.method_18456().stream().filter(player -> this.dimensionLocation.getDistance(player.method_19538()) <= 32.0).forEach(player -> level.method_8503().execute(() -> {
            float random = (float)level.method_8409().method_43048(4) / 24.0f;
            level.method_14199((class_2394)class_2398.field_11224, vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), 0, (double)random, 0.0, 0.0, 1.0);
        }));
    }

    public void onPlayerDisconnect(class_3222 serverPlayer) {
        OpusDecoder remove = this.decoders.remove(serverPlayer.method_5667());
        if (remove != null) {
            remove.close();
        }
    }
}

