/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity;

import io.github.fabricators_of_create.porting_lib.tags.Tags;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.CuttingBoardBlock;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.registry.ModAdvancements;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ConventionalTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class CuttingBoardBlockEntity
extends SyncedBlockEntity {
    private final ItemStackHandlerContainer inventory;
    private final ItemStackHandlerContainer inputHandler;
    private class_2960 lastRecipeID;
    private boolean isItemCarvingBoard;

    public CuttingBoardBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.CUTTING_BOARD.get(), pos, state);
        this.inputHandler = this.inventory = this.createHandler();
        this.isItemCarvingBoard = false;
    }

    public static void init() {
        ItemStorage.SIDED.registerForBlockEntity(CuttingBoardBlockEntity::getStorage, ModBlockEntityTypes.CUTTING_BOARD.get());
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.isItemCarvingBoard = compound.method_10577("IsItemCarved");
        this.inventory.deserializeNBT(compound.method_10562("Inventory"));
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10566("Inventory", (class_2520)this.inventory.serializeNBT());
        compound.method_10556("IsItemCarved", this.isItemCarvingBoard);
    }

    public boolean processStoredItemUsingTool(class_1799 toolStack, @Nullable class_1657 player) {
        if (this.field_11863 == null) {
            return false;
        }
        if (this.isItemCarvingBoard) {
            return false;
        }
        Optional<CuttingBoardRecipe> matchingRecipe = this.getMatchingRecipe(new RecipeWrapper((ItemStackHandler)this.inventory), toolStack, player);
        matchingRecipe.ifPresent(recipe -> {
            List<class_1799> results = recipe.rollResults(this.field_11863.field_9229, class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)toolStack));
            for (class_1799 resultStack : results) {
                class_2350 direction = ((class_2350)this.method_11010().method_11654((class_2769)CuttingBoardBlock.FACING)).method_10160();
                ItemUtils.spawnItemEntity(this.field_11863, resultStack.method_7972(), (double)this.field_11867.method_10263() + 0.5 + (double)direction.method_10148() * 0.2, (double)this.field_11867.method_10264() + 0.2, (double)this.field_11867.method_10260() + 0.5 + (double)direction.method_10165() * 0.2, (float)direction.method_10148() * 0.2f, 0.0, (float)direction.method_10165() * 0.2f);
            }
            if (player != null) {
                toolStack.method_7956(1, (class_1309)player, user -> user.method_20235(class_1304.field_6173));
            } else if (toolStack.method_7970(1, this.field_11863.field_9229, null)) {
                toolStack.method_7939(0);
            }
            this.playProcessingSound(recipe.getSoundEventID(), toolStack, this.getStoredItem());
            this.removeItem();
            if (player instanceof class_3222) {
                ModAdvancements.CUTTING_BOARD.trigger((class_3222)player);
            }
        });
        return matchingRecipe.isPresent();
    }

    private Optional<CuttingBoardRecipe> getMatchingRecipe(RecipeWrapper recipeWrapper, class_1799 toolStack, @Nullable class_1657 player) {
        class_1860 recipe;
        if (this.field_11863 == null) {
            return Optional.empty();
        }
        if (this.lastRecipeID != null && (recipe = ((RecipeManagerAccessor)this.field_11863.method_8433()).getRecipeMap(ModRecipeTypes.CUTTING.get()).get(this.lastRecipeID)) instanceof CuttingBoardRecipe && recipe.method_8115((class_1263)recipeWrapper, this.field_11863) && ((CuttingBoardRecipe)recipe).getTool().method_8093(toolStack)) {
            return Optional.of((CuttingBoardRecipe)recipe);
        }
        List recipeList = this.field_11863.method_8433().method_17877(ModRecipeTypes.CUTTING.get(), (class_1263)recipeWrapper, this.field_11863);
        if (recipeList.isEmpty()) {
            if (player != null) {
                player.method_7353((class_2561)TextUtils.getTranslation("block.cutting_board.invalid_item", new Object[0]), true);
            }
            return Optional.empty();
        }
        Optional<CuttingBoardRecipe> recipe2 = recipeList.stream().filter(cuttingRecipe -> cuttingRecipe.getTool().method_8093(toolStack)).findFirst();
        if (!recipe2.isPresent()) {
            if (player != null) {
                player.method_7353((class_2561)TextUtils.getTranslation("block.cutting_board.invalid_tool", new Object[0]), true);
            }
            return Optional.empty();
        }
        this.lastRecipeID = recipe2.get().method_8114();
        return recipe2;
    }

    public void playProcessingSound(String soundEventID, class_1799 tool, class_1799 boardItem) {
        class_3414 sound = (class_3414)class_7923.field_41172.method_10223(new class_2960(soundEventID));
        if (sound != null) {
            this.playSound(sound, 1.0f, 1.0f);
        } else if (tool.method_31573(Tags.Items.SHEARS)) {
            this.playSound(class_3417.field_14975, 1.0f, 1.0f);
        } else if (tool.method_31573(ConventionalTags.TOOLS_KNIVES)) {
            this.playSound(ModSounds.BLOCK_CUTTING_BOARD_KNIFE.get(), 0.8f, 1.0f);
        } else {
            class_1792 class_17922 = boardItem.method_7909();
            if (class_17922 instanceof class_1747) {
                class_1747 blockItem = (class_1747)class_17922;
                class_2248 block = blockItem.method_7711();
                class_2498 soundType = block.method_9564().method_26231();
                this.playSound(soundType.method_10595(), 1.0f, 0.8f);
            } else {
                this.playSound(class_3417.field_15215, 1.0f, 0.8f);
            }
        }
    }

    public void playSound(class_3414 sound, float volume, float pitch) {
        if (this.field_11863 != null) {
            this.field_11863.method_43128(null, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), sound, class_3419.field_15245, volume, pitch);
        }
    }

    public boolean addItem(class_1799 itemStack) {
        if (this.isEmpty() && !itemStack.method_7960()) {
            this.inventory.setStackInSlot(0, itemStack.method_7971(1));
            this.isItemCarvingBoard = false;
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public boolean carveToolOnBoard(class_1799 tool) {
        if (this.addItem(tool)) {
            this.isItemCarvingBoard = true;
            return true;
        }
        return false;
    }

    public class_1799 removeItem() {
        if (!this.isEmpty()) {
            this.isItemCarvingBoard = false;
            class_1799 item = this.inventory.method_5434(0, 1);
            this.inventoryChanged();
            return item;
        }
        return class_1799.field_8037;
    }

    public ItemStackHandlerContainer getInventory() {
        return this.inventory;
    }

    public class_1799 getStoredItem() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).method_7960();
    }

    public boolean isItemCarvingBoard() {
        return this.isItemCarvingBoard;
    }

    @NotNull
    public Storage<ItemVariant> getStorage(@Nullable class_2350 side) {
        return this.inputHandler;
    }

    public void method_11012() {
        super.method_11012();
    }

    private ItemStackHandlerContainer createHandler() {
        return new ItemStackHandlerContainer(){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                CuttingBoardBlockEntity.this.inventoryChanged();
            }
        };
    }
}

