/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.PlayerStatePacket;
import de.maxhenkel.voicechat.net.PlayerStatesPacket;
import de.maxhenkel.voicechat.net.RemovePlayerStatePacket;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_3222;

public class PlayerStateManager {
    private final ConcurrentHashMap<UUID, PlayerState> states;
    private final Server voicechatServer;

    public PlayerStateManager(Server voicechatServer) {
        this.voicechatServer = voicechatServer;
        this.states = new ConcurrentHashMap();
        CommonCompatibilityManager.INSTANCE.getNetManager().updateStateChannel.setServerListener((server, player, handler, packet) -> {
            PlayerState state = this.states.get(player.method_5667());
            if (state == null) {
                state = PlayerStateManager.defaultDisconnectedState(player);
            }
            state.setDisabled(packet.isDisabled());
            this.states.put(player.method_5667(), state);
            this.broadcastState(player, state);
            Voicechat.LOGGER.debug("Got state of {}: {}", player.method_5477().getString(), state);
        });
    }

    public void broadcastState(@Nullable class_3222 stateOwner, PlayerState state) {
        PlayerStatePacket packet = new PlayerStatePacket(state);
        for (class_3222 receiver : this.voicechatServer.getServer().method_3760().method_14571()) {
            if (stateOwner != null && !CommonCompatibilityManager.INSTANCE.canSee(receiver, stateOwner)) continue;
            NetManager.sendToClient(receiver, packet);
        }
        PluginManager.instance().onPlayerStateChanged(state);
    }

    public void broadcastRemoveState(class_3222 stateOwner) {
        RemovePlayerStatePacket packet = new RemovePlayerStatePacket(stateOwner.method_5667());
        for (class_3222 receiver : this.voicechatServer.getServer().method_3760().method_14571()) {
            NetManager.sendToClient(receiver, packet);
        }
        PluginManager.instance().onPlayerStateChanged(PlayerStateManager.defaultDisconnectedState(stateOwner));
    }

    public void onPlayerCompatibilityCheckSucceeded(class_3222 player) {
        ArrayList<PlayerState> stateList = new ArrayList<PlayerState>(this.states.size());
        for (PlayerState state : this.states.values()) {
            class_3222 otherPlayer = this.voicechatServer.getServer().method_3760().method_14602(state.getUuid());
            if (otherPlayer == null || !CommonCompatibilityManager.INSTANCE.canSee(player, otherPlayer)) continue;
            stateList.add(state);
        }
        PlayerStatesPacket packet = new PlayerStatesPacket(stateList);
        NetManager.sendToClient(player, packet);
        Voicechat.LOGGER.debug("Sending initial states to {}", player.method_5477().getString());
    }

    public void onPlayerLoggedIn(class_3222 player) {
        PlayerState state = PlayerStateManager.defaultDisconnectedState(player);
        this.states.put(player.method_5667(), state);
        this.broadcastState(player, state);
        Voicechat.LOGGER.debug("Setting default state of {}: {}", player.method_5477().getString(), state);
    }

    public void onPlayerLoggedOut(class_3222 player) {
        this.states.remove(player.method_5667());
        this.broadcastRemoveState(player);
        Voicechat.LOGGER.debug("Removing state of {}", player.method_5477().getString());
    }

    public void onPlayerHide(class_3222 visibilityChangedPlayer, class_3222 observingPlayer) {
        RemovePlayerStatePacket packet = new RemovePlayerStatePacket(visibilityChangedPlayer.method_5667());
        NetManager.sendToClient(observingPlayer, packet);
        Voicechat.LOGGER.debug("Removing state of {} for {}", visibilityChangedPlayer.method_5477().getString(), observingPlayer.method_5477().getString());
    }

    public void onPlayerShow(class_3222 visibilityChangedPlayer, class_3222 observingPlayer) {
        PlayerState state = this.states.get(visibilityChangedPlayer.method_5667());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(visibilityChangedPlayer);
        }
        PlayerStatePacket packet = new PlayerStatePacket(state);
        NetManager.sendToClient(observingPlayer, packet);
        Voicechat.LOGGER.debug("Sending state of {} to {}", visibilityChangedPlayer.method_5477().getString(), observingPlayer.method_5477().getString());
    }

    public void onPlayerVoicechatDisconnect(UUID uuid) {
        PlayerState state = this.states.get(uuid);
        if (state == null) {
            return;
        }
        state.setDisconnected(true);
        class_3222 player = this.voicechatServer.getServer().method_3760().method_14602(uuid);
        this.broadcastState(player, state);
        Voicechat.LOGGER.debug("Set state of {} to disconnected: {}", uuid, state);
    }

    public void onPlayerVoicechatConnect(class_3222 player) {
        PlayerState state = this.states.get(player.method_5667());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
        }
        state.setDisconnected(false);
        this.states.put(player.method_5667(), state);
        this.broadcastState(player, state);
        Voicechat.LOGGER.debug("Set state of {} to connected: {}", player.method_5477().getString(), state);
    }

    @Nullable
    public PlayerState getState(UUID playerUUID) {
        return this.states.get(playerUUID);
    }

    public static PlayerState defaultDisconnectedState(class_3222 player) {
        return new PlayerState(player.method_5667(), player.method_7334().getName(), false, true);
    }

    public void setGroup(class_3222 player, @Nullable UUID group) {
        PlayerState state = this.states.get(player.method_5667());
        if (state == null) {
            state = PlayerStateManager.defaultDisconnectedState(player);
            Voicechat.LOGGER.debug("Defaulting to default state for {}: {}", player.method_5477().getString(), state);
        }
        state.setGroup(group);
        this.states.put(player.method_5667(), state);
        this.broadcastState(player, state);
        Voicechat.LOGGER.debug("Setting group of {}: {}", player.method_5477().getString(), state);
    }

    public Collection<PlayerState> getStates() {
        return this.states.values();
    }
}

