/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.fixed_cannon_mount;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.crank.ValveHandleBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import rbasamoyai.createbigcannons.cannon_control.ControlPitchContraption;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.ExtendsCannonMount;
import rbasamoyai.createbigcannons.cannon_control.contraption.AbstractMountedCannonContraption;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannon_control.fixed_cannon_mount.FixedCannonMountBlock;
import rbasamoyai.createbigcannons.cannons.CannonContraptionProviderBlock;
import rbasamoyai.createbigcannons.index.CBCBlocks;

public class FixedCannonMountBlockEntity
extends SmartBlockEntity
implements IDisplayAssemblyExceptions,
ControlPitchContraption.Block,
IHaveGoggleInformation {
    private AssemblyException lastException = null;
    protected PitchOrientedContraptionEntity mountedContraption;
    private boolean running;
    private float cannonYaw;
    private float cannonPitch;
    private FixedCannonMountScrollValueBehaviour pitchSlot;
    private FixedCannonMountScrollValueBehaviour yawSlot;

    public FixedCannonMountBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        if (CBCBlocks.FIXED_CANNON_MOUNT.has(state)) {
            this.cannonYaw = ((class_2350)state.method_11654((class_2769)FixedCannonMountBlock.field_10927)).method_10144();
        }
        this.setLazyTickRate(3);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.pitchSlot = new FixedCannonMountScrollValueBehaviour(this, true);
        behaviours.add((BlockEntityBehaviour)this.pitchSlot);
        this.yawSlot = new FixedCannonMountScrollValueBehaviour(this, false);
        behaviours.add((BlockEntityBehaviour)this.yawSlot);
    }

    public void onRedstoneUpdate(boolean assemblyPowered, boolean prevAssemblyPowered, boolean firePowered, boolean prevFirePowered, int firePower) {
        class_1937 class_19372;
        if (assemblyPowered != prevAssemblyPowered) {
            this.method_10997().method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)FixedCannonMountBlock.ASSEMBLY_POWERED, (Comparable)Boolean.valueOf(assemblyPowered)), 3);
            if (assemblyPowered) {
                try {
                    this.assemble();
                    this.lastException = null;
                }
                catch (AssemblyException e) {
                    this.lastException = e;
                    this.sendData();
                }
            } else {
                this.disassemble();
                this.sendData();
            }
        }
        if (firePowered != prevFirePowered) {
            this.method_10997().method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)FixedCannonMountBlock.FIRE_POWERED, (Comparable)Boolean.valueOf(firePowered)), 3);
        }
        if (this.running && this.mountedContraption != null && (class_19372 = this.method_10997()) instanceof class_3218) {
            class_3218 slevel = (class_3218)class_19372;
            ((AbstractMountedCannonContraption)this.mountedContraption.getContraption()).onRedstoneUpdate(slevel, this.mountedContraption, firePowered != prevFirePowered, firePower, this);
        }
    }

    public void tick() {
        super.tick();
        if (this.mountedContraption != null && !this.mountedContraption.method_5805()) {
            this.mountedContraption = null;
        }
        this.applyRotation();
    }

    protected void applyRotation() {
        if (this.mountedContraption == null) {
            return;
        }
        class_2350 dir = this.mountedContraption.getInitialOrientation();
        boolean flag = dir.method_10171() == class_2350.class_2352.field_11056 == (dir.method_10166() == class_2350.class_2351.field_11048);
        float sgn = flag ? 1.0f : -1.0f;
        float pitchAdjust = this.pitchSlot == null ? 0.0f : (float)this.pitchSlot.getValue();
        this.mountedContraption.pitch = (this.cannonPitch + pitchAdjust) * sgn;
        float yawAdjust = this.yawSlot == null ? 0.0f : (float)this.yawSlot.getValue();
        this.mountedContraption.yaw = this.cannonYaw + yawAdjust;
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.running && this.mountedContraption != null) {
            this.sendData();
        }
    }

    protected void assemble() throws AssemblyException {
        PitchOrientedContraptionEntity contraptionEntity;
        if (!CBCBlocks.FIXED_CANNON_MOUNT.has(this.method_11010())) {
            return;
        }
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
        class_2338 assemblyPos = this.field_11867.method_10093(facing);
        if (this.method_10997().method_31606(assemblyPos)) {
            throw CannonMountBlockEntity.cannonBlockOutsideOfWorld(assemblyPos);
        }
        AbstractMountedCannonContraption mountedCannon = this.getContraption(assemblyPos);
        if (mountedCannon == null || !mountedCannon.assemble(this.method_10997(), assemblyPos)) {
            return;
        }
        class_2350 facing1 = mountedCannon.initialOrientation();
        this.running = true;
        mountedCannon.removeBlocksFromWorld(this.method_10997(), class_2338.field_10980);
        this.mountedContraption = contraptionEntity = PitchOrientedContraptionEntity.create(this.method_10997(), (Contraption)mountedCannon, facing1, this);
        this.resetContraptionToOffset();
        this.method_10997().method_8649((class_1297)contraptionEntity);
        this.sendData();
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.method_10997(), (class_2382)this.field_11867);
    }

    private AbstractMountedCannonContraption getContraption(class_2338 pos) {
        AbstractMountedCannonContraption abstractMountedCannonContraption;
        class_2248 class_22482 = this.field_11863.method_8320(pos).method_26204();
        if (class_22482 instanceof CannonContraptionProviderBlock) {
            CannonContraptionProviderBlock provBlock = (CannonContraptionProviderBlock)class_22482;
            abstractMountedCannonContraption = provBlock.getCannonContraption();
        } else {
            abstractMountedCannonContraption = null;
        }
        return abstractMountedCannonContraption;
    }

    protected void resetContraptionToOffset() {
        if (this.mountedContraption == null) {
            return;
        }
        this.cannonPitch = 0.0f;
        this.cannonYaw = this.getContraptionDirection().method_10144();
        this.mountedContraption.pitch = this.cannonPitch;
        this.mountedContraption.yaw = this.cannonYaw;
        this.mountedContraption.prevPitch = this.mountedContraption.pitch;
        this.mountedContraption.prevYaw = this.mountedContraption.yaw;
        this.mountedContraption.method_36457(this.cannonPitch);
        this.mountedContraption.method_36456(this.cannonYaw);
        this.mountedContraption.field_6004 = this.mountedContraption.method_36455();
        this.mountedContraption.field_5982 = this.mountedContraption.method_36454();
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
        class_243 vec = class_243.method_24955((class_2382)this.field_11867.method_10093(facing));
        this.mountedContraption.method_33574(vec);
    }

    public class_2350 getContraptionDirection() {
        return this.mountedContraption == null ? class_2350.field_11043 : ((AbstractMountedCannonContraption)this.mountedContraption.getContraption()).initialOrientation();
    }

    @Override
    public void disassemble() {
        if (!this.running && this.mountedContraption == null) {
            return;
        }
        if (this.mountedContraption != null) {
            this.resetContraptionToOffset();
            this.mountedContraption.method_5662(new class_2487());
            this.mountedContraption.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.method_10997(), (class_2382)this.field_11867);
        }
        this.running = false;
    }

    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    @Override
    public boolean isAttachedTo(AbstractContraptionEntity entity) {
        return this.mountedContraption == entity;
    }

    @Override
    public void attach(PitchOrientedContraptionEntity contraption) {
        if (!(contraption.getContraption() instanceof AbstractMountedCannonContraption)) {
            return;
        }
        this.mountedContraption = contraption;
        if (!this.field_11863.field_9236) {
            this.running = true;
            this.sendData();
        }
    }

    @Override
    public void onStall() {
        if (!this.field_11863.field_9236) {
            this.sendData();
        }
    }

    @Override
    public class_2338 getDismountPositionForContraption(PitchOrientedContraptionEntity poce) {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
        return this.field_11867.method_10093(this.mountedContraption.getInitialOrientation().method_10153()).method_10093(facing);
    }

    @Override
    public class_2680 getControllerState() {
        return this.method_11010();
    }

    @Override
    public class_2338 getControllerBlockPos() {
        return this.field_11867;
    }

    public void remove() {
        this.field_11865 = true;
        if (!this.field_11863.field_9236) {
            this.disassemble();
        }
        super.remove();
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10556("Running", this.running);
        tag.method_10548("CannonYaw", this.cannonYaw);
        tag.method_10548("CannonPitch", this.cannonPitch);
        AssemblyException.write((class_2487)tag, (AssemblyException)this.lastException);
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.running = tag.method_10577("Running");
        this.cannonYaw = tag.method_10583("CannonYaw");
        this.cannonPitch = tag.method_10583("CannonPitch");
        this.lastException = AssemblyException.read((class_2487)tag);
        if (!clientPacket) {
            return;
        }
        if (!this.running) {
            this.mountedContraption = null;
        }
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        ExtendsCannonMount.addCannonInfoToTooltip(tooltip, this.mountedContraption);
        return true;
    }

    public class_243 getInteractionLocation() {
        class_243 class_2432;
        Contraption contraption;
        if (this.mountedContraption != null && (contraption = this.mountedContraption.getContraption()) instanceof AbstractMountedCannonContraption) {
            AbstractMountedCannonContraption cannon = (AbstractMountedCannonContraption)contraption;
            class_2432 = cannon.getInteractionVec(this.mountedContraption);
        } else {
            class_2432 = class_243.method_24953((class_2382)this.field_11867);
        }
        return class_2432;
    }

    @Nullable
    public PitchOrientedContraptionEntity getContraption() {
        return this.mountedContraption;
    }

    public static class FixedCannonMountScrollValueBehaviour
    extends ValveHandleBlockEntity.ValveHandleScrollValueBehaviour {
        public static final BehaviourType<FixedCannonMountScrollValueBehaviour> PITCH_TYPE = new BehaviourType();
        public static final BehaviourType<FixedCannonMountScrollValueBehaviour> YAW_TYPE = new BehaviourType();
        private final boolean pitch;
        private final ValueBoxTransform newSlotPositioning;

        public FixedCannonMountScrollValueBehaviour(SmartBlockEntity be, boolean pitch) {
            super(be);
            String suffix = pitch ? "pitch" : "yaw";
            this.setLabel((class_2561)Lang.builder((String)"createbigcannons").translate("fixed_cannon_mount.angle_" + suffix, new Object[0]).component());
            this.newSlotPositioning = new FixedCannonMountValueBox(pitch);
            this.pitch = pitch;
            this.between(-45, 45);
            this.withFormatter(v -> String.format("%s%d", v < 0 ? "-" : (v > 0 ? "+" : ""), Math.abs(v)) + Lang.translateDirect((String)"generic.unit.degrees", (Object[])new Object[0]).getString());
        }

        public boolean testHit(class_243 hit) {
            class_2680 state = this.blockEntity.method_11010();
            class_243 localHit = hit.method_1020(class_243.method_24954((class_2382)this.blockEntity.method_11016()));
            return this.newSlotPositioning.testHit(state, localHit);
        }

        public class_5250 formatValue(ValueSettingsBehaviour.ValueSettings settings) {
            int sgn = settings.row() == 0 ? -1 : 1;
            return Lang.number((double)(settings.value() * sgn)).add(Lang.translateDirect((String)"generic.unit.degrees", (Object[])new Object[0])).component();
        }

        public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side) {
        }

        public void setValueSettings(class_1657 player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlHeld) {
            int value = valueSetting.value();
            if (!valueSetting.equals((Object)this.getValueSettings())) {
                this.playFeedbackSound((BlockEntityBehaviour)this);
            }
            this.setValue(valueSetting.row() == 0 ? -value : value);
        }

        public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
            ImmutableList rows = ImmutableList.of((Object)Components.literal((String)"-").method_27692(class_124.field_1067), (Object)Components.literal((String)"+").method_27692(class_124.field_1067));
            return new ValueSettingsBoard(this.label, 45, 15, (List)rows, new ValueSettingsFormatter(this::formatValue));
        }

        public ValueBoxTransform getSlotPositioning() {
            return this.newSlotPositioning;
        }

        public BehaviourType<?> getType() {
            return this.pitch ? PITCH_TYPE : YAW_TYPE;
        }

        public boolean setsPitch() {
            return this.pitch;
        }

        public void write(class_2487 nbt, boolean clientPacket) {
            nbt.method_10569(this.pitch ? "PitchAdjustment" : "YawAdjustment", this.value);
        }

        public void read(class_2487 nbt, boolean clientPacket) {
            this.value = nbt.method_10550(this.pitch ? "PitchAdjustment" : "YawAdjustment");
        }
    }

    public static class FixedCannonMountValueBox
    extends CenteredSideValueBoxTransform {
        private final boolean pitch;

        public FixedCannonMountValueBox(boolean pitch) {
            super((state, dir) -> state.method_11654((class_2769)class_2741.field_12525) != dir);
            this.pitch = pitch;
        }

        protected class_243 getSouthLocation() {
            double xOffset = this.pitch ? -4.0 : 4.0;
            return VecHelper.voxelSpace((double)(8.0 + xOffset), (double)8.0, (double)15.5);
        }
    }
}

