/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.boring;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import rbasamoyai.createbigcannons.crafting.BlockRecipe;
import rbasamoyai.createbigcannons.crafting.BlockRecipeIngredient;
import rbasamoyai.createbigcannons.crafting.BlockRecipeSerializer;
import rbasamoyai.createbigcannons.crafting.BlockRecipeType;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class DrillBoringBlockRecipe
implements BlockRecipe {
    private final BlockRecipeIngredient input;
    private final class_2248 result;
    private final class_2960 id;
    private final boolean obeyFacingOrAxis;

    public DrillBoringBlockRecipe(class_2960 id, BlockRecipeIngredient input, class_2248 result, boolean obeyFacingOrAxis) {
        this.id = id;
        this.input = input;
        this.result = result;
        this.obeyFacingOrAxis = obeyFacingOrAxis;
    }

    public boolean matches(class_2680 state, class_2350 dir) {
        if (this.obeyFacingOrAxis) {
            if (state.method_28498((class_2769)class_2741.field_12525) && ((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10166() != dir.method_10166()) {
                return false;
            }
            if (state.method_28498((class_2769)class_2741.field_12496) && state.method_11654((class_2769)class_2741.field_12496) != dir.method_10166()) {
                return false;
            }
        }
        return this.input.test(state);
    }

    @Override
    public boolean matches(class_1937 level, class_2338 pos) {
        return false;
    }

    @Override
    public void assembleInWorld(class_1937 level, class_2338 pos) {
    }

    @Override
    public class_2248 getResultBlock() {
        return this.result;
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    @Override
    public BlockRecipeSerializer<?> getSerializer() {
        return BlockRecipeSerializer.DRILL_BORING;
    }

    @Override
    public BlockRecipeType<?> getType() {
        return BlockRecipeType.DRILL_BORING;
    }

    public List<class_1799> ingredients() {
        return this.input.getBlockItems();
    }

    public class_2680 getResultState(class_2680 input) {
        class_2680 state = this.getResultBlock().method_9564();
        for (class_2769 property : input.method_28501()) {
            if (!state.method_28498(property)) continue;
            state = DrillBoringBlockRecipe.copyProperty(input, state, property);
        }
        return state;
    }

    private static <T extends Comparable<T>> class_2680 copyProperty(class_2680 src, class_2680 dest, class_2769<T> property) {
        return (class_2680)dest.method_11657(property, src.method_11654(property));
    }

    public static class Serializer
    implements BlockRecipeSerializer<DrillBoringBlockRecipe> {
        @Override
        public DrillBoringBlockRecipe fromJson(class_2960 id, JsonObject obj) {
            BlockRecipeIngredient input = BlockRecipeIngredient.fromJson(obj.get("input"));
            class_2248 result = CBCRegistryUtils.getBlock(CBCUtils.location(obj.get("result").getAsString()));
            boolean obeyFacing = !obj.has("obey_facing_or_axis") || obj.get("obey_facing_or_axis").getAsBoolean();
            return new DrillBoringBlockRecipe(id, input, result, obeyFacing);
        }

        @Override
        public DrillBoringBlockRecipe fromNetwork(class_2960 id, class_2540 buf) {
            BlockRecipeIngredient input = BlockRecipeIngredient.fromNetwork(buf);
            class_2248 result = CBCRegistryUtils.getBlock(buf.method_10810());
            boolean obeyFacing = buf.readBoolean();
            return new DrillBoringBlockRecipe(id, input, result, obeyFacing);
        }

        @Override
        public void toNetwork(class_2540 buf, DrillBoringBlockRecipe recipe) {
            recipe.input.toNetwork(buf);
            buf.method_10812(CBCRegistryUtils.getBlockLocation(recipe.result)).writeBoolean(recipe.obeyFacingOrAxis);
        }
    }
}

