/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage.barrel;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.blocks.storage.AbstractStorageBlockItem;
import aztech.modern_industrialization.blocks.storage.StorageBehaviour;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlock;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelTooltipData;
import aztech.modern_industrialization.items.ItemContainingItemHelper;
import aztech.modern_industrialization.util.TextHelper;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3532;
import net.minecraft.class_5251;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;

public class BarrelItem
extends AbstractStorageBlockItem<ItemVariant>
implements ItemContainingItemHelper {
    private static final int ITEM_BAR_COLOR = class_3532.method_15353((float)0.4f, (float)0.4f, (float)1.0f);

    public BarrelItem(BarrelBlock block, FabricItemSettings settings) {
        super(block, settings.method_7889(1));
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        StorageBehaviour storageBehaviour = this.behaviour;
        if (storageBehaviour instanceof BarrelBlock.BarrelStorage) {
            BarrelBlock.BarrelStorage barrelStorage = (BarrelBlock.BarrelStorage)storageBehaviour;
            class_2583 style = class_2583.field_24360.method_27703(class_5251.method_27717((int)0xA9A9A9)).method_10978(Boolean.valueOf(false));
            if (this.isEmpty(stack) && this.isUnlocked(stack)) {
                tooltip.add((class_2561)MIText.Empty.text().method_10862(style));
                tooltip.add((class_2561)MIText.BarrelStack.text(barrelStorage.stackCapacity).method_10862(TextHelper.YELLOW));
            }
        }
        super.method_7851(stack, world, tooltip, context);
    }

    public long getCurrentCapacity(class_1799 stack) {
        return this.behaviour.getCapacityForResource(this.getResource(stack));
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        if (!this.getBehaviour().isCreative()) {
            if (!this.isEmpty(stack) || !this.isUnlocked(stack)) {
                return Optional.of(new BarrelTooltipData(this.getResource(stack), this.getAmount(stack), this.getCurrentCapacity(stack), false));
            }
        } else if (!this.getResource(stack).isBlank()) {
            return Optional.of(new BarrelTooltipData(this.getResource(stack), -1L, -1L, true));
        }
        return Optional.empty();
    }

    public boolean method_31567(class_1799 stack) {
        return !this.getBehaviour().isCreative() && this.getAmount(stack) > 0L;
    }

    public int method_31569(class_1799 stack) {
        return (int)Math.min(1L + 12L * this.getAmount(stack) / this.getCurrentCapacity(stack), 13L);
    }

    public int method_31571(class_1799 stack) {
        return ITEM_BAR_COLOR;
    }

    public boolean method_31565(class_1799 stackBarrel, class_1735 slot, class_5536 clickType, class_1657 player) {
        return this.handleStackedOnOther(stackBarrel, slot, clickType, player);
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        return this.handleOtherStackedOnMe(stack, otherStack, slot, clickType, player, cursorStackReference);
    }
}

