/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.advancement;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.datagen.translation.TranslationProvider;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricAdvancementProvider;
import net.minecraft.class_161;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class MIAdvancementsProvider
extends FabricAdvancementProvider {
    private final TranslationProvider translations;

    public MIAdvancementsProvider(FabricDataOutput packOutput, TranslationProvider translations) {
        super(packOutput);
        this.translations = translations;
    }

    public void generateAdvancement(Consumer<class_161> consumer) {
        class_161 guidebook = this.createBasic(consumer, "guidebook", null, "Modern Industrialization", "Obtain the Modern Industrialization guidebook.");
        class_161 forgeHammer = this.createBasic(consumer, "forge_hammer", guidebook, class_189.field_1249, "Is This A Forge Mod?", "Craft a Forge Hammer and start exploring the mod.");
        class_161 steamMiningDrill = this.createBasic(consumer, "steam_mining_drill", forgeHammer, class_189.field_1249, "Getting That 3x3 Going", "Craft a Steam Mining Drill");
        class_161 fireClayBricks = this.createBasic(consumer, "fire_clay_bricks", forgeHammer, "Almost Steam?", "Craft Fire Clay Bricks");
        class_161 bronzeFurnace = this.createBasic(consumer, "bronze_furnace", fireClayBricks, "Ten Times More Fuel Efficient", "Craft a Bronze Furnace");
        class_161 bronzeCompressor = this.createBasic(consumer, "bronze_compressor", forgeHammer, "An Automatic Forge Mod", "Craft a Bronze Compressor");
        class_161 bronzeMixer = this.createBasic(consumer, "bronze_mixer", forgeHammer, "Mixing Without Mixins", "Craft a Bronze Mixer");
        class_161 bronzeMacerator = this.createBasic(consumer, "bronze_macerator", forgeHammer, "Ore Hemiquadrupling", "Craft a Bronze Macerator");
        class_161 cokeOven = this.createBasic(consumer, "coke_oven", forgeHammer, class_189.field_1249, "Coke-A Cola", "Craft a Coke Oven to start Steel Production");
        class_161 steamBlastFurnace = this.createBasic(consumer, "steam_blast_furnace", fireClayBricks, "Almost Steel!", "Craft a Steam Blast Furnace");
        class_161 steelMachineCasing = this.createBasic(consumer, "steel_machine_casing", steamBlastFurnace, class_189.field_1249, "Cooked Uncooked Steel!", "Use a Steam Blast Furnace to produce Steel and craft a Steel Machine Casing");
        class_161 steelWiremill = this.createBasic(consumer, "steel_wiremill", steelMachineCasing, "Neither a Wire nor a Mill", "Craft a Steel Wiremill");
        class_161 steamQuarry = this.createBasic(consumer, "steam_quarry", steelMachineCasing, "From Minecraft to Craft", "Craft a Steam Quarry and say goodbye to mining");
        class_161 steelPacket = this.createBasic(consumer, "steel_packer", steelMachineCasing, "To Pack Or Not To Pack", "Craft a Steel Packer");
        class_161 inductor = this.createBasic(consumer, "inductor", steelWiremill, "The L in RLC", "Craft an Inductor");
        class_161 resistor = this.createBasic(consumer, "resistor", steelWiremill, "The R in RLC", "Craft a Resistor");
        class_161 capacitor = this.createBasic(consumer, "capacitor", steelWiremill, "The C in RLC", "Craft a Capacitor");
        class_161 analogCircuit = this.createBasic(consumer, "analog_circuit", resistor, class_189.field_1249, "RLC Circuits", "Craft an Analog Circuit and start the Electric Age");
        class_161 lvSteamTurbine = this.createBasic(consumer, "lv_steam_turbine", analogCircuit, "Better Than Solar Panels", "Craft a Steam Turbine");
        class_161 polarizer = this.createBasic(consumer, "polarizer", lvSteamTurbine, "One Recipe (+2) To Rule Them All", "Craft a Polarizer");
        class_161 largeSteamBoiler = this.createBasic(consumer, "large_steam_boiler", analogCircuit, "Kiss Your Fuel Goodbye!", "Craft a Large Steam Boiler");
        class_161 assembler = this.createBasic(consumer, "assembler", analogCircuit, class_189.field_1249, "Avengers, Assemble!", "Craft an Assembler");
        class_161 mvLvTransformer = this.createBasic(consumer, "mv_lv_transformer", analogCircuit, "Optimus Prime!", "Craft an MV to LV Transformer");
        class_161 electricBlastFurnace = this.createBasic(consumer, "electric_blast_furnace", lvSteamTurbine, class_189.field_1249, "Electric Best Friend", "Craft an Electric Blast Furnace to start producing Aluminum");
        class_161 electronicCircuit = this.createBasic(consumer, "electronic_circuit", electricBlastFurnace, "The Power of Silicon", "Craft a Electronic Circuit");
        class_161 centrifuge = this.createBasic(consumer, "centrifuge", electronicCircuit, "Actually It's The Centripetal Force", "Craft a Centrifuge");
        class_161 electrolyzer = this.createBasic(consumer, "electrolyzer", electronicCircuit, "It's Got What Plants Crave", "Craft an Electrolyzer");
        class_161 chemicalReactor = this.createBasic(consumer, "chemical_reactor", electronicCircuit, "Walter White Approves", "Craft a Chemical Reactor");
        class_161 distillery = this.createBasic(consumer, "distillery", electronicCircuit, "Al Capone Approves", "Craft a Distillery");
        class_161 electricQuarry = this.createBasic(consumer, "electric_quarry", electronicCircuit, class_189.field_1250, "Resource Goes BRRRRRR!!!", "Craft an Electric Quarry");
        class_161 oilDrillingRig = this.createBasic(consumer, "oil_drilling_rig", electronicCircuit, class_189.field_1249, "Bringing Freedom To Your Country", "Craft an Oil Drilling Rig");
        class_161 vacuumFreezer = this.createBasic(consumer, "vacuum_freezer", electronicCircuit, class_189.field_1249, "Enslaved Winter", "Craft a Vacuum Freezer");
        class_161 mvSteamTurbine = this.createBasic(consumer, "mv_steam_turbine", electronicCircuit, class_189.field_1249, "Better Than Wind Mills", "Craft an Advanced Steam Turbine");
        class_161 dieselGenerator = this.createBasic(consumer, "mv_diesel_generator", distillery, "Fast and Furious", "Craft an MV Diesel Generator");
        class_161 dieselJetpack = this.createBasic(consumer, "diesel_jetpack", distillery, class_189.field_1250, "Ely... We Meant Jetpack!", "Craft a Diesel Jetpack");
        class_161 dieselChainsaw = this.createBasic(consumer, "diesel_chainsaw", distillery, class_189.field_1250, "The Texas Chain Saw Massacre", "Craft a Diesel Chainsaw");
        class_161 dieselMiningDrill = this.createBasic(consumer, "diesel_mining_drill", distillery, class_189.field_1250, "Through The Walls Of Ba Sing Se", "Craft a Diesel Mining Drill");
        class_161 digitalCircuit = this.createBasic(consumer, "digital_circuit", distillery, "No need for Sodium anymore", "Craft a Digital Circuit");
        class_161 turboDieselGenerator = this.createBasic(consumer, "hv_diesel_generator", dieselGenerator, "Fast and Furious 2 : Revenge", "Craft an HV Diesel Generator");
        class_161 largeDieselGenerator = this.createBasic(consumer, "large_diesel_generator", turboDieselGenerator, "Fast and Furious 42 : Armageddon", "Craft a Large Diesel Generator");
        class_161 hvSteamTurbine = this.createBasic(consumer, "hv_steam_turbine", mvSteamTurbine, "Better than Water Wheel", "Craft an HV Steam Turbine");
        class_161 largeSteamTurbine = this.createBasic(consumer, "large_steam_turbine", hvSteamTurbine, "Enslaved Hurricane", "Craft a Large Steam Turbine");
        class_161 distillationTower = this.createBasic(consumer, "distillation_tower", digitalCircuit, class_189.field_1249, "TOTAL\u2122 Distillation", "Craft a Distillation Tower to unlock to full potential of oil processing");
        class_161 heatExchanger = this.createBasic(consumer, "heat_exchanger", digitalCircuit, "Lava Power but Balanced", "Craft a Heat Exchanger to avoid losing high pressure (and cheese easy energy from lava production)");
        class_161 stainlessSteel = this.createBasic(consumer, "stainless_steel_ingot", vacuumFreezer, class_189.field_1249, "Invar with Slot Locking", "Craft a Stainless Steel Ingot");
        class_161 kanthalCoil = this.createBasic(consumer, "kanthal_coil", stainlessSteel, "Electric Better Furnace", "Craft a Kanthal Coil to unlock new EBF recipes");
        class_161 processingUnit = this.createBasic(consumer, "processing_unit", kanthalCoil, "Bitcoin Miner", "Craft a Processing Unit");
        class_161 titaniumIngot = this.createBasic(consumer, "titanium_ingot", kanthalCoil, "Steel but Pink", "Craft a Titanium Ingot");
        class_161 blastProofAlloyPlate = this.createBasic(consumer, "blastproof_alloy_plate", titaniumIngot, "Creeper Nightmare", "Craft a Blastproof Alloy Plate in the compressor");
        class_161 implosionCompressor = this.createBasic(consumer, "implosion_compressor", blastProofAlloyPlate, class_189.field_1249, "Automated Creeper", "Craft an Implosion Compressor");
        class_161 pressurizer = this.createBasic(consumer, "pressurizer", titaniumIngot, "Under Pressure", "Craft a Pressurizer to unlock for efficient Steam Process");
        class_161 rawIridium = this.createBasic(consumer, "raw_iridium", titaniumIngot, "Diamond 2.0 : Electric Boogaloo", "Obtain a Raw Piece of Iridium");
        class_161 superconductorCable = this.createBasic(consumer, "superconductor_cable", rawIridium, class_189.field_1249, "Unlimited Power (Transfer)", "Craft a Superconductor Cable to transfer unlimited amount of energy");
        class_161 gravichestplate = this.createBasic(consumer, "gravichestplate", superconductorCable, class_189.field_1250, "Gravichestplate\u2122", "Craft a Gravichestplate to unlock creative flight");
        class_161 nuclearReactor = this.createBasic(consumer, "nuclear_reactor", implosionCompressor, class_189.field_1250, "3.6 Roentgen", "Craft a Nuclear Reactor and discover its overengineered mechanisms");
        class_161 nuke = this.createBasic(consumer, "nuke", nuclearReactor, "I've become Death, Destroyer of Worlds", "Craft a Nuke");
        class_161 singularity = this.createBasic(consumer, "singularity", nuke, "Pocket Black Hole", "Craft a Singularity");
        class_161 mixedIngotIridium = this.createBasic(consumer, "mixed_ingot_iridium", implosionCompressor, "Oreo Ingot", "Craft a Mixed Ingot Iridium to craft Iridium Plates");
        class_161 quantumCircuit = this.createBasic(consumer, "quantum_circuit", mixedIngotIridium, class_189.field_1249, "Mobius Strip Eigenvalues", "Craft a Quantum Circuit");
        class_161 fusionReactor = this.createBasic(consumer, "fusion_reactor", quantumCircuit, class_189.field_1250, "Enslaved Star Core", "Craft a Fusion Reactor to produce insane amount of energy");
        class_161 plasmaTurbine = this.createBasic(consumer, "plasma_turbine", fusionReactor, "Better than Nuclear Fission", "Craft a Plasma Turbine to transform Helium Plasma into energy");
        class_161 basicUpgrade = this.createBasic(consumer, "basic_upgrade", chemicalReactor, class_189.field_1249, "Machine Speedup", "Craft a Basic Upgrade to increase the maximum speed of an electric recipe");
        class_161 advancedUpgrade = this.createBasic(consumer, "advanced_upgrade", electronicCircuit, "Machine Speedup-Speedup", "Craft a Advanced Upgrade");
        class_161 turboUpgrade = this.createBasic(consumer, "turbo_upgrade", digitalCircuit, "Gotta go Fast", "Craft a Turbo Upgrade");
        class_161 highlyAdvancedUpgrade = this.createBasic(consumer, "highly_advanced_upgrade", processingUnit, "I'm speed", "Craft an Highly Advanced Upgrade");
        class_161 quantumUpgrade = this.createBasic(consumer, "quantum_upgrade", quantumCircuit, class_189.field_1249, "Time Dilation", "Craft a Quantum Upgrade to unlock unlimited recipe speed");
        class_161 replicator = this.createBasic(consumer, "replicator", quantumUpgrade, class_189.field_1250, "Legal Duping", "Craft a Replicator and replicate any item you want using UU Matter");
        class_161 uuMatter = this.createBasic(consumer, "uu_matter_bucket", singularity, class_189.field_1249, "Liquid Creative Mode", "Produce a bucket of UU Matter to start duplication in the replicator");
        class_161 quantumSword = this.createBasic(consumer, "quantum_sword", quantumUpgrade, class_189.field_1250, "Annihilation Operator", "Craft a Quantum Sword and disintegrate your foes (or the Wandering Trader llama's)");
        class_161 quantumChestplate = this.createBasic(consumer, "quantum_chestplate", quantumUpgrade, class_189.field_1250, "Quantum Immortality\u2122", "Craft a Quantum Chestplate to reduce the probability of taking any damage by 25% for each piece of the Quantum Armor Set");
    }

    private class_161 createBasic(Consumer<class_161> consumer, String item, @Nullable class_161 parent, String titleEnglishName, String englishDescription) {
        return this.createBasic(consumer, item, parent, class_189.field_1254, titleEnglishName, englishDescription);
    }

    private class_161 createBasic(Consumer<class_161> consumer, String itemId, @Nullable class_161 parent, class_189 frame, String titleEnglishName, String englishDescription) {
        class_1792 item = (class_1792)class_7923.field_41178.method_10223((class_2960)new MIIdentifier(itemId));
        String titleKey = "advancements.modern_industrialization." + itemId;
        String descKey = "advancements.modern_industrialization." + itemId + ".description";
        class_161.class_162 advancementTask = class_161.class_162.method_707();
        MIIdentifier background = null;
        if (parent != null) {
            advancementTask.method_701(parent);
        } else {
            background = new MIIdentifier("textures/block/fire_clay_bricks.png");
        }
        advancementTask.method_697((class_1935)item, (class_2561)class_2561.method_43471((String)titleKey), (class_2561)class_2561.method_43471((String)descKey), (class_2960)background, frame, true, true, false);
        advancementTask.method_709("checkInv", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{item}));
        class_161 advancement = advancementTask.method_695((class_2960)new MIIdentifier(itemId));
        consumer.accept(advancement);
        this.translations.addTranslation(titleKey, titleEnglishName);
        this.translations.addTranslation(descKey, englishDescription);
        return advancement;
    }
}

