/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.recipe;

import aztech.modern_industrialization.datagen.recipe.MIRecipesProvider;
import aztech.modern_industrialization.recipe.json.MIRecipeJson;
import aztech.modern_industrialization.recipe.json.ShapedRecipeJson;
import com.google.gson.Gson;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3259;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_6861;
import org.apache.commons.io.IOUtils;

public class AssemblerRecipesProvider
extends MIRecipesProvider {
    private static final Gson GSON = new Gson();
    private final FabricDataOutput packOutput;

    public AssemblerRecipesProvider(FabricDataOutput packOutput) {
        super(packOutput);
        this.packOutput = packOutput;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void method_10419(Consumer<class_2444> consumer) {
        Path nonGeneratedResources = this.packOutput.method_45971().resolve("../../main/resources");
        try (class_6861 manager = new class_6861(class_3264.field_14190, List.of(new class_3259("ngr", nonGeneratedResources, true)));){
            Map possibleTargets = manager.method_14488("recipes", path -> path.method_12832().endsWith(".json"));
            for (Map.Entry entry : possibleTargets.entrySet()) {
                class_2960 pathId = (class_2960)entry.getKey();
                if (!AssemblerRecipesProvider.shouldConvertToAssembler(pathId)) continue;
                try {
                    InputStream stream = ((class_3298)entry.getValue()).method_14482();
                    try {
                        AssemblerRecipesProvider.convertToAssembler(consumer, pathId, IOUtils.toByteArray((InputStream)stream));
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to convert asbl recipe %s. Error: %s".formatted(pathId, exception), exception);
                    return;
                }
            }
        }
    }

    public static boolean shouldConvertToAssembler(class_2960 pathId) {
        if (pathId.method_12836().equals("modern_industrialization")) {
            String path = pathId.toString();
            String postfix = path.substring(path.length() - 10, path.length() - 5);
            if (postfix.equals("_asbl")) {
                return true;
            }
            if (postfix.contains("_") && postfix.contains("a") && postfix.contains("s") && postfix.contains("b") && postfix.contains("l")) {
                throw new RuntimeException("Detected potential typo in _asbl.json. Crashing just to be safe. Recipe path: " + path);
            }
        }
        return false;
    }

    public static void convertToAssembler(Consumer<class_2444> consumer, class_2960 recipeId, byte[] recipe) {
        String recipeString = new String(recipe, StandardCharsets.UTF_8);
        ShapedRecipeJson json = (ShapedRecipeJson)GSON.fromJson(recipeString, ShapedRecipeJson.class);
        if (json.result.count == 0) {
            json.result.count = 1;
        }
        MIRecipeJson<?> assemblerJson = json.exportToAssembler();
        String outputSuffix = recipeId.method_12832().substring("recipes/".length(), recipeId.method_12832().length() - "_asbl.json".length());
        assemblerJson.offerTo(consumer, "assembler_generated/" + outputSuffix);
    }
}

