/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes;

import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.debug.DebugCommands;
import aztech.modern_industrialization.definition.ItemDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.pipes.PipeColor;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetwork;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetworkData;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetworkNode;
import aztech.modern_industrialization.pipes.fluid.FluidNetwork;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkData;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkNode;
import aztech.modern_industrialization.pipes.fluid.FluidPipeScreenHandler;
import aztech.modern_industrialization.pipes.impl.PipeBlock;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeItem;
import aztech.modern_industrialization.pipes.impl.PipePackets;
import aztech.modern_industrialization.pipes.item.ItemNetwork;
import aztech.modern_industrialization.pipes.item.ItemNetworkData;
import aztech.modern_industrialization.pipes.item.ItemNetworkNode;
import aztech.modern_industrialization.pipes.item.ItemPipeScreenHandler;
import aztech.modern_industrialization.proxy.CommonProxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_3917;
import net.minecraft.class_4970;
import net.minecraft.class_7923;

public class MIPipes {
    public static final MIPipes INSTANCE = new MIPipes();
    public static final class_2248 BLOCK_PIPE = new PipeBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_16005).method_36557(2.0f));
    public static class_2591<PipeBlockEntity> BLOCK_ENTITY_TYPE_PIPE;
    private final Map<PipeNetworkType, PipeItem> pipeItems = new HashMap<PipeNetworkType, PipeItem>();
    public static final Map<PipeItem, CableTier> ELECTRICITY_PIPE_TIER;
    public static final class_3917<ItemPipeScreenHandler> SCREEN_HANDLER_TYPE_ITEM_PIPE;
    public static final class_3917<FluidPipeScreenHandler> SCREEN_HANDLER_TYPE_FLUID_PIPE;
    public static final Set<class_2960> ITEM_PIPE_MODELS;

    public void setup() {
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new MIIdentifier("pipe"), (Object)BLOCK_PIPE);
        BLOCK_ENTITY_TYPE_PIPE = (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)new MIIdentifier("pipe"), (Object)FabricBlockEntityTypeBuilder.create(PipeBlockEntity::new, (class_2248[])new class_2248[]{BLOCK_PIPE}).build(null));
        for (PipeColor color : PipeColor.values()) {
            this.registerFluidPipeType(color);
        }
        for (PipeColor color : PipeColor.values()) {
            this.registerItemPipeType(color);
        }
        if (MIConfig.loadAe2Compat()) {
            try {
                Class.forName("aztech.modern_industrialization.compat.ae2.MIAEAddon").getMethod("onInitializePipes", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        this.registerPackets();
        DebugCommands.init();
    }

    private void registerFluidPipeType(PipeColor color) {
        String pipeId = color.prefix + "fluid_pipe";
        PipeNetworkType type = PipeNetworkType.register(new MIIdentifier(pipeId), (id, data) -> new FluidNetwork((int)id, (PipeNetworkData)data, 81000), FluidNetworkNode::new, color.color, true);
        ItemDefinition<PipeItem> itemDef = MIItem.itemNoModel(color.englishNamePrefix + "Fluid Pipe", pipeId, prop -> new PipeItem((class_1792.class_1793)prop, type, new FluidNetworkData(FluidVariant.blank())), SortOrder.PIPES);
        PipeItem item = itemDef.method_8389();
        this.pipeItems.put(type, item);
        ITEM_PIPE_MODELS.add(new MIIdentifier("item/" + pipeId));
        TagsToGenerate.generateTag(MITags.FLUID_PIPES, (class_1792)item, "Fluid Pipes");
    }

    private void registerItemPipeType(PipeColor color) {
        String pipeId = color.prefix + "item_pipe";
        PipeNetworkType type = PipeNetworkType.register(new MIIdentifier(pipeId), ItemNetwork::new, ItemNetworkNode::new, color.color, true);
        ItemDefinition<PipeItem> itemDef = MIItem.itemNoModel(color.englishNamePrefix + "Item Pipe", pipeId, prop -> new PipeItem((class_1792.class_1793)prop, type, new ItemNetworkData()), SortOrder.PIPES);
        PipeItem item = itemDef.method_8389();
        this.pipeItems.put(type, item);
        ITEM_PIPE_MODELS.add(new MIIdentifier("item/" + pipeId));
        TagsToGenerate.generateTag(MITags.ITEM_PIPES, (class_1792)item, "Item Pipes");
    }

    public void registerCableType(String englishName, String name, int color, CableTier tier) {
        String cableId = name + "_cable";
        PipeNetworkType type = PipeNetworkType.register(new MIIdentifier(cableId), (id, data) -> new ElectricityNetwork((int)id, (PipeNetworkData)data, tier), ElectricityNetworkNode::new, color, false);
        ItemDefinition<PipeItem> itemDef = MIItem.itemNoModel(englishName, cableId, prop -> new PipeItem((class_1792.class_1793)prop, type, new ElectricityNetworkData()), SortOrder.CABLES.and(tier));
        PipeItem item = itemDef.method_8389();
        this.pipeItems.put(type, item);
        ELECTRICITY_PIPE_TIER.put(item, tier);
        ITEM_PIPE_MODELS.add(new MIIdentifier("item/" + cableId));
    }

    public void register(PipeNetworkType type, PipeItem item) {
        if (this.pipeItems.containsKey(type)) {
            throw new IllegalStateException("Type " + type + " already registered");
        }
        this.pipeItems.put(type, item);
    }

    public PipeItem getPipeItem(PipeNetworkType type) {
        return this.pipeItems.get(type);
    }

    public void registerPackets() {
        CommonProxy.INSTANCE.registerUnsidedPacket(PipePackets.SET_ITEM_WHITELIST, PipePackets.ON_SET_ITEM_WHITELIST);
        CommonProxy.INSTANCE.registerUnsidedPacket(PipePackets.SET_CONNECTION_TYPE, PipePackets.ON_SET_CONNECTION_TYPE);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PipePackets.INCREMENT_PRIORITY, (ServerPlayNetworking.PlayChannelHandler)PipePackets.ON_INCREMENT_PRIORITY);
        CommonProxy.INSTANCE.registerUnsidedPacket(PipePackets.SET_NETWORK_FLUID, PipePackets.ON_SET_NETWORK_FLUID);
    }

    static {
        ELECTRICITY_PIPE_TIER = new HashMap<PipeItem, CableTier>();
        SCREEN_HANDLER_TYPE_ITEM_PIPE = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)new MIIdentifier("item_pipe"), (Object)new ExtendedScreenHandlerType(ItemPipeScreenHandler::new));
        SCREEN_HANDLER_TYPE_FLUID_PIPE = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)new MIIdentifier("fluid_pipe"), (Object)new ExtendedScreenHandlerType(FluidPipeScreenHandler::new));
        ITEM_PIPE_MODELS = new HashSet<class_2960>();
    }
}

