/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.foundation.utility.VoxelShaper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_3532;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class EscalatorVoxelShaper {
    private static final int STEP_COUNT = 32;
    protected final List<VoxelShaper> shapes;

    protected EscalatorVoxelShaper(List<VoxelShaper> shapes) {
        this.shapes = shapes;
    }

    public class_265 getShape(float visualOffset, class_2350 facing) {
        int sz = this.shapes.size();
        if (facing == class_2350.field_11043 || facing == class_2350.field_11034) {
            visualOffset *= -1.0f;
        }
        int index = class_3532.method_15375((float)((visualOffset % 0.5f + 1.0f) % 0.5f / 0.5f * (float)sz)) % sz;
        return this.shapes.get(index).get(facing);
    }

    public static EscalatorVoxelShaper createEscalatorStepShapes(class_265 baseShape, class_2350 facing, WalkwaySlope slope) {
        return EscalatorVoxelShaper.createEscalatorStepShapes(baseShape, facing, slope, 32);
    }

    public static EscalatorVoxelShaper createEscalatorStepShapes(class_265 baseShape, class_2350 facing, WalkwaySlope slope, int stepCount) {
        if (facing.method_10166().method_10178()) {
            throw new IllegalStateException("Cannot initialize escalator step shaper with facing={UP,DOWN}");
        }
        if (slope == WalkwaySlope.HORIZONTAL || slope == WalkwaySlope.TERMINAL) {
            throw new IllegalStateException("Cannot initialize escalator step shaper with slope={HORIZONTAL,TERMINAL}");
        }
        ArrayList<VoxelShaper> shapes = new ArrayList<VoxelShaper>();
        class_265 stepShape = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
        Vector3f dirVec = class_2350.field_11035.method_23955();
        class_265 mask = class_2248.method_9541((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
        for (int offset = 0; offset < stepCount; ++offset) {
            float visualOffset = 0.5f * (float)offset / (float)stepCount;
            class_265 finalShape = baseShape;
            for (int step = -1; step < 2; ++step) {
                float f = (float)step * 0.5f + visualOffset;
                Vector3f horizOffset = new Vector3f((Vector3fc)dirVec).mul(f);
                float vertOffset = f;
                if (slope == WalkwaySlope.TOP) {
                    vertOffset = Math.min(vertOffset, 0.5f);
                }
                if (slope == WalkwaySlope.BOTTOM) {
                    vertOffset = Math.max(vertOffset, 0.5f);
                }
                Vector3f offsetVec = new Vector3f().add((Vector3fc)horizOffset).add(0.0f, vertOffset - 0.03125f, 0.0f);
                class_265 copyStep = stepShape.method_1096((double)offsetVec.x, (double)offsetVec.y, (double)offsetVec.z);
                copyStep = class_259.method_1072((class_265)copyStep, (class_265)mask, (class_247)class_247.field_16896);
                finalShape = class_259.method_1084((class_265)finalShape, (class_265)copyStep);
            }
            shapes.add(VoxelShaper.forHorizontal((class_265)finalShape, (class_2350)class_2350.field_11035));
        }
        return new EscalatorVoxelShaper(shapes);
    }
}

